/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.UnsafeAccess;
import org.agrona.collections.Long2ObjectCache;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.ExistingBufferFactory;
import uk.co.real_logic.artio.engine.logger.RecordingRange;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.engine.logger.ReplayOperation;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordDecoder;

public class ReplayQuery
implements AutoCloseable {
    private final MessageHeaderDecoder messageFrameHeader = new MessageHeaderDecoder();
    private final ReplayIndexRecordDecoder indexRecord = new ReplayIndexRecordDecoder();
    private final LongFunction<SessionQuery> newSessionQuery = x$0 -> new SessionQuery(x$0);
    private final Long2ObjectCache<SessionQuery> fixSessionToIndex;
    private final String logFileDir;
    private final ExistingBufferFactory indexBufferFactory;
    private final int requiredStreamId;
    private final IdleStrategy idleStrategy;
    private final AeronArchive aeronArchive;
    private final ErrorHandler errorHandler;
    private final int archiveReplayStream;
    private Subscription replaySubscription;

    public ReplayQuery(String logFileDir, int cacheNumSets, int cacheSetSize, ExistingBufferFactory indexBufferFactory, int requiredStreamId, IdleStrategy idleStrategy, AeronArchive aeronArchive, ErrorHandler errorHandler, int archiveReplayStream) {
        this.logFileDir = logFileDir;
        this.indexBufferFactory = indexBufferFactory;
        this.requiredStreamId = requiredStreamId;
        this.idleStrategy = idleStrategy;
        this.aeronArchive = aeronArchive;
        this.errorHandler = errorHandler;
        this.archiveReplayStream = archiveReplayStream;
        this.fixSessionToIndex = new Long2ObjectCache(cacheNumSets, cacheSetSize, SessionQuery::close);
    }

    public ReplayOperation query(ControlledFragmentHandler handler, long sessionId, int beginSequenceNumber, int beginSequenceIndex, int endSequenceNumber, int endSequenceIndex, LogTag logTag) {
        return ((SessionQuery)this.fixSessionToIndex.computeIfAbsent(sessionId, this.newSessionQuery)).query(handler, beginSequenceNumber, beginSequenceIndex, endSequenceNumber, endSequenceIndex, logTag);
    }

    @Override
    public void close() {
        this.fixSessionToIndex.clear();
        CloseHelper.close((AutoCloseable)this.replaySubscription);
    }

    private final class SessionQuery
    implements AutoCloseable {
        private final ByteBuffer wrappedBuffer;
        private final long sessionId;
        private final UnsafeBuffer buffer;
        private final int capacity;

        SessionQuery(long sessionId) {
            this.wrappedBuffer = ReplayQuery.this.indexBufferFactory.map(ReplayIndexDescriptor.replayIndexFile(ReplayQuery.this.logFileDir, sessionId, ReplayQuery.this.requiredStreamId));
            this.buffer = new UnsafeBuffer(this.wrappedBuffer);
            this.capacity = ReplayIndexDescriptor.recordCapacity(this.buffer.capacity());
            this.sessionId = sessionId;
        }

        ReplayOperation query(ControlledFragmentHandler handler, int beginSequenceNumber, int beginSequenceIndex, int endSequenceNumber, int endSequenceIndex, LogTag logTag) {
            ReplayQuery.this.messageFrameHeader.wrap((DirectBuffer)this.buffer, 0);
            int actingBlockLength = ReplayQuery.this.messageFrameHeader.blockLength();
            int actingVersion = ReplayQuery.this.messageFrameHeader.version();
            boolean upToMostRecentMessage = endSequenceNumber == 0;
            ArrayList<RecordingRange> ranges = new ArrayList<RecordingRange>();
            RecordingRange currentRange = null;
            long iteratorPosition = this.getIteratorPosition();
            long stopIteratingPosition = iteratorPosition + (long)this.capacity;
            int lastSequenceNumber = -1;
            while (iteratorPosition != stopIteratingPosition) {
                long changePosition = ReplayIndexDescriptor.endChangeVolatile((AtomicBuffer)this.buffer);
                if (changePosition > iteratorPosition && iteratorPosition + (long)this.capacity <= ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)this.buffer)) {
                    iteratorPosition = changePosition;
                    stopIteratingPosition = iteratorPosition + (long)this.capacity;
                }
                int offset = ReplayIndexDescriptor.offset(iteratorPosition, this.capacity);
                ReplayQuery.this.indexRecord.wrap((DirectBuffer)this.buffer, offset, actingBlockLength, actingVersion);
                long beginPosition = ReplayQuery.this.indexRecord.position();
                int sequenceIndex = ReplayQuery.this.indexRecord.sequenceIndex();
                int sequenceNumber = ReplayQuery.this.indexRecord.sequenceNumber();
                long recordingId = ReplayQuery.this.indexRecord.recordingId();
                int readLength = ReplayQuery.this.indexRecord.length();
                UnsafeAccess.UNSAFE.loadFence();
                if (changePosition == ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)this.buffer)) {
                    boolean withinQueryRange;
                    boolean afterEnd;
                    ReplayQuery.this.idleStrategy.reset();
                    boolean bl = afterEnd = !upToMostRecentMessage && (sequenceIndex > endSequenceIndex || sequenceIndex == endSequenceIndex && sequenceNumber > endSequenceNumber);
                    if (beginPosition == 0L || afterEnd) break;
                    boolean bl2 = withinQueryRange = sequenceIndex > beginSequenceIndex || sequenceIndex == beginSequenceIndex && sequenceNumber >= beginSequenceNumber;
                    if (withinQueryRange) {
                        currentRange = this.addRange(ranges, currentRange, lastSequenceNumber, beginPosition, sequenceNumber, recordingId, readLength);
                        lastSequenceNumber = sequenceNumber;
                        iteratorPosition += 32L;
                        continue;
                    }
                    iteratorPosition = this.skipToStart(beginSequenceNumber, iteratorPosition, sequenceNumber);
                    continue;
                }
                ReplayQuery.this.idleStrategy.idle();
            }
            if (currentRange != null) {
                ranges.add(currentRange);
            }
            return this.newReplayOperation(handler, ranges, logTag);
        }

        private long skipToStart(int beginSequenceNumber, long iteratorPosition, int sequenceNumber) {
            if (sequenceNumber < beginSequenceNumber) {
                return this.jumpPosition(beginSequenceNumber, sequenceNumber, iteratorPosition);
            }
            return iteratorPosition + 32L;
        }

        private long jumpPosition(int beginSequenceNumber, int sequenceNumber, long iteratorPosition) {
            int sequenceNumberJump = beginSequenceNumber - sequenceNumber;
            return iteratorPosition + (long)(sequenceNumberJump * 32);
        }

        private ReplayOperation newReplayOperation(ControlledFragmentHandler handler, List<RecordingRange> ranges, LogTag logTag) {
            if (ReplayQuery.this.replaySubscription == null) {
                ReplayQuery.this.replaySubscription = ReplayQuery.this.aeronArchive.context().aeron().addSubscription("aeron:ipc", ReplayQuery.this.archiveReplayStream);
            }
            DebugLogger.log(logTag, "ReplayQuery : Built new replay operation with Recording Ranges: %s%n", ranges);
            return new ReplayOperation(handler, ranges, ReplayQuery.this.aeronArchive, ReplayQuery.this.errorHandler, ReplayQuery.this.replaySubscription, ReplayQuery.this.archiveReplayStream, logTag);
        }

        private RecordingRange addRange(List<RecordingRange> ranges, RecordingRange currentRange, int lastSequenceNumber, long beginPosition, int sequenceNumber, long recordingId, int readLength) {
            RecordingRange range = currentRange;
            if (range == null) {
                range = new RecordingRange(recordingId, this.sessionId);
            } else if (range.recordingId != recordingId) {
                ranges.add(range);
                range = new RecordingRange(recordingId, this.sessionId);
            }
            range.add(beginPosition - 32L, readLength + 32);
            if (lastSequenceNumber != sequenceNumber) {
                ++range.count;
            }
            return range;
        }

        private long getIteratorPosition() {
            long iteratorPosition = ReplayIndexDescriptor.beginChangeVolatile((AtomicBuffer)this.buffer);
            if (iteratorPosition < (long)this.capacity) {
                iteratorPosition = 0L;
            }
            return iteratorPosition;
        }

        @Override
        public void close() {
            if (this.wrappedBuffer instanceof MappedByteBuffer) {
                IoUtil.unmap((MappedByteBuffer)((MappedByteBuffer)this.wrappedBuffer));
            }
        }
    }
}

