/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.SequenceResetEncoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.engine.HeaderSetup;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class GapFillEncoder {
    private static final int ENCODE_BUFFER_SIZE = 1024;
    private final SequenceResetEncoder sequenceResetEncoder = new SequenceResetEncoder();
    private final UtcTimestampEncoder timestampEncoder = new UtcTimestampEncoder();
    private final MutableAsciiBuffer buffer = new MutableAsciiBuffer(new byte[1024]);

    GapFillEncoder() {
        this.sequenceResetEncoder.header().possDupFlag(true);
        this.sequenceResetEncoder.gapFillFlag(true);
    }

    long encode(int msgSeqNum, int newSeqNo) {
        HeaderEncoder respHeader = this.sequenceResetEncoder.header();
        respHeader.sendingTime(this.timestampEncoder.buffer(), this.timestampEncoder.encode(System.currentTimeMillis()));
        respHeader.msgSeqNum(msgSeqNum);
        this.sequenceResetEncoder.newSeqNo(newSeqNo);
        return this.sequenceResetEncoder.encode(this.buffer, 0);
    }

    void setupMessage(HeaderDecoder requestHeader) {
        HeaderSetup.setup(requestHeader, (SessionHeaderEncoder)this.sequenceResetEncoder.header());
    }

    MutableAsciiBuffer buffer() {
        return this.buffer;
    }
}

