/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.decoder.LogonDecoder;
import uk.co.real_logic.artio.decoder.UserRequestDecoder;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.HeaderSetup;
import uk.co.real_logic.artio.engine.framer.AcceptorLogonResult;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.DirectSessionProxy;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionParser;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.AuthenticationProxy;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;
import uk.co.real_logic.artio.validation.PersistenceLevel;
import uk.co.real_logic.artio.validation.SessionPersistenceStrategy;

class GatewaySessions {
    private final List<GatewaySession> sessions = new ArrayList<GatewaySession>();
    private final EpochClock epochClock;
    private final GatewayPublication outboundPublication;
    private final SessionIdStrategy sessionIdStrategy;
    private final SessionCustomisationStrategy customisationStrategy;
    private final FixCounters fixCounters;
    private final AuthenticationStrategy authenticationStrategy;
    private final MessageValidationStrategy validationStrategy;
    private final int sessionBufferSize;
    private final long sendingTimeWindowInMs;
    private final long reasonableTransmissionTimeInMs;
    private final boolean logAllMessages;
    private final SessionContexts sessionContexts;
    private final SessionPersistenceStrategy sessionPersistenceStrategy;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final UserRequestDecoder userRequest = new UserRequestDecoder();
    private ErrorHandler errorHandler;

    GatewaySessions(EpochClock epochClock, GatewayPublication outboundPublication, SessionIdStrategy sessionIdStrategy, SessionCustomisationStrategy customisationStrategy, FixCounters fixCounters, AuthenticationStrategy authenticationStrategy, MessageValidationStrategy validationStrategy, int sessionBufferSize, long sendingTimeWindowInMs, long reasonableTransmissionTimeInMs, boolean logAllMessages, ErrorHandler errorHandler, SessionContexts sessionContexts, SessionPersistenceStrategy sessionPersistenceStrategy, SequenceNumberIndexReader sentSequenceNumberIndex, SequenceNumberIndexReader receivedSequenceNumberIndex) {
        this.epochClock = epochClock;
        this.outboundPublication = outboundPublication;
        this.sessionIdStrategy = sessionIdStrategy;
        this.customisationStrategy = customisationStrategy;
        this.fixCounters = fixCounters;
        this.authenticationStrategy = authenticationStrategy;
        this.validationStrategy = validationStrategy;
        this.sessionBufferSize = sessionBufferSize;
        this.sendingTimeWindowInMs = sendingTimeWindowInMs;
        this.reasonableTransmissionTimeInMs = reasonableTransmissionTimeInMs;
        this.logAllMessages = logAllMessages;
        this.errorHandler = errorHandler;
        this.sessionContexts = sessionContexts;
        this.sessionPersistenceStrategy = sessionPersistenceStrategy;
        this.sentSequenceNumberIndex = sentSequenceNumberIndex;
        this.receivedSequenceNumberIndex = receivedSequenceNumberIndex;
    }

    static GatewaySession removeSessionByConnectionId(long connectionId, List<GatewaySession> sessions) {
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.connectionId() != connectionId) continue;
            sessions.remove(i);
            return session;
        }
        return null;
    }

    void acquire(GatewaySession gatewaySession, SessionState state, boolean awaitingResend, int heartbeatIntervalInS, int lastSentSequenceNumber, int lastReceivedSequenceNumber, String username, String password, BlockablePosition engineBlockablePosition) {
        long connectionId = gatewaySession.connectionId();
        AtomicCounter receivedMsgSeqNo = this.fixCounters.receivedMsgSeqNo(connectionId);
        AtomicCounter sentMsgSeqNo = this.fixCounters.sentMsgSeqNo(connectionId);
        MutableAsciiBuffer asciiBuffer = new MutableAsciiBuffer(new byte[this.sessionBufferSize]);
        DirectSessionProxy proxy = new DirectSessionProxy(this.sessionBufferSize, this.outboundPublication, this.sessionIdStrategy, this.customisationStrategy, this.epochClock, connectionId, 0);
        InternalSession session = new InternalSession(heartbeatIntervalInS, connectionId, this.epochClock, state, proxy, this.outboundPublication, this.sessionIdStrategy, this.sendingTimeWindowInMs, receivedMsgSeqNo, sentMsgSeqNo, 0, lastSentSequenceNumber + 1, 0, this.reasonableTransmissionTimeInMs, asciiBuffer, gatewaySession.enableLastMsgSeqNumProcessed());
        session.awaitingResend(awaitingResend);
        session.closedResendInterval(gatewaySession.closedResendInterval());
        session.resendRequestChunkSize(gatewaySession.resendRequestChunkSize());
        session.sendRedundantResendRequests(gatewaySession.sendRedundantResendRequests());
        SessionParser sessionParser = new SessionParser(session, this.validationStrategy, this.errorHandler);
        this.sessions.add(gatewaySession);
        gatewaySession.manage(sessionParser, session, engineBlockablePosition);
        CompositeKey sessionKey = gatewaySession.sessionKey();
        DebugLogger.log(LogTag.FIX_CONNECTION, "Gateway Acquired Session %d%n", connectionId);
        if (sessionKey != null) {
            gatewaySession.onLogon(username, password, heartbeatIntervalInS);
            session.initialLastReceivedMsgSeqNum(lastReceivedSequenceNumber);
        }
    }

    GatewaySession releaseBySessionId(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.remove(index);
    }

    GatewaySession sessionById(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.get(index);
    }

    private int indexBySessionId(long sessionId) {
        List<GatewaySession> sessions = this.sessions;
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.sessionId() != sessionId) continue;
            return i;
        }
        return -1;
    }

    void releaseByConnectionId(long connectionId) {
        GatewaySession session = GatewaySessions.removeSessionByConnectionId(connectionId, this.sessions);
        if (session != null) {
            session.close();
        }
    }

    int pollSessions(long time) {
        List<GatewaySession> sessions = this.sessions;
        int eventsProcessed = 0;
        int i = 0;
        int size = sessions.size();
        while (i < size) {
            GatewaySession session = sessions.get(i);
            eventsProcessed += session.poll(time);
            if (session.hasDisconnected()) {
                --size;
                continue;
            }
            ++i;
        }
        return eventsProcessed;
    }

    List<GatewaySession> sessions() {
        return this.sessions;
    }

    AcceptorLogonResult authenticate(LogonDecoder logon, long connectionId, GatewaySession gatewaySession, TcpChannel channel) {
        return new PendingAcceptorLogon(this.sessionIdStrategy, gatewaySession, logon, connectionId, this.sessionContexts, channel);
    }

    private boolean lookupSequenceNumbers(GatewaySession gatewaySession, long requiredPosition) {
        int aeronSessionId = this.outboundPublication.id();
        if (requiredPosition > 0L && this.sentSequenceNumberIndex.indexedPosition(aeronSessionId) < requiredPosition) {
            return false;
        }
        long sessionId = gatewaySession.sessionId();
        int lastSentSequenceNumber = this.sentSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        int lastReceivedSequenceNumber = this.receivedSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        gatewaySession.acceptorSequenceNumbers(lastSentSequenceNumber, lastReceivedSequenceNumber);
        return true;
    }

    void onUserRequest(DirectBuffer buffer, int offset, int length) {
        this.asciiBuffer.wrap(buffer);
        this.userRequest.reset();
        this.userRequest.decode(this.asciiBuffer, offset, length);
        this.authenticationStrategy.onUserRequest(this.userRequest);
    }

    private final class PendingAcceptorLogon
    implements AuthenticationProxy,
    AcceptorLogonResult {
        private static final long NO_REQUIRED_POSITION = -1L;
        private static final int ENCODE_BUFFER_SIZE = 1024;
        private final SessionIdStrategy sessionIdStrategy;
        private final LogonDecoder logon;
        private final SessionContexts sessionContexts;
        private final TcpChannel channel;
        private final boolean resetSeqNum;
        private volatile AuthenticationState state = AuthenticationState.PENDING;
        private GatewaySession session;
        private DisconnectReason reason;
        private long requiredPosition = -1L;
        private long lingerTimeoutInMs;
        private Encoder encoder;
        private ByteBuffer encodeBuffer;
        private long lingerExpiryTimeInMs;

        PendingAcceptorLogon(SessionIdStrategy sessionIdStrategy, GatewaySession gatewaySession, LogonDecoder logon, long connectionId, SessionContexts sessionContexts, TcpChannel channel) {
            this.sessionIdStrategy = sessionIdStrategy;
            this.session = gatewaySession;
            this.logon = logon;
            this.sessionContexts = sessionContexts;
            this.channel = channel;
            PersistenceLevel persistenceLevel = this.getPersistenceLevel(logon, connectionId);
            boolean resetSeqNumFlag = logon.hasResetSeqNumFlag() && logon.resetSeqNumFlag();
            boolean bl = this.resetSeqNum = SessionPersistenceStrategy.resetSequenceNumbersUponLogon(persistenceLevel) || resetSeqNumFlag;
            if (persistenceLevel == PersistenceLevel.INDEXED && !GatewaySessions.this.logAllMessages) {
                this.onError(new IllegalStateException("Persistence Strategy specified INDEXED but EngineConfiguration has disabled required logging of messsages"));
                this.reject(DisconnectReason.INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES);
                return;
            }
            this.authenticate(logon, connectionId);
        }

        private PersistenceLevel getPersistenceLevel(LogonDecoder logon, long connectionId) {
            try {
                return GatewaySessions.this.sessionPersistenceStrategy.getPersistenceLevel(logon);
            }
            catch (Throwable throwable) {
                this.onStrategyError("persistence", throwable, connectionId, "UNINDEXED", logon);
                return PersistenceLevel.UNINDEXED;
            }
        }

        private void authenticate(LogonDecoder logon, long connectionId) {
            try {
                GatewaySessions.this.authenticationStrategy.authenticateAsync(logon, this);
            }
            catch (Throwable throwable) {
                this.onStrategyError("authentication", throwable, connectionId, "false", logon);
                this.reject();
            }
        }

        private void onStrategyError(String strategyName, Throwable throwable, long connectionId, String theDefault, LogonDecoder logon) {
            String message = String.format("Exception thrown by %s strategy for connectionId=%d, processing [%s], defaulted to %s", strategyName, connectionId, logon.toString(), theDefault);
            this.onError(new FixGatewayException(message, throwable));
        }

        private void onError(Throwable throwable) {
            if (GatewaySessions.this.errorHandler == null) {
                LangUtil.rethrowUnchecked((Throwable)throwable);
            } else {
                GatewaySessions.this.errorHandler.onError(throwable);
            }
        }

        @Override
        public DisconnectReason reason() {
            return this.reason;
        }

        @Override
        public void accept() {
            this.validateState();
            this.state = AuthenticationState.AUTHENTICATED;
        }

        private void validateState() {
            AuthenticationState state = this.state;
            if (state != AuthenticationState.PENDING) {
                throw new IllegalStateException(String.format("Cannot reject and accept a pending operation at the same time (state=%s)", new Object[]{state}));
            }
        }

        @Override
        public boolean poll() {
            switch (this.state) {
                case AUTHENTICATED: {
                    this.onAuthenticated();
                    return false;
                }
                case ACCEPTED: 
                case REJECTED: {
                    return true;
                }
                case SENDING_REJECT_MESSAGE: {
                    return this.onSendingRejectMessage();
                }
                case LINGERING_REJECT_MESSAGE: {
                    return this.onLingerRejectMessage();
                }
                case INDEXER_CATCHUP: {
                    this.onIndexerCatchup();
                    return false;
                }
            }
            return false;
        }

        private boolean onLingerRejectMessage() {
            boolean complete;
            long timeInMs = GatewaySessions.this.epochClock.time();
            boolean bl = complete = timeInMs >= this.lingerExpiryTimeInMs;
            if (complete) {
                this.state = AuthenticationState.REJECTED;
            }
            return complete;
        }

        private boolean onSendingRejectMessage() {
            if (this.encodeBuffer == null) {
                try {
                    this.encodeRejectMessage();
                }
                catch (Exception e) {
                    GatewaySessions.this.errorHandler.onError((Throwable)e);
                    this.state = AuthenticationState.REJECTED;
                    return true;
                }
            }
            try {
                this.channel.write(this.encodeBuffer);
                if (!this.encodeBuffer.hasRemaining()) {
                    this.lingerExpiryTimeInMs = GatewaySessions.this.epochClock.time() + this.lingerTimeoutInMs;
                    this.state = AuthenticationState.LINGERING_REJECT_MESSAGE;
                }
            }
            catch (IOException e) {
                this.state = AuthenticationState.REJECTED;
                return true;
            }
            return false;
        }

        private void encodeRejectMessage() {
            this.encodeBuffer = ByteBuffer.allocateDirect(1024);
            UtcTimestampEncoder sendingTimeEncoder = new UtcTimestampEncoder();
            MutableAsciiBuffer asciiBuffer = new MutableAsciiBuffer(this.encodeBuffer);
            SessionHeaderEncoder header = this.encoder.header();
            header.msgSeqNum(1);
            header.sendingTime(sendingTimeEncoder.buffer(), sendingTimeEncoder.encode(GatewaySessions.this.epochClock.time()));
            HeaderSetup.setup(this.logon.header(), header);
            long result = this.encoder.encode(asciiBuffer, 0);
            int offset = Encoder.offset((long)result);
            int length = Encoder.length((long)result);
            ByteBufferUtil.position(this.encodeBuffer, offset);
            ByteBufferUtil.limit(this.encodeBuffer, offset + length);
        }

        private void onIndexerCatchup() {
            if (GatewaySessions.this.lookupSequenceNumbers(this.session, this.requiredPosition)) {
                this.state = AuthenticationState.ACCEPTED;
            }
        }

        private void onAuthenticated() {
            String username = SessionParser.username(this.logon);
            String password = SessionParser.password(this.logon);
            CompositeKey compositeKey = this.sessionIdStrategy.onAcceptLogon(this.logon.header());
            SessionContext sessionContext = this.sessionContexts.onLogon(compositeKey);
            if (sessionContext == SessionContexts.DUPLICATE_SESSION) {
                this.reject(DisconnectReason.DUPLICATE_SESSION);
                return;
            }
            sessionContext.onLogon(this.resetSeqNum);
            this.session.initialResetSeqNum(this.resetSeqNum);
            this.session.onLogon(sessionContext.sessionId(), sessionContext, compositeKey, username, password, this.logon.heartBtInt());
            if (this.resetSeqNum) {
                this.session.acceptorSequenceNumbers(-1, -1);
                this.state = AuthenticationState.ACCEPTED;
            } else {
                this.requiredPosition = GatewaySessions.this.outboundPublication.position();
                this.state = AuthenticationState.INDEXER_CATCHUP;
            }
        }

        @Override
        public void reject() {
            this.validateState();
            this.reject(DisconnectReason.FAILED_AUTHENTICATION);
        }

        @Override
        public void reject(Encoder encoder, long lingerTimeoutInMs) {
            Objects.requireNonNull(encoder, "encoder should be provided");
            if (lingerTimeoutInMs < 0L) {
                throw new IllegalArgumentException(String.format("lingerTimeoutInMs should not be negative, (%d)", lingerTimeoutInMs));
            }
            this.encoder = encoder;
            this.session = null;
            this.reason = DisconnectReason.FAILED_AUTHENTICATION;
            this.lingerTimeoutInMs = lingerTimeoutInMs;
            this.state = AuthenticationState.SENDING_REJECT_MESSAGE;
        }

        @Override
        public String remoteAddress() {
            return this.channel.remoteAddress();
        }

        private void reject(DisconnectReason reason) {
            this.validateState();
            this.session = null;
            this.reason = reason;
            this.state = AuthenticationState.REJECTED;
        }

        @Override
        public boolean isAccepted() {
            return AuthenticationState.ACCEPTED == this.state;
        }
    }

    static enum AuthenticationState {
        PENDING,
        AUTHENTICATED,
        INDEXER_CATCHUP,
        ACCEPTED,
        SENDING_REJECT_MESSAGE,
        LINGERING_REJECT_MESSAGE,
        REJECTED;

    }
}

