/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.SenderEndPoint;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionLogonListener;
import uk.co.real_logic.artio.session.SessionParser;

class GatewaySession
implements SessionInfo {
    private static final int NO_TIMEOUT = -1;
    private final long connectionId;
    private SessionContext context;
    private final String address;
    private final ConnectionType connectionType;
    private final boolean closedResendInterval;
    private final int resendRequestChunkSize;
    private final boolean sendRedundantResendRequests;
    private final boolean enableLastMsgSeqNumProcessed;
    private ReceiverEndPoint receiverEndPoint;
    private SenderEndPoint senderEndPoint;
    private long sessionId;
    private SessionParser sessionParser;
    private InternalSession session;
    private CompositeKey sessionKey;
    private String username;
    private String password;
    private int heartbeatIntervalInS;
    private long disconnectTimeout = -1L;
    private Consumer<GatewaySession> onGatewaySessionLogon;
    private SessionLogonListener logonListener = this::onSessionLogon;
    private boolean initialResetSeqNum;

    GatewaySession(long connectionId, SessionContext context, String address, ConnectionType connectionType, CompositeKey sessionKey, ReceiverEndPoint receiverEndPoint, SenderEndPoint senderEndPoint, Consumer<GatewaySession> onGatewaySessionLogon, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed) {
        this.connectionId = connectionId;
        this.sessionId = context.sessionId();
        this.context = context;
        this.address = address;
        this.connectionType = connectionType;
        this.sessionKey = sessionKey;
        this.receiverEndPoint = receiverEndPoint;
        this.senderEndPoint = senderEndPoint;
        this.onGatewaySessionLogon = onGatewaySessionLogon;
        this.closedResendInterval = closedResendInterval;
        this.resendRequestChunkSize = resendRequestChunkSize;
        this.sendRedundantResendRequests = sendRedundantResendRequests;
        this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
    }

    @Override
    public long connectionId() {
        return this.connectionId;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    @Override
    public CompositeKey sessionKey() {
        return this.sessionKey;
    }

    void manage(SessionParser sessionParser, InternalSession session, BlockablePosition blockablePosition) {
        this.sessionParser = sessionParser;
        this.session = session;
        this.session.logonListener(this.logonListener);
        this.receiverEndPoint.libraryId(0);
        this.senderEndPoint.libraryId(0, blockablePosition);
    }

    void handoverManagementTo(int libraryId, BlockablePosition blockablePosition) {
        this.setManagementTo(libraryId, blockablePosition);
        this.sessionParser = null;
        this.session.logonListener(null);
        this.context.updateAndSaveFrom(this.session);
        this.session.close();
        this.session = null;
    }

    void setManagementTo(int libraryId, BlockablePosition blockablePosition) {
        this.receiverEndPoint.libraryId(libraryId);
        this.receiverEndPoint.pause();
        this.senderEndPoint.libraryId(libraryId, blockablePosition);
    }

    void play() {
        this.receiverEndPoint.play();
    }

    int poll(long time) {
        return this.session.poll(time) + this.checkNoLogonDisconnect(time);
    }

    private int checkNoLogonDisconnect(long time) {
        if (this.disconnectTimeout == -1L) {
            return 0;
        }
        if (this.sessionKey != null) {
            this.disconnectTimeout = -1L;
            return 1;
        }
        if (this.disconnectTimeout <= time && !this.receiverEndPoint.hasDisconnected()) {
            this.receiverEndPoint.onNoLogonDisconnect();
            return 1;
        }
        return 0;
    }

    private void onSessionLogon(Session session) {
        this.context.updateFrom(session);
        this.onGatewaySessionLogon.accept(this);
    }

    InternalSession session() {
        return this.session;
    }

    ConnectionType connectionType() {
        return this.connectionType;
    }

    public void onMessage(DirectBuffer buffer, int offset, int length, int messageType, long sessionId) {
        if (this.sessionParser != null) {
            DebugLogger.log(LogTag.FIX_MESSAGE, "Gateway Received %s %n", buffer, offset, length);
            this.sessionParser.onMessage(buffer, offset, length, messageType, sessionId);
        }
    }

    void onLogon(String username, String password, int heartbeatIntervalInS) {
        this.username = username;
        this.password = password;
        this.heartbeatIntervalInS = heartbeatIntervalInS;
        if (this.session != null) {
            this.session.setupSession(this.sessionId, this.sessionKey);
            this.sessionParser.sequenceIndex(this.context.sequenceIndex());
            DebugLogger.log(LogTag.GATEWAY_MESSAGE, "Setup Session As: %s%n", this.sessionKey.localCompId());
        }
        this.senderEndPoint.sessionId(this.sessionId);
    }

    public void onLogon(long sessionId, SessionContext context, CompositeKey sessionKey, String username, String password, int heartbeatIntervalInS) {
        this.sessionId = sessionId;
        this.context = context;
        this.sessionKey = sessionKey;
        this.onLogon(username, password, heartbeatIntervalInS);
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    int heartbeatIntervalInS() {
        return this.heartbeatIntervalInS;
    }

    void acceptorSequenceNumbers(int retrievedSentSequenceNumber, int retrievedReceivedSequenceNumber) {
        if (this.session != null) {
            this.session.lastSentMsgSeqNum(GatewaySession.adjustLastSequenceNumber(retrievedSentSequenceNumber));
            this.session.initialLastReceivedMsgSeqNum(GatewaySession.adjustLastSequenceNumber(retrievedReceivedSequenceNumber));
        }
    }

    static int adjustLastSequenceNumber(int lastSequenceNumber) {
        return lastSequenceNumber == -1 ? 0 : lastSequenceNumber;
    }

    public String toString() {
        return "GatewaySession{sessionId=" + this.sessionId + ", sessionKey=" + this.sessionKey + '}';
    }

    void disconnectAt(long disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
    }

    @Override
    public long bytesInBuffer() {
        return this.senderEndPoint.bytesInBuffer();
    }

    void close() {
        this.session.close();
    }

    int sequenceIndex() {
        return this.context.sequenceIndex();
    }

    SlowStatus slowStatus() {
        return this.bytesInBuffer() > 0L ? SlowStatus.SLOW : SlowStatus.NOT_SLOW;
    }

    public boolean closedResendInterval() {
        return this.closedResendInterval;
    }

    public int resendRequestChunkSize() {
        return this.resendRequestChunkSize;
    }

    public boolean sendRedundantResendRequests() {
        return this.sendRedundantResendRequests;
    }

    public boolean enableLastMsgSeqNumProcessed() {
        return this.enableLastMsgSeqNumProcessed;
    }

    public SessionContext context() {
        return this.context;
    }

    boolean hasDisconnected() {
        return this.receiverEndPoint.hasDisconnected();
    }

    void initialResetSeqNum(boolean resetSeqNum) {
        this.initialResetSeqNum = resetSeqNum;
    }

    boolean initialResetSeqNum() {
        return this.initialResetSeqNum;
    }
}

