/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.List;
import uk.co.real_logic.artio.engine.framer.Continuation;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.LiveLibraryInfo;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoints;
import uk.co.real_logic.artio.engine.framer.StartCloseCommand;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.InternalSession;

class CloseOperation
implements Continuation {
    private final GatewayPublication inboundPublication;
    private final List<LiveLibraryInfo> libraries;
    private final List<GatewaySession> gatewaySessions;
    private final ReceiverEndPoints receiverEndPoints;
    private final StartCloseCommand command;
    private Step step = Step.CLOSING_NOT_LOGGED_ON_RECEIVER_END_POINTS;
    private int libraryIndex = 0;
    private int gatewaySessionIndex = 0;

    CloseOperation(GatewayPublication inboundPublication, List<LiveLibraryInfo> libraries, List<GatewaySession> gatewaySessions, ReceiverEndPoints receiverEndPoints, StartCloseCommand command) {
        this.inboundPublication = inboundPublication;
        this.libraries = libraries;
        this.gatewaySessions = gatewaySessions;
        this.receiverEndPoints = receiverEndPoints;
        this.command = command;
    }

    @Override
    public long attempt() {
        switch (this.step) {
            case CLOSING_NOT_LOGGED_ON_RECEIVER_END_POINTS: {
                this.receiverEndPoints.closeRequiredPollingEndPoints();
                this.step = Step.LOGGING_OUT_LIBRARIES;
                return -2L;
            }
            case LOGGING_OUT_LIBRARIES: {
                return this.logOutLibraries();
            }
            case LOGGING_OUT_GATEWAY_SESSIONS: {
                return this.logOutGatewaySessions();
            }
            case AWAITING_DISCONNECTS: {
                return this.awaitDisconnects();
            }
        }
        return 1L;
    }

    private long logOutLibraries() {
        GatewayPublication inboundPublication = this.inboundPublication;
        List<LiveLibraryInfo> libraries = this.libraries;
        int libraryCount = libraries.size();
        while (this.libraryIndex < libraryCount) {
            LiveLibraryInfo library = libraries.get(this.libraryIndex);
            long position = inboundPublication.saveEndOfDay(library.libraryId());
            if (position < 0L) {
                return position;
            }
            ++this.libraryIndex;
        }
        this.step = Step.LOGGING_OUT_GATEWAY_SESSIONS;
        return -2L;
    }

    private long logOutGatewaySessions() {
        List<GatewaySession> gatewaySessions = this.gatewaySessions;
        int gatewaySessionCount = gatewaySessions.size();
        while (this.gatewaySessionIndex < gatewaySessionCount) {
            long position;
            GatewaySession gatewaySession = gatewaySessions.get(this.gatewaySessionIndex);
            InternalSession session = gatewaySession.session();
            if (session != null && (position = session.logoutAndDisconnect()) < 0L) {
                return position;
            }
            ++this.gatewaySessionIndex;
        }
        this.step = Step.AWAITING_DISCONNECTS;
        return -2L;
    }

    private long awaitDisconnects() {
        if (this.receiverEndPoints.size() > 0) {
            return -2L;
        }
        this.command.success();
        return 1L;
    }

    private static enum Step {
        CLOSING_NOT_LOGGED_ON_RECEIVER_END_POINTS,
        LOGGING_OUT_LIBRARIES,
        LOGGING_OUT_GATEWAY_SESSIONS,
        AWAITING_DISCONNECTS;

    }
}

