/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import java.util.function.Consumer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import uk.co.real_logic.artio.engine.SenderSequenceNumber;

public class SenderSequenceNumbers {
    public static final int UNKNOWN_SESSION = -1;
    private static final int CAPACITY = 10;
    private final IdleStrategy framerIdleStrategy;
    private final OneToOneConcurrentArrayQueue<SenderSequenceNumber> queue = new OneToOneConcurrentArrayQueue(10);
    private final Long2ObjectHashMap<SenderSequenceNumber> connectionIdToSequencePosition = new Long2ObjectHashMap();
    private final Consumer<SenderSequenceNumber> onSenderSequenceNumberFunc = this::onSenderSequenceNumber;

    public SenderSequenceNumbers(IdleStrategy framerIdleStrategy) {
        this.framerIdleStrategy = framerIdleStrategy;
    }

    public SenderSequenceNumber onNewSender(long connectionId) {
        SenderSequenceNumber position = new SenderSequenceNumber(connectionId, this);
        this.enqueue(position);
        return position;
    }

    void onSenderClosed(SenderSequenceNumber senderSequenceNumber) {
        this.enqueue(senderSequenceNumber);
    }

    private void enqueue(SenderSequenceNumber senderSequenceNumber) {
        while (!this.queue.offer((Object)senderSequenceNumber)) {
            this.framerIdleStrategy.idle();
        }
        this.framerIdleStrategy.reset();
    }

    public int poll() {
        return this.queue.drain(this.onSenderSequenceNumberFunc, 10);
    }

    public int lastSentSequenceNumber(long connectionId) {
        SenderSequenceNumber senderSequenceNumber = (SenderSequenceNumber)this.connectionIdToSequencePosition.get(connectionId);
        if (senderSequenceNumber == null) {
            return -1;
        }
        return senderSequenceNumber.lastSentSequenceNumber();
    }

    private void onSenderSequenceNumber(SenderSequenceNumber senderSequenceNumber) {
        long connectionId = senderSequenceNumber.connectionId();
        if (this.connectionIdToSequencePosition.remove(connectionId) == null) {
            this.connectionIdToSequencePosition.put(connectionId, (Object)senderSequenceNumber);
        }
    }
}

