/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import io.aeron.Aeron;
import io.aeron.Counter;
import java.util.ArrayList;
import java.util.List;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;

public class FixCounters
implements AutoCloseable {
    private static final int MINIMUM_ARTIO_TYPE_ID = 10000;
    private static final int FAILED_INBOUND_TYPE_ID = 10000;
    private static final int FAILED_OUTBOUND_TYPE_ID = 10001;
    private static final int FAILED_REPLAY_TYPE_ID = 10002;
    private static final int MESSAGES_READ_TYPE_ID = 10003;
    private static final int BYTES_IN_BUFFER_TYPE_ID = 10004;
    private static final int INVALID_LIBRARY_ATTEMPTS_TYPE_ID = 10005;
    private static final int SENT_MSG_SEQ_NO_TYPE_ID = 10006;
    private static final int RECV_MSG_SEQ_NO_TYPE_ID = 10007;
    private final List<Counter> counters = new ArrayList<Counter>();
    private final AtomicCounter failedInboundPublications;
    private final AtomicCounter failedOutboundPublications;
    private final AtomicCounter failedReplayPublications;
    private final Aeron aeron;

    FixCounters(Aeron aeron) {
        this.aeron = aeron;
        this.failedInboundPublications = this.newCounter(10000, "Failed offer to inbound publication");
        this.failedOutboundPublications = this.newCounter(10001, "Failed offer to outbound publication");
        this.failedReplayPublications = this.newCounter(10002, "Failed offer to replay publication");
    }

    public AtomicCounter failedInboundPublications() {
        return this.failedInboundPublications;
    }

    public AtomicCounter failedOutboundPublications() {
        return this.failedOutboundPublications;
    }

    public AtomicCounter failedReplayPublications() {
        return this.failedReplayPublications;
    }

    public AtomicCounter messagesRead(long connectionId, String address) {
        return this.newCounter(10003, "Messages Read from " + address + " id = " + connectionId);
    }

    public AtomicCounter bytesInBuffer(long connectionId, String address) {
        return this.newCounter(10004, "Quarantined bytes for " + address + " id = " + connectionId);
    }

    public AtomicCounter invalidLibraryAttempts(long connectionId, String address) {
        return this.newCounter(10005, "Invalid Library Attempts for " + address + " id = " + connectionId);
    }

    public AtomicCounter sentMsgSeqNo(long connectionId) {
        return this.newCounter(10006, "Last Sent MsgSeqNo for " + connectionId);
    }

    public AtomicCounter receivedMsgSeqNo(long connectionId) {
        return this.newCounter(10007, "Last Received MsgSeqNo for " + connectionId);
    }

    private AtomicCounter newCounter(int typeId, String label) {
        Counter counter = this.aeron.addCounter(typeId, label);
        this.counters.add(counter);
        return counter;
    }

    @Override
    public void close() {
        Exceptions.closeAll(this.counters);
    }
}

