/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.storage.messages.SenderTargetAndSubCompositeKeyDecoder;
import uk.co.real_logic.artio.storage.messages.SenderTargetAndSubCompositeKeyEncoder;

class SenderTargetAndSubSessionIdStrategy
implements SessionIdStrategy {
    private static final int BLOCK_AND_LENGTH_FIELDS_LENGTH = 6;
    private final SenderTargetAndSubCompositeKeyEncoder keyEncoder = new SenderTargetAndSubCompositeKeyEncoder();
    private final SenderTargetAndSubCompositeKeyDecoder keyDecoder = new SenderTargetAndSubCompositeKeyDecoder();
    private final int actingBlockLength = this.keyDecoder.sbeBlockLength();
    private final int actingVersion = this.keyDecoder.sbeSchemaVersion();

    SenderTargetAndSubSessionIdStrategy() {
    }

    @Override
    public CompositeKey onAcceptLogon(HeaderDecoder header) {
        return new CompositeKeyImpl(header.targetCompID(), header.targetCompIDLength(), header.senderSubID(), header.senderSubIDLength(), header.senderCompID(), header.senderCompIDLength());
    }

    @Override
    public CompositeKey onInitiateLogon(String localCompId, String localSubId, String localLocationId, String remoteCompId, String remoteSubId, String remoteLocationId) {
        char[] senderCompIdChars = localCompId.toCharArray();
        char[] senderSubIdChars = localSubId.toCharArray();
        char[] targetCompIdChars = remoteCompId.toCharArray();
        return new CompositeKeyImpl(senderCompIdChars, senderCompIdChars.length, senderSubIdChars, senderSubIdChars.length, targetCompIdChars, targetCompIdChars.length);
    }

    @Override
    public void setupSession(CompositeKey compositeKey, SessionHeaderEncoder headerEncoder) {
        CompositeKeyImpl composite = (CompositeKeyImpl)compositeKey;
        headerEncoder.senderCompID(composite.localCompId);
        headerEncoder.senderSubID(composite.localSubID);
        headerEncoder.targetCompID(composite.remoteCompID);
    }

    @Override
    public int save(CompositeKey compositeKey, MutableDirectBuffer buffer, int offset) {
        CompositeKeyImpl key = (CompositeKeyImpl)compositeKey;
        byte[] localCompID = key.localCompId;
        byte[] localSubID = key.localSubID;
        byte[] remoteCompID = key.remoteCompID;
        int length = localCompID.length + localSubID.length + remoteCompID.length + 6;
        if (buffer.capacity() < offset + length) {
            return -1;
        }
        this.keyEncoder.wrap(buffer, offset);
        this.keyEncoder.putLocalCompId(localCompID, 0, localCompID.length);
        this.keyEncoder.putLocalSubId(localSubID, 0, localSubID.length);
        this.keyEncoder.putRemoteCompId(remoteCompID, 0, remoteCompID.length);
        return length;
    }

    @Override
    public CompositeKey load(DirectBuffer buffer, int offset, int length) {
        this.keyDecoder.wrap(buffer, offset, this.actingBlockLength, this.actingVersion);
        int localCompIdLength = this.keyDecoder.localCompIdLength();
        byte[] localCompId = new byte[localCompIdLength];
        this.keyDecoder.getLocalCompId(localCompId, 0, localCompIdLength);
        int localSubIdLength = this.keyDecoder.localSubIdLength();
        byte[] localSubId = new byte[localSubIdLength];
        this.keyDecoder.getLocalSubId(localSubId, 0, localSubIdLength);
        int remoteCompIdLength = this.keyDecoder.remoteCompIdLength();
        byte[] remoteCompId = new byte[remoteCompIdLength];
        this.keyDecoder.getRemoteCompId(remoteCompId, 0, remoteCompIdLength);
        return new CompositeKeyImpl(localCompId, localSubId, remoteCompId);
    }

    private static final class CompositeKeyImpl
    implements CompositeKey {
        private final byte[] localCompId;
        private final byte[] localSubID;
        private final byte[] remoteCompID;
        private final int hashCode;

        private CompositeKeyImpl(char[] localCompId, int localCompIDLength, char[] localSubID, int localSubIDLength, char[] remoteCompID, int remoteCompIDLength) {
            this(CodecUtil.toBytes((char[])localCompId, (int)localCompIDLength), CodecUtil.toBytes((char[])localSubID, (int)localSubIDLength), CodecUtil.toBytes((char[])remoteCompID, (int)remoteCompIDLength));
        }

        private CompositeKeyImpl(byte[] localCompId, byte[] localSubID, byte[] remoteCompID) {
            this.localCompId = localCompId;
            this.localSubID = localSubID;
            this.remoteCompID = remoteCompID;
            this.hashCode = this.hash(this.localCompId, this.localSubID, this.remoteCompID);
        }

        private int hash(byte[] localCompID, byte[] localSubID, byte[] remoteCompID) {
            int result = Arrays.hashCode(localCompID);
            result = 31 * result + Arrays.hashCode(localSubID);
            result = 31 * result + Arrays.hashCode(remoteCompID);
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompositeKeyImpl) {
                CompositeKeyImpl compositeKey = (CompositeKeyImpl)obj;
                return Arrays.equals(compositeKey.localCompId, this.localCompId) && Arrays.equals(compositeKey.localSubID, this.localSubID) && Arrays.equals(compositeKey.remoteCompID, this.remoteCompID);
            }
            return false;
        }

        public String toString() {
            return "CompositeKey{localCompId=" + this.localCompId() + "localSubId=" + this.localSubId() + ", remoteCompId=" + this.remoteCompId() + '}';
        }

        @Override
        public String localCompId() {
            return new String(this.localCompId, StandardCharsets.US_ASCII);
        }

        @Override
        public String localSubId() {
            return new String(this.localSubID, StandardCharsets.US_ASCII);
        }

        @Override
        public String localLocationId() {
            return "";
        }

        @Override
        public String remoteCompId() {
            return new String(this.remoteCompID, StandardCharsets.US_ASCII);
        }

        @Override
        public String remoteSubId() {
            return "";
        }

        @Override
        public String remoteLocationId() {
            return "";
        }
    }
}

