/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.Aeron;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import java.io.File;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.SystemEpochClock;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.GatewayProcess;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryPoller;
import uk.co.real_logic.artio.library.LibraryScheduler;
import uk.co.real_logic.artio.library.LibraryTransport;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.messages.SessionReplyStatus;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionWriter;
import uk.co.real_logic.artio.timing.LibraryTimers;

public class FixLibrary
extends GatewayProcess {
    public static final int NO_MESSAGE_REPLAY = -1;
    public static final int CURRENT_SEQUENCE = -2;
    private final LibraryConfiguration configuration;
    private final LibraryScheduler scheduler;
    private final LibraryPoller poller;
    private boolean isPolling = false;

    FixLibrary(LibraryConfiguration configuration) {
        this.configuration = configuration;
        this.scheduler = configuration.scheduler();
        configuration.conclude();
        try {
            this.scheduler.configure(configuration.aeronContext());
            this.init(configuration);
            LibraryTimers timers = new LibraryTimers(configuration.clock());
            this.initMonitoringAgent(timers.all(), configuration);
            LibraryTransport transport = new LibraryTransport(configuration, this.fixCounters, this.aeron);
            this.poller = new LibraryPoller(configuration, timers, this.fixCounters, transport, this, (EpochClock)new SystemEpochClock());
        }
        catch (Exception e) {
            try {
                this.closeAnythingHoldingFileHandles();
                this.deleteFiles();
            }
            catch (Exception innerException) {
                innerException.addSuppressed(e);
                throw innerException;
            }
            throw e;
        }
    }

    private void closeAnythingHoldingFileHandles() {
        if (this.monitoringAgent == null) {
            this.monitoringFile.close();
        } else {
            this.monitoringAgent.onClose();
        }
    }

    private FixLibrary connect() {
        this.poller.startConnecting();
        ErrorHandler remoteThreadErrorHandler = this.createRemoteThreadErrorHandler(this.errorHandler);
        this.scheduler.launch(this.configuration, remoteThreadErrorHandler, this.monitoringAgent, this.conductorAgent());
        return this;
    }

    @Override
    protected Aeron.Context configureAeronContext(CommonConfiguration configuration) {
        Aeron.Context context = super.configureAeronContext(configuration);
        ErrorHandler errorHandler = context.errorHandler();
        context.errorHandler(this.createRemoteThreadErrorHandler(errorHandler));
        return context;
    }

    private ErrorHandler createRemoteThreadErrorHandler(ErrorHandler innerHandler) {
        return e -> {
            if (e instanceof ConductorServiceTimeoutException) {
                this.postExceptionToLibraryThread(e);
            } else {
                innerHandler.onError(e);
            }
        };
    }

    private void postExceptionToLibraryThread(Throwable e) {
        this.poller.postExceptionToLibraryThread(e);
    }

    public static FixLibrary connect(LibraryConfiguration configuration) {
        return new FixLibrary(configuration).connect();
    }

    public int poll(int fragmentLimit) {
        this.isPolling = true;
        try {
            int n = this.poller.poll(fragmentLimit);
            return n;
        }
        finally {
            this.isPolling = false;
        }
    }

    public boolean isConnected() {
        return this.poller.isConnected();
    }

    public boolean isClosed() {
        return this.poller.isClosed();
    }

    public int libraryId() {
        return this.poller.libraryId();
    }

    public List<Session> sessions() {
        return this.poller.sessions();
    }

    @Override
    public void close() {
        if (this.isPolling) {
            throw new IllegalArgumentException("You cannot close the library in the middle of a poll");
        }
        this.internalClose();
    }

    void internalClose() {
        Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.poller, () -> this.scheduler.close(this.libraryId()), () -> super.close(), this::deleteFiles});
    }

    private void deleteFiles() {
        if (this.configuration.gracefulShutdown()) {
            this.removeParentDirectory(this.configuration.histogramLoggingFile());
            this.removeParentDirectory(this.configuration.monitoringFile());
        }
    }

    private void removeParentDirectory(String path) {
        File parentFile;
        File file = new File(path);
        if (file.exists() && !file.delete()) {
            this.errorHandler.onError((Throwable)new RuntimeException("Unable to delete: " + path));
        }
        if ((parentFile = file.getParentFile()) != null & parentFile.exists() && parentFile.listFiles().length == 0) {
            IoUtil.delete((File)parentFile, (boolean)true);
        }
    }

    public Reply<Session> initiate(SessionConfiguration configuration) {
        return this.poller.initiate(configuration);
    }

    public Reply<SessionReplyStatus> releaseToGateway(Session session, long timeoutInMs) {
        CommonConfiguration.validateTimeout(timeoutInMs);
        return this.poller.releaseToGateway(session, timeoutInMs);
    }

    public Reply<SessionReplyStatus> requestSession(long sessionId, int resendFromSequenceNumber, int resendFromSequenceIndex, long timeoutInMs) {
        CommonConfiguration.validateTimeout(timeoutInMs);
        return this.poller.requestSession(sessionId, resendFromSequenceNumber, resendFromSequenceIndex, timeoutInMs);
    }

    public SessionWriter sessionWriter(long sessionId, long connectionId, int sequenceIndex) {
        return this.poller.followerSession(sessionId, connectionId, sequenceIndex);
    }

    public Reply<SessionWriter> followerSession(HeaderEncoder headerEncoder, long timeoutInMs) {
        return this.poller.followerSession(headerEncoder, timeoutInMs);
    }

    public String currentAeronChannel() {
        return this.poller.currentAeronChannel();
    }
}

