/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.artio.engine.SectorFramer;
import uk.co.real_logic.artio.engine.logger.IndexedPositionReader;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexDescriptor;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.LastKnownSequenceNumberDecoder;

public class SequenceNumberIndexReader {
    private final MessageHeaderDecoder fileHeaderDecoder = new MessageHeaderDecoder();
    private final LastKnownSequenceNumberDecoder lastKnownDecoder = new LastKnownSequenceNumberDecoder();
    private final AtomicBuffer inMemoryBuffer;
    private final SectorFramer sectorFramer;
    private final IndexedPositionReader positions;
    private final ErrorHandler errorHandler;

    public SequenceNumberIndexReader(AtomicBuffer inMemoryBuffer, ErrorHandler errorHandler) {
        this.inMemoryBuffer = inMemoryBuffer;
        this.errorHandler = errorHandler;
        int positionTableOffset = SequenceNumberIndexDescriptor.positionTableOffset(inMemoryBuffer.capacity());
        this.sectorFramer = new SectorFramer(positionTableOffset);
        this.validateBuffer();
        this.positions = new IndexedPositionReader(SequenceNumberIndexDescriptor.positionsBuffer(inMemoryBuffer, positionTableOffset));
    }

    public int lastKnownSequenceNumber(long sessionId) {
        int position = 8;
        while ((position = this.sectorFramer.claim(position, 16)) != -1) {
            this.lastKnownDecoder.wrap((DirectBuffer)this.inMemoryBuffer, position, 16, 0);
            if (this.lastKnownDecoder.sessionId() == sessionId) {
                return this.lastKnownDecoder.sequenceNumber();
            }
            position += 16;
        }
        return -1;
    }

    public long indexedPosition(int aeronSessionId) {
        return this.positions.indexedPosition(aeronSessionId);
    }

    private void validateBuffer() {
        LoggerUtil.validateBuffer(this.inMemoryBuffer, this.fileHeaderDecoder, 666, this.errorHandler);
    }
}

