/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.Arrays;
import java.util.List;
import uk.co.real_logic.artio.engine.framer.Continuation;

class UnitOfWork
implements Continuation {
    private List<Continuation> workList;
    private int index = 0;

    UnitOfWork(Continuation ... work) {
        this.work(work);
    }

    void work(Continuation ... work) {
        this.workList = Arrays.asList(work);
    }

    UnitOfWork(List<Continuation> workList) {
        this.workList = workList;
    }

    @Override
    public ControlledFragmentHandler.Action attemptToAction() {
        int size = this.workList.size();
        while (this.index < size) {
            Continuation continuation = this.workList.get(this.index);
            ControlledFragmentHandler.Action action = continuation.attemptToAction();
            if (action == ControlledFragmentHandler.Action.ABORT) {
                return ControlledFragmentHandler.Action.ABORT;
            }
            ++this.index;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public long attempt() {
        return 0L;
    }
}

