/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.session.Session;

class SessionContext {
    static final int UNKNOWN_SEQUENCE_INDEX = -1;
    private final long sessionId;
    private final SessionContexts sessionContexts;
    private final int filePosition;
    private int sequenceIndex;
    private long logonTime;

    SessionContext(long sessionId, int sequenceIndex, long logonTime, SessionContexts sessionContexts, int filePosition) {
        this.sessionId = sessionId;
        this.sequenceIndex = sequenceIndex;
        this.logonTime = logonTime;
        this.sessionContexts = sessionContexts;
        this.filePosition = filePosition;
    }

    void onSequenceReset() {
        ++this.sequenceIndex;
        this.sessionContexts.updateSavedData(this.filePosition, this.sequenceIndex, this.logonTime);
    }

    void updateAndSaveFrom(Session session) {
        this.updateFrom(session);
        this.sessionContexts.updateSavedData(this.filePosition, this.sequenceIndex, this.logonTime);
    }

    void updateFrom(Session session) {
        this.sequenceIndex = session.sequenceIndex();
        this.logonTime = session.logonTime();
    }

    void onLogon(boolean resetSeqNum) {
        if (resetSeqNum || this.sequenceIndex == -1) {
            this.onSequenceReset();
        }
    }

    int sequenceIndex() {
        return this.sequenceIndex;
    }

    long sessionId() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionContext that = (SessionContext)o;
        return this.sessionId == that.sessionId;
    }

    public int hashCode() {
        return (int)(this.sessionId ^ this.sessionId >>> 32);
    }

    public String toString() {
        return "SessionContext{sessionId=" + this.sessionId + ", sequenceIndex=" + this.sequenceIndex + '}';
    }
}

