/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.ArrayList;
import java.util.List;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.engine.framer.Continuation;
import uk.co.real_logic.artio.engine.framer.UnitOfWork;

class RetryManager {
    private final Long2ObjectHashMap<UnitOfWork> correlationIdToTransactions = new Long2ObjectHashMap();
    private final List<Continuation> polledUnitOfWorks = new ArrayList<Continuation>();

    RetryManager() {
    }

    ControlledFragmentHandler.Action retry(long correlationId) {
        UnitOfWork unitOfWork = (UnitOfWork)this.correlationIdToTransactions.get(correlationId);
        if (unitOfWork == null) {
            return null;
        }
        return this.attempt(correlationId, unitOfWork);
    }

    ControlledFragmentHandler.Action firstAttempt(long correlationId, UnitOfWork unitOfWork) {
        this.correlationIdToTransactions.put(correlationId, (Object)unitOfWork);
        return this.attempt(correlationId, unitOfWork);
    }

    private ControlledFragmentHandler.Action attempt(long correlationId, UnitOfWork unitOfWork) {
        ControlledFragmentHandler.Action action = unitOfWork.attemptToAction();
        if (action != ControlledFragmentHandler.Action.ABORT) {
            this.correlationIdToTransactions.remove(correlationId);
        }
        return action;
    }

    void schedule(Continuation unitOfWork) {
        this.polledUnitOfWorks.add(unitOfWork);
    }

    int attemptSteps() {
        return CollectionUtil.removeIf(this.polledUnitOfWorks, step -> step.attemptToAction() == ControlledFragmentHandler.Action.CONTINUE);
    }
}

