/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.nio.TransportPoller;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.messages.DisconnectReason;

class ReceiverEndPoints
extends TransportPoller {
    private ReceiverEndPoint[] requiredPollingEndPoints = new ReceiverEndPoint[0];
    private ReceiverEndPoint[] endPoints = new ReceiverEndPoint[0];

    ReceiverEndPoints() {
    }

    void add(ReceiverEndPoint endPoint) {
        if (endPoint.requiresAuthentication()) {
            this.requiredPollingEndPoints = (ReceiverEndPoint[])ArrayUtil.add((Object[])this.requiredPollingEndPoints, (Object)endPoint);
        } else {
            this.addToNormalEndpoints(endPoint);
        }
    }

    private void addToNormalEndpoints(ReceiverEndPoint endPoint) {
        try {
            this.endPoints = (ReceiverEndPoint[])ArrayUtil.add((Object[])this.endPoints, (Object)endPoint);
            endPoint.register(this.selector);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    void removeConnection(long connectionId, DisconnectReason reason) {
        Object[] endPoints = this.endPoints;
        int index = this.findAndCloseEndPoint(connectionId, reason, (ReceiverEndPoint[])endPoints);
        if (index != -1) {
            this.endPoints = (ReceiverEndPoint[])ArrayUtil.remove((Object[])endPoints, (int)index);
        } else {
            index = this.findAndCloseEndPoint(connectionId, reason, this.requiredPollingEndPoints);
            this.requiredPollingEndPoints = (ReceiverEndPoint[])ArrayUtil.remove((Object[])this.requiredPollingEndPoints, (int)index);
        }
        this.selectNowToForceProcessing();
    }

    private int findAndCloseEndPoint(long connectionId, DisconnectReason reason, ReceiverEndPoint[] endPoints) {
        int index = -1;
        int length = endPoints.length;
        for (int i = 0; i < length; ++i) {
            ReceiverEndPoint endPoint = endPoints[i];
            if (endPoint.connectionId() != connectionId) continue;
            index = i;
            endPoint.close(reason);
        }
        return index;
    }

    private void selectNowToForceProcessing() {
        try {
            this.selector.selectNow();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    int pollEndPoints() {
        int bytesReceived = 0;
        try {
            int i;
            Object[] requiredPollingEndPoints = this.requiredPollingEndPoints;
            ReceiverEndPoint[] endPoints = this.endPoints;
            int numRequiredPollingEndPoints = requiredPollingEndPoints.length;
            int numEndPoints = endPoints.length;
            int threshold = 5 - numRequiredPollingEndPoints;
            if (numEndPoints <= threshold) {
                for (i = numEndPoints - 1; i >= 0; --i) {
                    bytesReceived += endPoints[i].poll();
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] keys = this.selectedKeySet.keys();
                for (int i2 = this.selectedKeySet.size() - 1; i2 >= 0; --i2) {
                    bytesReceived += ((ReceiverEndPoint)keys[i2].attachment()).poll();
                }
                this.selectedKeySet.reset();
            }
            for (i = numRequiredPollingEndPoints - 1; i >= 0; --i) {
                ReceiverEndPoint requiredPollingEndPoint = requiredPollingEndPoints[i];
                bytesReceived += requiredPollingEndPoint.poll();
                if (requiredPollingEndPoint.requiresAuthentication()) continue;
                requiredPollingEndPoints = (ReceiverEndPoint[])ArrayUtil.remove((Object[])requiredPollingEndPoints, (int)i);
                this.addToNormalEndpoints(requiredPollingEndPoint);
            }
            this.requiredPollingEndPoints = requiredPollingEndPoints;
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesReceived;
    }

    public void close() {
        Stream.of(this.endPoints).forEach(receiverEndPoint -> receiverEndPoint.close(DisconnectReason.ENGINE_SHUTDOWN));
        super.close();
    }
}

