/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;

public final class DebugLogger {
    private static final PrintStream OUTPUT;

    public static void log(LogTag tag, String formatString, int value, DirectBuffer buffer, int offset, int length) {
        if (DebugLogger.isEnabled(tag)) {
            byte[] data = new byte[length];
            buffer.getBytes(offset, data);
            DebugLogger.substituteSeparator(data);
            DebugLogger.printf(tag, formatString, value, new String(data, StandardCharsets.US_ASCII));
        }
    }

    public static void logSbeMessage(LogTag tag, Object sbeObject) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.println(sbeObject.toString());
        }
    }

    public static void log(LogTag tag, String formatString, DirectBuffer buffer, int offset, int length) {
        if (DebugLogger.isEnabled(tag)) {
            byte[] data = new byte[length];
            buffer.getBytes(offset, data);
            DebugLogger.substituteSeparator(data);
            DebugLogger.printf(tag, formatString, new String(data, StandardCharsets.US_ASCII));
        }
    }

    public static void log(LogTag tag, String formatString, ByteBuffer byteBuffer, int length) {
        if (DebugLogger.isEnabled(tag)) {
            byte[] data = new byte[length];
            int originalPosition = byteBuffer.position();
            ByteBufferUtil.position(byteBuffer, originalPosition - length);
            byteBuffer.get(data);
            ByteBufferUtil.position(byteBuffer, originalPosition);
            DebugLogger.substituteSeparator(data);
            DebugLogger.printf(tag, formatString, new String(data, StandardCharsets.US_ASCII));
        }
    }

    public static void log(LogTag tag, String message) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.println(message);
        }
    }

    public static void log(LogTag tag, String formatString, Object value) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.printf(tag, formatString, value);
        }
    }

    public static void log(LogTag tag, String formatString, long first) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.printf(tag, formatString, first);
        }
    }

    public static void log(LogTag tag, String formatString, long first, Object second) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.printf(tag, formatString, first, second);
        }
    }

    public static void log(LogTag tag, String formatString, long first, long second) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.printf(tag, formatString, first, second);
        }
    }

    public static void log(LogTag tag, String formatString, long first, long second, long third) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.printf(tag, formatString, first, second, third);
        }
    }

    public static void log(LogTag tag, String formatString, Object first, long second, long third) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.printf(tag, formatString, first, second, third);
        }
    }

    public static void log(LogTag tag, String formatString, long first, long second, long third, long fourth) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.printf(tag, formatString, first, second, third, fourth);
        }
    }

    public static void log(LogTag tag, String formatString, Object first, long second, long third, long fourth) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.printf(tag, formatString, first, second, third, fourth);
        }
    }

    public static void log(LogTag tag, String formatString, Object first, Object second) {
        if (DebugLogger.isEnabled(tag)) {
            DebugLogger.printf(tag, formatString, first, second);
        }
    }

    private static void printf(LogTag tag, String formatString, Object ... args) {
        String threadName = DebugLogger.threadName();
        if (DebugLogger.isThreadEnabled(threadName)) {
            OUTPUT.printf(System.currentTimeMillis() + ":" + threadName + "[" + tag.name() + "] : " + formatString, args);
        }
    }

    private static void println(String message) {
        String threadName = DebugLogger.threadName();
        if (DebugLogger.isThreadEnabled(threadName)) {
            OUTPUT.println(threadName + message);
        }
    }

    private static String threadName() {
        return Thread.currentThread().getName();
    }

    private static void substituteSeparator(byte[] data) {
        if (CommonConfiguration.DEBUG_LOGGING_SEPARATOR != 1) {
            int size = data.length;
            for (int i = 0; i < size; ++i) {
                if (data[i] != 1) continue;
                data[i] = CommonConfiguration.DEBUG_LOGGING_SEPARATOR;
            }
        }
    }

    private static boolean isEnabled(LogTag tag) {
        return EngineConfiguration.DEBUG_PRINT_MESSAGES && CommonConfiguration.DEBUG_TAGS.contains((Object)tag);
    }

    private static boolean isThreadEnabled(String threadName) {
        return CommonConfiguration.DEBUG_PRINT_THREAD == null || CommonConfiguration.DEBUG_PRINT_THREAD.equals(threadName);
    }

    static {
        if (EngineConfiguration.DEBUG_FILE == null) {
            OUTPUT = System.out;
        } else {
            PrintStream output = null;
            try {
                output = new PrintStream(new FileOutputStream(EngineConfiguration.DEBUG_FILE));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                OUTPUT = output;
            }
        }
    }
}

