/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import io.aeron.Aeron;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.IoUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.Clock;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.timing.HistogramHandler;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

public class CommonConfiguration {
    public static final String MONITORING_BUFFERS_LENGTH_PROPERTY = "fix.monitoring.length";
    public static final String MONITORING_FILE_PROPERTY = "fix.monitoring.file";
    public static final String DEBUG_PRINT_MESSAGES_PROPERTY = "fix.core.debug";
    public static final String DEBUG_PRINT_THREAD_PROPERTY = "fix.core.debug.thread";
    public static final String FORCE_WRITES_MESSAGES_PROPERTY = "fix.core.flush";
    public static final String INBOUND_MAX_CLAIM_ATTEMPTS_PROPERTY = "fix.core.inbound_max_claims";
    public static final String OUTBOUND_MAX_CLAIM_ATTEMPTS_PROPERTY = "fix.core.outbound_max_claims";
    public static final String TIME_MESSAGES_PROPERTY = "fix.core.timing";
    public static final String DEBUG_FILE_PROPERTY = "fix.core.debug.file";
    public static final String HISTOGRAM_POLL_PERIOD_IN_MS_PROPERTY = "fix.benchmark.histogram_poll_period";
    public static final String HISTOGRAM_LOGGING_FILE_PROPERTY = "fix.benchmark.histogram_file";
    public static final String LOGGING_SEPARATOR_PROPERTY = "fix.core.debug.separator";
    protected ThreadFactory threadFactory;
    public static final boolean DEBUG_PRINT_MESSAGES;
    public static final Set<LogTag> DEBUG_TAGS;
    public static final String DEBUG_PRINT_THREAD;
    public static final byte DEFAULT_DEBUG_LOGGING_SEPARATOR = 1;
    public static final byte DEBUG_LOGGING_SEPARATOR;
    public static final String DEBUG_FILE;
    public static final boolean TIME_MESSAGES;
    public static final boolean FORCE_WRITES;
    public static final int BACKOFF_SPINS;
    public static final int BACKOFF_YIELDS;
    public static final int DEFAULT_MONITORING_BUFFER_LENGTH = 0x400000;
    public static final String DEFAULT_DIRECTORY;
    public static final String DEFAULT_MONITORING_FILE;
    public static final String DEFAULT_HISTOGRAM_LOGGING_FILE;
    public static final String DEFAULT_NAME_PREFIX = "";
    public static final int DEFAULT_REASONABLE_TRANSMISSION_TIME_IN_S = 3;
    public static final long DEFAULT_REASONABLE_TRANSMISSION_TIME_IN_MS;
    public static final boolean DEFAULT_PRINT_AERON_STREAM_IDENTIFIERS = false;
    public static final int DEFAULT_INBOUND_MAX_CLAIM_ATTEMPTS;
    public static final int DEFAULT_OUTBOUND_MAX_CLAIM_ATTEMPTS;
    public static final int DEFAULT_SESSION_BUFFER_SIZE = 16384;
    public static final long DEFAULT_SENDING_TIME_WINDOW;
    public static final int DEFAULT_HEARTBEAT_INTERVAL_IN_S = 10;
    public static final long DEFAULT_REPLY_TIMEOUT_IN_MS = 3000L;
    public static final long DEFAULT_HISTOGRAM_POLL_PERIOD_IN_MS;
    public static final int DEFAULT_INBOUND_LIBRARY_STREAM = 1;
    public static final int DEFAULT_OUTBOUND_LIBRARY_STREAM = 2;
    private long reasonableTransmissionTimeInMs = DEFAULT_REASONABLE_TRANSMISSION_TIME_IN_MS;
    private boolean printAeronStreamIdentifiers = false;
    private Clock clock = Clock.systemNanoTime();
    private boolean printErrorMessages = true;
    private IdleStrategy monitoringThreadIdleStrategy = CommonConfiguration.backoffIdleStrategy();
    private long sendingTimeWindowInMs = DEFAULT_SENDING_TIME_WINDOW;
    private SessionIdStrategy sessionIdStrategy = SessionIdStrategy.senderAndTarget();
    private MessageValidationStrategy messageValidationStrategy = MessageValidationStrategy.none();
    private SessionCustomisationStrategy sessionCustomisationStrategy = SessionCustomisationStrategy.none();
    private int monitoringBuffersLength = Integer.getInteger("fix.monitoring.length", 0x400000);
    private String monitoringFile = null;
    private long replyTimeoutInMs = 3000L;
    private final Aeron.Context aeronContext = new Aeron.Context();
    private int sessionBufferSize = 16384;
    private int inboundMaxClaimAttempts = Integer.getInteger("fix.core.inbound_max_claims", DEFAULT_INBOUND_MAX_CLAIM_ATTEMPTS);
    private int outboundMaxClaimAttempts = Integer.getInteger("fix.core.outbound_max_claims", DEFAULT_OUTBOUND_MAX_CLAIM_ATTEMPTS);
    private int defaultHeartbeatIntervalInS = 10;
    private long histogramPollPeriodInMs = Long.getLong("fix.benchmark.histogram_poll_period", DEFAULT_HISTOGRAM_POLL_PERIOD_IN_MS);
    private String histogramLoggingFile = null;
    private HistogramHandler histogramHandler;
    private String agentNamePrefix = "";
    private int inboundLibraryStream = 1;
    private int outboundLibraryStream = 2;
    private boolean gracefulShutdown = true;
    private final AtomicBoolean isConcluded = new AtomicBoolean(false);

    public static void validateTimeout(long timeoutInMs) {
        if (timeoutInMs <= 0L) {
            throw new IllegalArgumentException(String.format("Timeout must be > 0, but was configured as %d", timeoutInMs));
        }
    }

    public CommonConfiguration sendingTimeWindowInMs(long sendingTimeWindowInMs) {
        this.sendingTimeWindowInMs = sendingTimeWindowInMs;
        return this;
    }

    public long sendingTimeWindowInMs() {
        return this.sendingTimeWindowInMs;
    }

    public CommonConfiguration defaultHeartbeatIntervalInS(int value) {
        this.defaultHeartbeatIntervalInS = value;
        return this;
    }

    public int defaultHeartbeatIntervalInS() {
        return this.defaultHeartbeatIntervalInS;
    }

    public CommonConfiguration sessionIdStrategy(SessionIdStrategy sessionIdStrategy) {
        this.sessionIdStrategy = sessionIdStrategy;
        return this;
    }

    public CommonConfiguration sessionCustomisationStrategy(SessionCustomisationStrategy sessionCustomisationStrategy) {
        this.sessionCustomisationStrategy = sessionCustomisationStrategy;
        return this;
    }

    public CommonConfiguration messageValidationStrategy(MessageValidationStrategy messageValidationStrategy) {
        this.messageValidationStrategy = messageValidationStrategy;
        return this;
    }

    public CommonConfiguration reasonableTransmissionTimeInMs(long reasonableTransmissionTimeInMs) {
        this.reasonableTransmissionTimeInMs = reasonableTransmissionTimeInMs;
        return this;
    }

    public long reasonableTransmissionTimeInMs() {
        return this.reasonableTransmissionTimeInMs;
    }

    public CommonConfiguration monitoringBuffersLength(Integer monitoringBuffersLength) {
        this.monitoringBuffersLength = monitoringBuffersLength;
        return this;
    }

    public CommonConfiguration monitoringFile(String monitoringFile) {
        this.monitoringFile = monitoringFile;
        return this;
    }

    public CommonConfiguration printErrorMessages(boolean printErrorMessages) {
        this.printErrorMessages = printErrorMessages;
        return this;
    }

    public CommonConfiguration monitoringThreadIdleStrategy(IdleStrategy errorPrinterIdleStrategy) {
        this.monitoringThreadIdleStrategy = errorPrinterIdleStrategy;
        return this;
    }

    public CommonConfiguration replyTimeoutInMs(long replyTimeoutInMs) {
        this.replyTimeoutInMs = replyTimeoutInMs;
        return this;
    }

    public CommonConfiguration inboundMaxClaimAttempts(int inboundMaxClaimAttempts) {
        this.inboundMaxClaimAttempts = inboundMaxClaimAttempts;
        return this;
    }

    public CommonConfiguration outboundMaxClaimAttempts(int outboundMaxClaimAttempts) {
        this.outboundMaxClaimAttempts = outboundMaxClaimAttempts;
        return this;
    }

    public CommonConfiguration sessionBufferSize(int bufferSize) {
        this.sessionBufferSize = bufferSize;
        return this;
    }

    public CommonConfiguration histogramPollPeriodInMs(long histogramPollPeriodInMs) {
        this.histogramPollPeriodInMs = histogramPollPeriodInMs;
        return this;
    }

    public CommonConfiguration histogramLoggingFile(String histogramLoggingFile) {
        this.histogramLoggingFile = histogramLoggingFile;
        return this;
    }

    public CommonConfiguration histogramHandler(HistogramHandler histogramHandler) {
        this.histogramHandler = histogramHandler;
        return this;
    }

    public CommonConfiguration agentNamePrefix(String agentNamePrefix) {
        this.agentNamePrefix = agentNamePrefix;
        return this;
    }

    public CommonConfiguration printAeronStreamIdentifiers(boolean printAeronStreamIdentifiers) {
        this.printAeronStreamIdentifiers = printAeronStreamIdentifiers;
        return this;
    }

    public CommonConfiguration clock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public CommonConfiguration inboundLibraryStream(int inboundLibraryStream) {
        this.inboundLibraryStream = inboundLibraryStream;
        return this;
    }

    public CommonConfiguration outboundLibraryStream(int outboundLibraryStream) {
        this.outboundLibraryStream = outboundLibraryStream;
        return this;
    }

    public CommonConfiguration threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public CommonConfiguration gracefulShutdown(boolean gracefulShutdown) {
        this.gracefulShutdown = gracefulShutdown;
        return this;
    }

    public boolean gracefulShutdown() {
        return this.gracefulShutdown;
    }

    public Aeron.Context aeronContext() {
        return this.aeronContext;
    }

    public boolean printErrorMessages() {
        return this.printErrorMessages;
    }

    public IdleStrategy monitoringThreadIdleStrategy() {
        return this.monitoringThreadIdleStrategy;
    }

    public SessionIdStrategy sessionIdStrategy() {
        return this.sessionIdStrategy;
    }

    public SessionCustomisationStrategy sessionCustomisationStrategy() {
        return this.sessionCustomisationStrategy;
    }

    public MessageValidationStrategy messageValidationStrategy() {
        return this.messageValidationStrategy;
    }

    public int monitoringBuffersLength() {
        return this.monitoringBuffersLength;
    }

    public String monitoringFile() {
        return this.monitoringFile;
    }

    public long replyTimeoutInMs() {
        return this.replyTimeoutInMs;
    }

    public long connectAttemptTimeoutInMs() {
        return this.replyTimeoutInMs() / 4L;
    }

    public long histogramPollPeriodInMs() {
        return this.histogramPollPeriodInMs;
    }

    public int inboundMaxClaimAttempts() {
        return this.inboundMaxClaimAttempts;
    }

    public int outboundMaxClaimAttempts() {
        return this.outboundMaxClaimAttempts;
    }

    public int sessionBufferSize() {
        return this.sessionBufferSize;
    }

    public String histogramLoggingFile() {
        return this.histogramLoggingFile;
    }

    public HistogramHandler histogramHandler() {
        return this.histogramHandler;
    }

    public String agentNamePrefix() {
        return this.agentNamePrefix;
    }

    public boolean printAeronStreamIdentifiers() {
        return this.printAeronStreamIdentifiers;
    }

    protected void conclude(String fixSuffix) {
        if (this.isConcluded.compareAndSet(false, true)) {
            if (this.monitoringFile() == null) {
                this.monitoringFile(System.getProperty(MONITORING_FILE_PROPERTY, String.format(DEFAULT_MONITORING_FILE, fixSuffix)));
            }
            if (this.histogramLoggingFile() == null) {
                this.histogramLoggingFile(System.getProperty(HISTOGRAM_LOGGING_FILE_PROPERTY, String.format(DEFAULT_HISTOGRAM_LOGGING_FILE, fixSuffix)));
            }
        } else {
            throw new IllegalStateException("This configuration has already been concluded, are you trying to re-use it?");
        }
        if (this.threadFactory == null) {
            this.threadFactory = Thread::new;
        }
    }

    public static String optimalTmpDirName() {
        File devShmDir;
        if ("Linux".equalsIgnoreCase(System.getProperty("os.name")) && (devShmDir = new File("/dev/shm")).exists()) {
            return devShmDir.getAbsolutePath();
        }
        return IoUtil.tmpDirName();
    }

    public static IdleStrategy backoffIdleStrategy() {
        return new BackoffIdleStrategy((long)BACKOFF_SPINS, (long)BACKOFF_YIELDS, 1L, 0x100000L);
    }

    public Clock clock() {
        return this.clock;
    }

    public int inboundLibraryStream() {
        return this.inboundLibraryStream;
    }

    public int outboundLibraryStream() {
        return this.outboundLibraryStream;
    }

    public ThreadFactory threadFactory() {
        return this.threadFactory;
    }

    static {
        String debugPrintThreadValue;
        String debugPrintMessagesValue = System.getProperty(DEBUG_PRINT_MESSAGES_PROPERTY);
        boolean debugPrintMessages = false;
        Set debugTags = Collections.emptySet();
        if (debugPrintMessagesValue != null) {
            if ("all".equals(debugPrintMessagesValue) || "true".equals(debugPrintMessagesValue)) {
                debugPrintMessages = true;
                debugTags = EnumSet.allOf(LogTag.class);
            } else {
                try {
                    debugTags = Stream.of(debugPrintMessagesValue.split(",")).map(LogTag::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(LogTag.class)));
                    debugPrintMessages = !debugTags.isEmpty();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        DEBUG_PRINT_THREAD = (debugPrintThreadValue = System.getProperty(DEBUG_PRINT_THREAD_PROPERTY)) == null ? null : debugPrintThreadValue + " : ";
        DEBUG_PRINT_MESSAGES = debugPrintMessages;
        DEBUG_TAGS = debugTags;
        String loggingSeparator = System.getProperty(LOGGING_SEPARATOR_PROPERTY);
        DEBUG_LOGGING_SEPARATOR = loggingSeparator == null ? (byte)1 : (byte)loggingSeparator.charAt(0);
        DEBUG_FILE = System.getProperty(DEBUG_FILE_PROPERTY);
        TIME_MESSAGES = Boolean.getBoolean(TIME_MESSAGES_PROPERTY);
        FORCE_WRITES = Boolean.getBoolean(FORCE_WRITES_MESSAGES_PROPERTY);
        BACKOFF_SPINS = Integer.getInteger("fix.core.spins", 100);
        BACKOFF_YIELDS = Integer.getInteger("fix.core.yields", 100);
        DEFAULT_DIRECTORY = CommonConfiguration.optimalTmpDirName() + File.separator + "fix-%s";
        DEFAULT_MONITORING_FILE = DEFAULT_DIRECTORY + File.separator + "monitoring";
        DEFAULT_HISTOGRAM_LOGGING_FILE = DEFAULT_DIRECTORY + File.separator + "histograms";
        DEFAULT_REASONABLE_TRANSMISSION_TIME_IN_MS = TimeUnit.SECONDS.toMillis(3L);
        DEFAULT_OUTBOUND_MAX_CLAIM_ATTEMPTS = DEFAULT_INBOUND_MAX_CLAIM_ATTEMPTS = BACKOFF_SPINS + BACKOFF_YIELDS + 1000;
        DEFAULT_SENDING_TIME_WINDOW = TimeUnit.MINUTES.toMillis(2L);
        DEFAULT_HISTOGRAM_POLL_PERIOD_IN_MS = TimeUnit.MINUTES.toMillis(1L);
    }
}

