/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class SessionWriter {
    private final int libraryId;
    private final long id;
    private final long connectionId;
    private final MutableAsciiBuffer asciiBuffer;
    private final GatewayPublication publication;
    private int sequenceIndex;

    public SessionWriter(int libraryId, long id, long connectionId, MutableAsciiBuffer asciiBuffer, GatewayPublication publication, int sequenceIndex) {
        this.libraryId = libraryId;
        this.id = id;
        this.connectionId = connectionId;
        this.asciiBuffer = asciiBuffer;
        this.publication = publication;
        this.sequenceIndex = sequenceIndex;
    }

    public void sequenceIndex(int sequenceIndex) {
        this.sequenceIndex = sequenceIndex;
    }

    public long send(Encoder encoder, int seqNum) {
        long result = encoder.encode(this.asciiBuffer, 0);
        int length = Encoder.length((long)result);
        int offset = Encoder.offset((long)result);
        return this.send((DirectBuffer)this.asciiBuffer, offset, length, seqNum, encoder.messageType());
    }

    public long send(DirectBuffer messageBuffer, int offset, int length, int seqNum, int messageType) {
        return this.publication.saveMessage(messageBuffer, offset, length, this.libraryId, messageType, this.id, this.sequenceIndex, this.connectionId, MessageStatus.OK, seqNum);
    }

    public long requestDisconnect(DisconnectReason reason) {
        return this.publication.saveRequestDisconnect(this.libraryId, this.connectionId, reason);
    }
}

