/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.storage.messages.SenderAndTargetCompositeKeyDecoder;
import uk.co.real_logic.artio.storage.messages.SenderAndTargetCompositeKeyEncoder;

class SenderAndTargetSessionIdStrategy
implements SessionIdStrategy {
    private static final int BLOCK_AND_LENGTH_FIELDS_LENGTH = 4;
    private final SenderAndTargetCompositeKeyEncoder keyEncoder = new SenderAndTargetCompositeKeyEncoder();
    private final SenderAndTargetCompositeKeyDecoder keyDecoder = new SenderAndTargetCompositeKeyDecoder();
    private final int actingBlockLength = this.keyDecoder.sbeBlockLength();
    private final int actingVersion = this.keyDecoder.sbeSchemaVersion();

    SenderAndTargetSessionIdStrategy() {
    }

    @Override
    public CompositeKey onAcceptLogon(HeaderDecoder header) {
        Objects.requireNonNull(header, "header");
        return new CompositeKeyImpl(header.targetCompID(), header.targetCompIDLength(), header.senderCompID(), header.senderCompIDLength());
    }

    @Override
    public CompositeKey onInitiateLogon(String localCompId, String localSubId, String localLocationId, String remoteCompId, String remoteSubId, String remoteLocationId) {
        Objects.requireNonNull(localCompId, "senderCompId");
        Objects.requireNonNull(remoteCompId, "targetCompId");
        char[] senderCompID = localCompId.toCharArray();
        char[] targetCompID = remoteCompId.toCharArray();
        return new CompositeKeyImpl(senderCompID, senderCompID.length, targetCompID, targetCompID.length);
    }

    @Override
    public void setupSession(CompositeKey compositeKey, SessionHeaderEncoder headerEncoder) {
        Objects.requireNonNull(compositeKey, "compositeKey");
        Objects.requireNonNull(headerEncoder, "headerEncoder");
        CompositeKeyImpl composite = (CompositeKeyImpl)compositeKey;
        headerEncoder.senderCompID(composite.localCompID);
        headerEncoder.targetCompID(composite.remoteCompID);
    }

    @Override
    public int save(CompositeKey compositeKey, MutableDirectBuffer buffer, int offset) {
        Objects.requireNonNull(compositeKey, "compositeKey");
        Objects.requireNonNull(buffer, "buffer");
        CompositeKeyImpl key = (CompositeKeyImpl)compositeKey;
        byte[] senderCompID = key.localCompID;
        byte[] targetCompID = key.remoteCompID;
        int length = senderCompID.length + targetCompID.length + 4;
        if (buffer.capacity() < offset + length) {
            return -1;
        }
        this.keyEncoder.wrap(buffer, offset);
        this.keyEncoder.putLocalCompId(senderCompID, 0, senderCompID.length);
        this.keyEncoder.putRemoteCompId(targetCompID, 0, targetCompID.length);
        return length;
    }

    @Override
    public CompositeKey load(DirectBuffer buffer, int offset, int length) {
        Objects.requireNonNull(buffer, "buffer");
        this.keyDecoder.wrap(buffer, offset, this.actingBlockLength, this.actingVersion);
        int localCompIdLength = this.keyDecoder.localCompIdLength();
        byte[] localCompId = new byte[localCompIdLength];
        this.keyDecoder.getLocalCompId(localCompId, 0, localCompIdLength);
        int remoteCompIdLength = this.keyDecoder.remoteCompIdLength();
        byte[] remoteCompId = new byte[remoteCompIdLength];
        this.keyDecoder.getRemoteCompId(remoteCompId, 0, remoteCompIdLength);
        return new CompositeKeyImpl(localCompId, remoteCompId);
    }

    private static final class CompositeKeyImpl
    implements CompositeKey {
        private final byte[] localCompID;
        private final byte[] remoteCompID;
        private final int hashCode;

        private CompositeKeyImpl(char[] localCompID, int localCompIDLength, char[] remoteCompID, int remoteCompIDLength) {
            this(CodecUtil.toBytes((char[])localCompID, (int)localCompIDLength), CodecUtil.toBytes((char[])remoteCompID, (int)remoteCompIDLength));
        }

        private CompositeKeyImpl(byte[] localCompID, byte[] remoteCompID) {
            this.localCompID = localCompID;
            this.remoteCompID = remoteCompID;
            this.hashCode = this.hash(localCompID, remoteCompID);
        }

        private int hash(byte[] senderCompID, byte[] targetCompID) {
            int result = Arrays.hashCode(senderCompID);
            result = 31 * result + Arrays.hashCode(targetCompID);
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompositeKeyImpl) {
                CompositeKeyImpl compositeKey = (CompositeKeyImpl)obj;
                return Arrays.equals(compositeKey.localCompID, this.localCompID) && Arrays.equals(compositeKey.remoteCompID, this.remoteCompID);
            }
            return false;
        }

        public String toString() {
            return "CompositeKey{localCompId=" + this.localCompId() + ", remoteCompId=" + this.remoteCompId() + '}';
        }

        @Override
        public String localCompId() {
            return new String(this.localCompID, StandardCharsets.US_ASCII);
        }

        @Override
        public String localSubId() {
            return "";
        }

        @Override
        public String localLocationId() {
            return "";
        }

        @Override
        public String remoteCompId() {
            return new String(this.remoteCompID, StandardCharsets.US_ASCII);
        }

        @Override
        public String remoteSubId() {
            return "";
        }

        @Override
        public String remoteLocationId() {
            return "";
        }
    }
}

