/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.ArrayList;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.decoder.ResendRequestDecoder;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.engine.ReplayHandler;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.ReplayerSession;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.ProtocolHandler;
import uk.co.real_logic.artio.protocol.ProtocolSubscription;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class Replayer
implements ProtocolHandler,
Agent {
    static final int MESSAGE_FRAME_BLOCK_LENGTH = 53 + FixMessageDecoder.bodyHeaderLength();
    static final int SIZE_OF_LENGTH_FIELD = 2;
    static final int MOST_RECENT_MESSAGE = 0;
    private static final int POLL_LIMIT = 10;
    private final ResendRequestDecoder resendRequest = new ResendRequestDecoder();
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final BufferClaim bufferClaim;
    private final ProtocolSubscription protocolSubscription = ProtocolSubscription.of(this);
    private final ArrayList<ReplayerSession> replayerSessions = new ArrayList();
    private final ReplayQuery replayQuery;
    private final ExclusivePublication publication;
    private final IdleStrategy idleStrategy;
    private final ErrorHandler errorHandler;
    private final int maxClaimAttempts;
    private final Subscription subscription;
    private final String agentNamePrefix;
    private final IntHashSet gapFillMessageTypes;
    private final EpochClock clock;
    private final ReplayHandler replayHandler;
    private final SenderSequenceNumbers senderSequenceNumbers;

    public Replayer(ReplayQuery replayQuery, ExclusivePublication publication, BufferClaim bufferClaim, IdleStrategy idleStrategy, ErrorHandler errorHandler, int maxClaimAttempts, Subscription subscription, String agentNamePrefix, EpochClock clock, Set<String> gapfillOnReplayMessageTypes, ReplayHandler replayHandler, SenderSequenceNumbers senderSequenceNumbers) {
        this.replayQuery = replayQuery;
        this.publication = publication;
        this.bufferClaim = bufferClaim;
        this.idleStrategy = idleStrategy;
        this.errorHandler = errorHandler;
        this.maxClaimAttempts = maxClaimAttempts;
        this.subscription = subscription;
        this.agentNamePrefix = agentNamePrefix;
        this.clock = clock;
        this.replayHandler = replayHandler;
        this.senderSequenceNumbers = senderSequenceNumbers;
        this.gapFillMessageTypes = new IntHashSet();
        gapfillOnReplayMessageTypes.forEach(messageTypeAsString -> this.gapFillMessageTypes.add(GenerationUtil.packMessageType((String)messageTypeAsString)));
    }

    @Override
    public ControlledFragmentHandler.Action onMessage(DirectBuffer srcBuffer, int srcOffset, int length, int libraryId, long connectionId, long sessionId, int sequenceIndex, int messageType, long timestamp, MessageStatus status, int sequenceNumber, long position) {
        if (messageType == 50 && status == MessageStatus.OK) {
            int limit = Math.min(length, srcBuffer.capacity() - srcOffset);
            this.asciiBuffer.wrap(srcBuffer);
            this.resendRequest.reset();
            this.resendRequest.decode(this.asciiBuffer, srcOffset, limit);
            int beginSeqNo = this.resendRequest.beginSeqNo();
            int endSeqNo = this.resendRequest.endSeqNo();
            DebugLogger.log(LogTag.REPLAY, "Received Resend Request for range: [%d, %d]%n", (long)beginSeqNo, (long)endSeqNo);
            boolean replayUpToMostRecent = endSeqNo == 0;
            String message = this.asciiBuffer.getAscii(srcOffset, limit);
            if (!replayUpToMostRecent && endSeqNo < beginSeqNo) {
                this.errorHandler.onError((Throwable)new IllegalStateException(String.format("[%s] Error in resend request, endSeqNo (%d) < beginSeqNo (%d)", message, endSeqNo, beginSeqNo)));
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            ReplayerSession replayerSession = new ReplayerSession(this.bufferClaim, this.idleStrategy, this.replayHandler, this.maxClaimAttempts, this.gapFillMessageTypes, this.senderSequenceNumbers, this.publication, this.clock, beginSeqNo, endSeqNo, replayUpToMostRecent, connectionId, sessionId, sequenceIndex, this.replayQuery, message, this.errorHandler, this.resendRequest.header());
            replayerSession.query();
            this.replayerSessions.add(replayerSession);
            return ControlledFragmentHandler.Action.COMMIT;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public int doWork() {
        int work = this.senderSequenceNumbers.poll();
        return (work += this.pollReplayerSessions()) + this.subscription.controlledPoll((ControlledFragmentHandler)this.protocolSubscription, 10);
    }

    private int pollReplayerSessions() {
        int lastIndex;
        ArrayList<ReplayerSession> replayerSessions = this.replayerSessions;
        int size = replayerSessions.size();
        for (int i = lastIndex = size - 1; i >= 0; --i) {
            ReplayerSession replayerSession = replayerSessions.get(i);
            if (!replayerSession.attempReplay()) continue;
            ArrayListUtil.fastUnorderedRemove(replayerSessions, (int)i, (int)lastIndex--);
        }
        return size;
    }

    public void onClose() {
        this.publication.close();
        this.replayQuery.close();
    }

    public String roleName() {
        return this.agentNamePrefix + "Replayer";
    }
}

