/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.logbuffer.Header;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.collections.Long2ObjectCache;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.engine.logger.BufferFactory;
import uk.co.real_logic.artio.engine.logger.Index;
import uk.co.real_logic.artio.engine.logger.IndexedPositionConsumer;
import uk.co.real_logic.artio.engine.logger.IndexedPositionReader;
import uk.co.real_logic.artio.engine.logger.IndexedPositionWriter;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordEncoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class ReplayIndex
implements Index {
    private final LongFunction<SessionIndex> newSessionIndex = x$0 -> new SessionIndex(x$0);
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final MessageHeaderDecoder frameHeaderDecoder = new MessageHeaderDecoder();
    private final FixMessageDecoder messageFrame = new FixMessageDecoder();
    private final HeaderDecoder fixHeader = new HeaderDecoder();
    private final ReplayIndexRecordEncoder replayIndexRecord = new ReplayIndexRecordEncoder();
    private final MessageHeaderEncoder indexHeaderEncoder = new MessageHeaderEncoder();
    private final IndexedPositionWriter positionWriter;
    private final IndexedPositionReader positionReader;
    private final Long2ObjectCache<SessionIndex> fixSessionIdToIndex;
    private final String logFileDir;
    private final int requiredStreamId;
    private final int indexFileSize;
    private final BufferFactory bufferFactory;
    private final AtomicBuffer positionBuffer;
    private final RecordingIdLookup recordingIdLookup;
    private long continuedFixSessionId;
    private int continuedSequenceNumber;
    private int continuedSequenceIndex;

    public ReplayIndex(String logFileDir, int requiredStreamId, int indexFileSize, int cacheNumSets, int cacheSetSize, BufferFactory bufferFactory, AtomicBuffer positionBuffer, ErrorHandler errorHandler, RecordingIdLookup recordingIdLookup) {
        this.logFileDir = logFileDir;
        this.requiredStreamId = requiredStreamId;
        this.indexFileSize = indexFileSize;
        this.bufferFactory = bufferFactory;
        this.positionBuffer = positionBuffer;
        this.recordingIdLookup = recordingIdLookup;
        ReplayIndexDescriptor.checkIndexFileSize(indexFileSize);
        this.fixSessionIdToIndex = new Long2ObjectCache(cacheNumSets, cacheSetSize, SessionIndex::close);
        String replayPositionPath = ReplayIndexDescriptor.replayPositionPath(logFileDir, requiredStreamId);
        this.positionWriter = new IndexedPositionWriter(positionBuffer, errorHandler, 0, replayPositionPath);
        this.positionReader = new IndexedPositionReader(positionBuffer);
    }

    public void onFragment(DirectBuffer srcBuffer, int srcOffset, int srcLength, Header header) {
        boolean beginMessage;
        int streamId = header.streamId();
        long endPosition = header.position();
        byte flags = header.flags();
        int length = BitUtil.align((int)srcLength, (int)32);
        if (streamId != this.requiredStreamId) {
            return;
        }
        boolean bl = beginMessage = (flags & 0xFFFFFF80) == -128;
        if ((flags & 0xFFFFFFC0) == -64 || beginMessage) {
            int offset = srcOffset;
            this.frameHeaderDecoder.wrap(srcBuffer, offset);
            if (this.frameHeaderDecoder.templateId() == 1) {
                int actingBlockLength = this.frameHeaderDecoder.blockLength();
                this.messageFrame.wrap(srcBuffer, offset += this.frameHeaderDecoder.encodedLength(), actingBlockLength, this.frameHeaderDecoder.version());
                if (this.messageFrame.status() == MessageStatus.OK) {
                    this.asciiBuffer.wrap(srcBuffer);
                    this.fixHeader.decode(this.asciiBuffer, offset += actingBlockLength + 2, this.messageFrame.bodyLength());
                    long fixSessionId = this.messageFrame.session();
                    int sequenceNumber = this.fixHeader.msgSeqNum();
                    int sequenceIndex = this.messageFrame.sequenceIndex();
                    if (beginMessage) {
                        this.continuedFixSessionId = fixSessionId;
                        this.continuedSequenceNumber = sequenceNumber;
                        this.continuedSequenceIndex = sequenceIndex;
                    }
                    ((SessionIndex)this.fixSessionIdToIndex.computeIfAbsent(fixSessionId, this.newSessionIndex)).onRecord(endPosition, length, sequenceNumber, sequenceIndex, header);
                }
            }
        } else {
            ((SessionIndex)this.fixSessionIdToIndex.computeIfAbsent(this.continuedFixSessionId, this.newSessionIndex)).onRecord(endPosition, length, this.continuedSequenceNumber, this.continuedSequenceIndex, header);
        }
        int aeronSessionId = header.sessionId();
        long recordingId = this.recordingIdLookup.getRecordingId(aeronSessionId);
        this.positionWriter.indexedUpTo(aeronSessionId, recordingId, endPosition);
        this.positionWriter.updateChecksums();
    }

    @Override
    public void close() {
        this.positionWriter.close();
        this.fixSessionIdToIndex.clear();
        IoUtil.unmap((ByteBuffer)this.positionBuffer.byteBuffer());
    }

    @Override
    public void readLastPosition(IndexedPositionConsumer consumer) {
        this.positionReader.readLastPosition(consumer);
    }

    private final class SessionIndex
    implements AutoCloseable {
        private final ByteBuffer wrappedBuffer;
        private final AtomicBuffer buffer;
        private final int recordCapacity;

        SessionIndex(long fixSessionId) {
            File logFile = ReplayIndexDescriptor.replayIndexFile(ReplayIndex.this.logFileDir, fixSessionId, ReplayIndex.this.requiredStreamId);
            boolean exists = logFile.exists();
            this.wrappedBuffer = ReplayIndex.this.bufferFactory.map(logFile, ReplayIndex.this.indexFileSize);
            this.buffer = new UnsafeBuffer(this.wrappedBuffer);
            this.recordCapacity = ReplayIndexDescriptor.recordCapacity(this.buffer.capacity());
            if (!exists) {
                ReplayIndex.this.indexHeaderEncoder.wrap((MutableDirectBuffer)this.buffer, 0).blockLength(ReplayIndex.this.replayIndexRecord.sbeBlockLength()).templateId(ReplayIndex.this.replayIndexRecord.sbeTemplateId()).schemaId(ReplayIndex.this.replayIndexRecord.sbeSchemaId()).version(ReplayIndex.this.replayIndexRecord.sbeSchemaVersion());
            } else {
                long resetPosition = ReplayIndexDescriptor.beginChange(this.buffer);
                ReplayIndexDescriptor.endChangeOrdered(this.buffer, resetPosition);
            }
        }

        void onRecord(long endPosition, int length, int sequenceNumber, int sequenceIndex, Header header) {
            long beginChangePosition = ReplayIndexDescriptor.beginChange(this.buffer);
            long changePosition = beginChangePosition + 32L;
            int aeronSessionId = header.sessionId();
            long recordingId = ReplayIndex.this.recordingIdLookup.getRecordingId(aeronSessionId);
            long beginPosition = endPosition - (long)length;
            ReplayIndexDescriptor.beginChangeOrdered(this.buffer, changePosition);
            UnsafeAccess.UNSAFE.storeFence();
            int offset = ReplayIndexDescriptor.offset(beginChangePosition, this.recordCapacity);
            ReplayIndex.this.replayIndexRecord.wrap((MutableDirectBuffer)this.buffer, offset).position(beginPosition).sequenceNumber(sequenceNumber).sequenceIndex(sequenceIndex).recordingId(recordingId).length(length);
            ReplayIndexDescriptor.endChangeOrdered(this.buffer, changePosition);
        }

        @Override
        public void close() {
            IoUtil.unmap((ByteBuffer)this.wrappedBuffer);
        }
    }
}

