/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.ArrayList;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.decoder.LogonDecoder;
import uk.co.real_logic.artio.engine.framer.AcceptorLogonResult;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.DirectSessionProxy;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionParser;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.AuthenticationProxy;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;
import uk.co.real_logic.artio.validation.PersistenceLevel;
import uk.co.real_logic.artio.validation.SessionPersistenceStrategy;

class GatewaySessions {
    private final List<GatewaySession> sessions = new ArrayList<GatewaySession>();
    private final EpochClock clock;
    private final GatewayPublication outboundPublication;
    private final SessionIdStrategy sessionIdStrategy;
    private final SessionCustomisationStrategy customisationStrategy;
    private final FixCounters fixCounters;
    private final AuthenticationStrategy authenticationStrategy;
    private final MessageValidationStrategy validationStrategy;
    private final int sessionBufferSize;
    private final long sendingTimeWindowInMs;
    private final long reasonableTransmissionTimeInMs;
    private final boolean logAllMessages;
    private final SessionContexts sessionContexts;
    private final SessionPersistenceStrategy sessionPersistenceStrategy;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private ErrorHandler errorHandler;

    GatewaySessions(EpochClock clock, GatewayPublication outboundPublication, SessionIdStrategy sessionIdStrategy, SessionCustomisationStrategy customisationStrategy, FixCounters fixCounters, AuthenticationStrategy authenticationStrategy, MessageValidationStrategy validationStrategy, int sessionBufferSize, long sendingTimeWindowInMs, long reasonableTransmissionTimeInMs, boolean logAllMessages, ErrorHandler errorHandler, SessionContexts sessionContexts, SessionPersistenceStrategy sessionPersistenceStrategy, SequenceNumberIndexReader sentSequenceNumberIndex, SequenceNumberIndexReader receivedSequenceNumberIndex) {
        this.clock = clock;
        this.outboundPublication = outboundPublication;
        this.sessionIdStrategy = sessionIdStrategy;
        this.customisationStrategy = customisationStrategy;
        this.fixCounters = fixCounters;
        this.authenticationStrategy = authenticationStrategy;
        this.validationStrategy = validationStrategy;
        this.sessionBufferSize = sessionBufferSize;
        this.sendingTimeWindowInMs = sendingTimeWindowInMs;
        this.reasonableTransmissionTimeInMs = reasonableTransmissionTimeInMs;
        this.logAllMessages = logAllMessages;
        this.errorHandler = errorHandler;
        this.sessionContexts = sessionContexts;
        this.sessionPersistenceStrategy = sessionPersistenceStrategy;
        this.sentSequenceNumberIndex = sentSequenceNumberIndex;
        this.receivedSequenceNumberIndex = receivedSequenceNumberIndex;
    }

    static GatewaySession removeSessionByConnectionId(long connectionId, List<GatewaySession> sessions) {
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.connectionId() != connectionId) continue;
            sessions.remove(i);
            return session;
        }
        return null;
    }

    void acquire(GatewaySession gatewaySession, SessionState state, boolean awaitingResend, int heartbeatIntervalInS, int lastSentSequenceNumber, int lastReceivedSequenceNumber, String username, String password, BlockablePosition engineBlockablePosition) {
        long connectionId = gatewaySession.connectionId();
        AtomicCounter receivedMsgSeqNo = this.fixCounters.receivedMsgSeqNo(connectionId);
        AtomicCounter sentMsgSeqNo = this.fixCounters.sentMsgSeqNo(connectionId);
        MutableAsciiBuffer asciiBuffer = new MutableAsciiBuffer(new byte[this.sessionBufferSize]);
        DirectSessionProxy proxy = new DirectSessionProxy(this.sessionBufferSize, this.outboundPublication, this.sessionIdStrategy, this.customisationStrategy, this.clock, connectionId, 0);
        InternalSession session = new InternalSession(heartbeatIntervalInS, connectionId, this.clock, state, proxy, this.outboundPublication, this.sessionIdStrategy, this.sendingTimeWindowInMs, receivedMsgSeqNo, sentMsgSeqNo, 0, lastSentSequenceNumber + 1, 0, this.reasonableTransmissionTimeInMs, asciiBuffer, gatewaySession.enableLastMsgSeqNumProcessed());
        session.awaitingResend(awaitingResend);
        session.closedResendInterval(gatewaySession.closedResendInterval());
        session.resendRequestChunkSize(gatewaySession.resendRequestChunkSize());
        session.sendRedundantResendRequests(gatewaySession.sendRedundantResendRequests());
        SessionParser sessionParser = new SessionParser(session, this.validationStrategy, this.errorHandler);
        this.sessions.add(gatewaySession);
        gatewaySession.manage(sessionParser, session, engineBlockablePosition);
        CompositeKey sessionKey = gatewaySession.sessionKey();
        DebugLogger.log(LogTag.FIX_CONNECTION, "Gateway Acquired Session %d%n", connectionId);
        if (sessionKey != null) {
            gatewaySession.onLogon(username, password, heartbeatIntervalInS);
            session.lastReceivedMsgSeqNum(lastReceivedSequenceNumber);
        }
    }

    GatewaySession releaseBySessionId(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.remove(index);
    }

    GatewaySession sessionById(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.get(index);
    }

    private int indexBySessionId(long sessionId) {
        List<GatewaySession> sessions = this.sessions;
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.sessionId() != sessionId) continue;
            return i;
        }
        return -1;
    }

    void releaseByConnectionId(long connectionId) {
        GatewaySession session = GatewaySessions.removeSessionByConnectionId(connectionId, this.sessions);
        if (session != null) {
            session.close();
        }
    }

    int pollSessions(long time) {
        List<GatewaySession> sessions = this.sessions;
        int eventsProcessed = 0;
        int i = 0;
        int size = sessions.size();
        while (i < size) {
            GatewaySession session = sessions.get(i);
            eventsProcessed += session.poll(time);
            if (session.hasDisconnected()) {
                --size;
                continue;
            }
            ++i;
        }
        return eventsProcessed;
    }

    List<GatewaySession> sessions() {
        return this.sessions;
    }

    AcceptorLogonResult authenticate(LogonDecoder logon, long connectionId, GatewaySession gatewaySession) {
        CompositeKey compositeKey = this.sessionIdStrategy.onAcceptLogon(logon.header());
        SessionContext sessionContext = this.sessionContexts.onLogon(compositeKey);
        return new PendingAcceptorLogon(sessionContext, gatewaySession, logon, connectionId, compositeKey);
    }

    public boolean lookupSequenceNumbers(GatewaySession gatewaySession, long requiredPosition) {
        int aeronSessionId = this.outboundPublication.id();
        if (requiredPosition > 0L && this.sentSequenceNumberIndex.indexedPosition(aeronSessionId) < requiredPosition) {
            return false;
        }
        long sessionId = gatewaySession.sessionId();
        int lastSentSequenceNumber = this.sentSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        int lastReceivedSequenceNumber = this.receivedSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        gatewaySession.acceptorSequenceNumbers(lastSentSequenceNumber, lastReceivedSequenceNumber);
        return true;
    }

    private final class PendingAcceptorLogon
    implements AuthenticationProxy,
    AcceptorLogonResult {
        private static final long NO_REQUIRED_POSITION = -1L;
        private final SessionContext sessionContext;
        private final LogonDecoder logon;
        private final CompositeKey compositeKey;
        private final boolean resetSeqNum;
        private volatile AuthenticationState state = AuthenticationState.PENDING;
        private GatewaySession session;
        private DisconnectReason reason;
        private long requiredPosition = -1L;

        PendingAcceptorLogon(SessionContext sessionContext, GatewaySession gatewaySession, LogonDecoder logon, long connectionId, CompositeKey compositeKey) {
            this.sessionContext = sessionContext;
            this.session = gatewaySession;
            this.logon = logon;
            this.compositeKey = compositeKey;
            if (sessionContext == SessionContexts.DUPLICATE_SESSION) {
                this.resetSeqNum = false;
                this.reject(DisconnectReason.DUPLICATE_SESSION);
                return;
            }
            PersistenceLevel persistenceLevel = this.getPersistenceLevel(logon, connectionId);
            boolean resetSeqNumFlag = logon.hasResetSeqNumFlag() && logon.resetSeqNumFlag();
            boolean bl = this.resetSeqNum = SessionPersistenceStrategy.resetSequenceNumbersUponLogon(persistenceLevel) || resetSeqNumFlag;
            if (persistenceLevel == PersistenceLevel.INDEXED && !GatewaySessions.this.logAllMessages) {
                this.onError(new IllegalStateException("Persistence Strategy specified INDEXED but EngineConfiguration has disabled required logging of messsages"));
                this.reject(DisconnectReason.INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES);
                return;
            }
            this.authenticate(logon, connectionId);
        }

        private PersistenceLevel getPersistenceLevel(LogonDecoder logon, long connectionId) {
            try {
                return GatewaySessions.this.sessionPersistenceStrategy.getPersistenceLevel(logon);
            }
            catch (Throwable throwable) {
                this.onStrategyError("persistence", throwable, connectionId, "UNINDEXED", logon);
                return PersistenceLevel.UNINDEXED;
            }
        }

        private void authenticate(LogonDecoder logon, long connectionId) {
            try {
                GatewaySessions.this.authenticationStrategy.authenticateAsync(logon, this);
            }
            catch (Throwable throwable) {
                this.onStrategyError("authentication", throwable, connectionId, "false", logon);
                this.reject();
            }
        }

        private void onStrategyError(String strategyName, Throwable throwable, long connectionId, String theDefault, LogonDecoder logon) {
            String message = String.format("Exception thrown by %s strategy for connectionId=%d, processing [%s], defaulted to %s", strategyName, connectionId, logon.toString(), theDefault);
            this.onError(new FixGatewayException(message, throwable));
        }

        private void onError(Throwable throwable) {
            if (GatewaySessions.this.errorHandler == null) {
                LangUtil.rethrowUnchecked((Throwable)throwable);
            } else {
                GatewaySessions.this.errorHandler.onError(throwable);
            }
        }

        @Override
        public DisconnectReason reason() {
            return this.reason;
        }

        @Override
        public void accept() {
            this.state = AuthenticationState.AUTHENTICATED;
        }

        @Override
        public boolean poll() {
            switch (this.state) {
                case AUTHENTICATED: {
                    this.onAuthenticated();
                    return false;
                }
                case ACCEPTED: 
                case REJECTED: {
                    return true;
                }
                case INDEXER_CATCHUP: {
                    this.onIndexerCatchup();
                    return false;
                }
            }
            return false;
        }

        private void onIndexerCatchup() {
            if (GatewaySessions.this.lookupSequenceNumbers(this.session, this.requiredPosition)) {
                this.state = AuthenticationState.ACCEPTED;
            }
        }

        private void onAuthenticated() {
            String username = SessionParser.username(this.logon);
            String password = SessionParser.password(this.logon);
            this.sessionContext.onLogon(this.resetSeqNum);
            this.session.initialResetSeqNum(this.resetSeqNum);
            this.session.onLogon(this.sessionContext.sessionId(), this.sessionContext, this.compositeKey, username, password, this.logon.heartBtInt());
            if (this.resetSeqNum) {
                this.session.acceptorSequenceNumbers(-1, -1);
                this.state = AuthenticationState.ACCEPTED;
            } else {
                this.requiredPosition = GatewaySessions.this.outboundPublication.position();
                this.state = AuthenticationState.INDEXER_CATCHUP;
            }
        }

        @Override
        public void reject() {
            this.reject(DisconnectReason.FAILED_AUTHENTICATION);
        }

        private void reject(DisconnectReason reason) {
            this.session = null;
            this.reason = reason;
            this.state = AuthenticationState.REJECTED;
        }

        @Override
        public boolean isAccepted() {
            return AuthenticationState.ACCEPTED == this.state;
        }
    }

    static enum AuthenticationState {
        PENDING,
        AUTHENTICATED,
        INDEXER_CATCHUP,
        ACCEPTED,
        REJECTED;

    }
}

