/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.archive.client.AeronArchive;
import io.aeron.logbuffer.BufferClaim;
import java.util.ArrayList;
import java.util.Arrays;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.CompositeAgent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import uk.co.real_logic.artio.Clock;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.StreamInformation;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.CompletionPosition;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.PositionSender;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.logger.GapFiller;
import uk.co.real_logic.artio.engine.logger.Index;
import uk.co.real_logic.artio.engine.logger.Indexer;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.engine.logger.ReplayIndex;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.Replayer;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexWriter;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.Streams;

public class EngineContext
implements AutoCloseable {
    private final Clock clock;
    private final EngineConfiguration configuration;
    private final ErrorHandler errorHandler;
    private final FixCounters fixCounters;
    private final Aeron aeron;
    private final SenderSequenceNumbers senderSequenceNumbers;
    private final AeronArchive aeronArchive;
    private final RecordingCoordinator recordingCoordinator;
    private final ExclusivePublication replayPublication;
    private final SequenceNumberIndexWriter sentSequenceNumberIndex;
    private final SequenceNumberIndexWriter receivedSequenceNumberIndex;
    private final CompletionPosition inboundCompletionPosition = new CompletionPosition();
    private final CompletionPosition outboundLibraryCompletionPosition = new CompletionPosition();
    private final CompletionPosition outboundClusterCompletionPosition = new CompletionPosition();
    private Streams inboundLibraryStreams;
    private Streams outboundLibraryStreams;
    private Indexer inboundIndexer;
    private Indexer outboundIndexer;
    private Agent archivingAgent;

    EngineContext(EngineConfiguration configuration, ErrorHandler errorHandler, ExclusivePublication replayPublication, FixCounters fixCounters, Aeron aeron, AeronArchive aeronArchive, RecordingCoordinator recordingCoordinator) {
        this.configuration = configuration;
        this.errorHandler = errorHandler;
        this.fixCounters = fixCounters;
        this.aeron = aeron;
        this.clock = configuration.clock();
        this.replayPublication = replayPublication;
        this.aeronArchive = aeronArchive;
        this.recordingCoordinator = recordingCoordinator;
        this.senderSequenceNumbers = new SenderSequenceNumbers(configuration.framerIdleStrategy());
        try {
            SystemEpochClock epochClock = new SystemEpochClock();
            this.sentSequenceNumberIndex = new SequenceNumberIndexWriter(configuration.sentSequenceNumberBuffer(), configuration.sentSequenceNumberIndex(), errorHandler, configuration.outboundLibraryStream(), recordingCoordinator.outboundRecordingIdLookup(), configuration.indexFileStateFlushTimeoutInMs(), (EpochClock)epochClock);
            this.receivedSequenceNumberIndex = new SequenceNumberIndexWriter(configuration.receivedSequenceNumberBuffer(), configuration.receivedSequenceNumberIndex(), errorHandler, configuration.inboundLibraryStream(), recordingCoordinator.inboundRecordingIdLookup(), configuration.indexFileStateFlushTimeoutInMs(), (EpochClock)epochClock);
            this.newStreams();
            this.newArchivingAgent();
        }
        catch (Exception e) {
            this.completeDuringStartup();
            Exceptions.suppressingClose((AutoCloseable)this, (Exception)e);
            throw e;
        }
    }

    private void newStreams() {
        String libraryAeronChannel = this.configuration.libraryAeronChannel();
        boolean printAeronStreamIdentifiers = this.configuration.printAeronStreamIdentifiers();
        this.inboundLibraryStreams = new Streams(this.aeron, libraryAeronChannel, printAeronStreamIdentifiers, this.fixCounters.failedInboundPublications(), this.configuration.inboundLibraryStream(), this.clock, this.configuration.inboundMaxClaimAttempts(), this.recordingCoordinator);
        this.outboundLibraryStreams = new Streams(this.aeron, libraryAeronChannel, printAeronStreamIdentifiers, this.fixCounters.failedOutboundPublications(), this.configuration.outboundLibraryStream(), this.clock, this.configuration.outboundMaxClaimAttempts(), this.recordingCoordinator);
    }

    private ReplayIndex newReplayIndex(int cacheSetSize, int cacheNumSets, String logFileDir, int streamId, RecordingIdLookup recordingIdLookup) {
        return new ReplayIndex(logFileDir, streamId, this.configuration.replayIndexFileSize(), cacheNumSets, cacheSetSize, LoggerUtil::map, (AtomicBuffer)ReplayIndexDescriptor.replayPositionBuffer(logFileDir, streamId), this.errorHandler, recordingIdLookup);
    }

    private ReplayQuery newReplayQuery(IdleStrategy idleStrategy, int streamId) {
        String logFileDir = this.configuration.logFileDir();
        int cacheSetSize = this.configuration.loggerCacheSetSize();
        int cacheNumSets = this.configuration.loggerCacheNumSets();
        int archiveReplayStream = this.configuration.archiveReplayStream();
        return new ReplayQuery(logFileDir, cacheNumSets, cacheSetSize, LoggerUtil::mapExistingFile, streamId, idleStrategy, this.aeronArchive, this.errorHandler, archiveReplayStream);
    }

    private Replayer newReplayer(ExclusivePublication replayPublication) {
        return new Replayer(this.newReplayQuery(this.configuration.archiverIdleStrategy(), this.configuration.outboundLibraryStream()), replayPublication, new BufferClaim(), this.configuration.archiverIdleStrategy(), this.errorHandler, this.configuration.outboundMaxClaimAttempts(), this.inboundLibraryStreams.subscription("replayer"), this.configuration.agentNamePrefix(), (EpochClock)new SystemEpochClock(), this.configuration.gapfillOnReplayMessageTypes(), this.configuration.replayHandler(), this.senderSequenceNumbers);
    }

    private void newIndexers() {
        int cacheSetSize = this.configuration.loggerCacheSetSize();
        int cacheNumSets = this.configuration.loggerCacheNumSets();
        String logFileDir = this.configuration.logFileDir();
        ReplayIndex inboundReplayIndex = this.newReplayIndex(cacheSetSize, cacheNumSets, logFileDir, this.configuration.inboundLibraryStream(), this.recordingCoordinator.inboundRecordingIdLookup());
        this.inboundIndexer = new Indexer(Arrays.asList(inboundReplayIndex, this.receivedSequenceNumberIndex), this.inboundLibraryStreams.subscription("inboundIndexer"), this.configuration.agentNamePrefix(), this.inboundCompletionPosition, this.aeronArchive, this.errorHandler, this.configuration.archiveReplayStream());
        ArrayList<Index> outboundIndices = new ArrayList<Index>();
        outboundIndices.add(this.newReplayIndex(cacheSetSize, cacheNumSets, logFileDir, this.configuration.outboundLibraryStream(), this.recordingCoordinator.outboundRecordingIdLookup()));
        outboundIndices.add(this.sentSequenceNumberIndex);
        outboundIndices.add(new PositionSender(this.inboundPublication()));
        this.outboundIndexer = new Indexer(outboundIndices, this.outboundLibraryStreams.subscription("outboundIndexer"), this.configuration.agentNamePrefix(), this.outboundLibraryCompletionPosition, this.aeronArchive, this.errorHandler, this.configuration.archiveReplayStream());
    }

    private void newArchivingAgent() {
        if (this.configuration.logOutboundMessages()) {
            this.newIndexers();
            Replayer replayer = this.newReplayer(this.replayPublication);
            ArrayList<Object> agents = new ArrayList<Object>();
            agents.add(this.inboundIndexer);
            agents.add(this.outboundIndexer);
            agents.add(replayer);
            this.archivingAgent = new CompositeAgent(agents);
        } else {
            GatewayPublication replayGatewayPublication = new GatewayPublication(this.replayPublication, this.fixCounters.failedReplayPublications(), this.configuration.archiverIdleStrategy(), this.clock, this.configuration.outboundMaxClaimAttempts());
            this.archivingAgent = new GapFiller(this.inboundLibraryStreams.subscription("replayer"), replayGatewayPublication, this.configuration.agentNamePrefix(), this.senderSequenceNumbers);
        }
    }

    public Streams outboundLibraryStreams() {
        return this.outboundLibraryStreams;
    }

    public Subscription outboundLibrarySubscription(String name, UnavailableImageHandler unavailableImageHandler) {
        Subscription subscription = this.aeron.addSubscription(this.configuration.libraryAeronChannel(), this.configuration.outboundLibraryStream(), null, unavailableImageHandler);
        StreamInformation.print(name, subscription, (CommonConfiguration)this.configuration);
        return subscription;
    }

    public ReplayQuery inboundReplayQuery() {
        if (!this.configuration.logInboundMessages()) {
            return null;
        }
        return this.newReplayQuery(this.configuration.framerIdleStrategy(), this.configuration.inboundLibraryStream());
    }

    public GatewayPublication inboundPublication() {
        return this.inboundLibraryStreams.gatewayPublication(this.configuration.framerIdleStrategy(), "inboundPublication");
    }

    public CompletionPosition inboundCompletionPosition() {
        return this.inboundCompletionPosition;
    }

    public CompletionPosition outboundLibraryCompletionPosition() {
        return this.outboundLibraryCompletionPosition;
    }

    void completeDuringStartup() {
        this.inboundCompletionPosition.completeDuringStartup();
        this.outboundLibraryCompletionPosition.completeDuringStartup();
        this.outboundClusterCompletionPosition.completeDuringStartup();
    }

    Agent archivingAgent() {
        return this.archivingAgent;
    }

    public SenderSequenceNumbers senderSequenceNumbers() {
        return this.senderSequenceNumbers;
    }

    @Override
    public void close() {
        Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex});
    }
}

