/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.Aeron;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CompositeAgent;
import uk.co.real_logic.artio.engine.EngineScheduler;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryScheduler;

public class SharedLibraryScheduler
implements LibraryScheduler {
    private static final int AGENTS_PER_LIBRARY = 2;
    private final int libraryCount;
    private final List<Agent> agents = new ArrayList<Agent>();
    private AgentRunner runner;

    public SharedLibraryScheduler(int libraryCount) {
        this.libraryCount = libraryCount;
    }

    @Override
    public synchronized void launch(LibraryConfiguration configuration, ErrorHandler errorHandler, Agent monitoringAgent, Agent conductorAgent) {
        if (this.runner != null) {
            EngineScheduler.fail();
        }
        this.agents.add(monitoringAgent);
        this.agents.add(conductorAgent);
        if (2 * this.libraryCount == this.agents.size()) {
            this.runner = new AgentRunner(configuration.monitoringThreadIdleStrategy(), errorHandler, null, (Agent)new CompositeAgent(this.agents));
            AgentRunner.startOnThread((AgentRunner)this.runner, (ThreadFactory)configuration.threadFactory());
        }
    }

    @Override
    public synchronized void close(int libraryId) {
        EngineScheduler.awaitRunnerStart(this.runner);
        CloseHelper.close((AutoCloseable)this.runner);
    }

    @Override
    public void configure(Aeron.Context aeronContext) {
        aeronContext.useConductorAgentInvoker(true);
    }
}

