/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.Aeron;
import io.aeron.Subscription;
import uk.co.real_logic.artio.Clock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.StreamInformation;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.Streams;

class LibraryTransport {
    private final LibraryConfiguration configuration;
    private final FixCounters fixCounters;
    private final Aeron aeron;
    private final Clock clock;
    private Subscription inboundSubscription;
    private GatewayPublication outboundPublication;

    LibraryTransport(LibraryConfiguration configuration, FixCounters fixCounters, Aeron aeron) {
        this.configuration = configuration;
        this.fixCounters = fixCounters;
        this.aeron = aeron;
        this.clock = configuration.clock();
    }

    void initStreams(String aeronChannel) {
        DebugLogger.log(LogTag.LIBRARY_CONNECT, "Directed streams at %s%n", aeronChannel);
        Streams outboundLibraryStreams = new Streams(this.aeron, aeronChannel, this.configuration.printAeronStreamIdentifiers(), this.fixCounters.failedOutboundPublications(), this.configuration.outboundLibraryStream(), this.clock, this.configuration.outboundMaxClaimAttempts(), null);
        if (this.isReconnect()) {
            this.inboundSubscription.close();
            this.outboundPublication.close();
        }
        this.inboundSubscription = this.aeron.addSubscription(aeronChannel, this.configuration.inboundLibraryStream());
        StreamInformation.print("library " + this.configuration.libraryId() + " inboundSubscription", this.inboundSubscription, this.configuration);
        this.outboundPublication = outboundLibraryStreams.gatewayPublication(this.configuration.libraryIdleStrategy(), "outboundPublication");
    }

    Subscription inboundSubscription() {
        return this.inboundSubscription;
    }

    GatewayPublication outboundPublication() {
        return this.outboundPublication;
    }

    boolean isReconnect() {
        return this.inboundSubscription != null;
    }
}

