/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import java.util.function.Consumer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.engine.logger.LogEntryHandler;

public class FixMessageLogger
implements Agent {
    private final Aeron aeron;
    private final Subscription outboundSubscription;
    private final Subscription inboundSubscription;
    private final FragmentAssembler fragmentAssembler;

    public static void main(String[] args) {
        FixMessageLogger logger = new FixMessageLogger(System.out::println, new Aeron.Context(), "aeron:ipc", 1, 2);
        AgentRunner runner = new AgentRunner(CommonConfiguration.backoffIdleStrategy(), Throwable::printStackTrace, null, (Agent)logger);
        AgentRunner.startOnThread((AgentRunner)runner);
    }

    public FixMessageLogger(Consumer<String> fixMessageConsumer, Aeron.Context context, String libraryAeronChannel, int inboundStreamId, int outboundStreamId) {
        this.aeron = Aeron.connect((Aeron.Context)context);
        this.inboundSubscription = this.aeron.addSubscription(libraryAeronChannel, inboundStreamId);
        this.outboundSubscription = this.aeron.addSubscription(libraryAeronChannel, outboundStreamId);
        LogEntryHandler logEntryHandler = new LogEntryHandler((message, buffer, offset, length, header) -> fixMessageConsumer.accept(message.body()));
        this.fragmentAssembler = new FragmentAssembler((FragmentHandler)logEntryHandler);
    }

    public int doWork() {
        return this.inboundSubscription.poll((FragmentHandler)this.fragmentAssembler, 10) + this.outboundSubscription.poll((FragmentHandler)this.fragmentAssembler, 10);
    }

    public void onClose() {
        this.aeron.close();
    }

    public String roleName() {
        return "FixMessageLogger";
    }
}

