/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.stream.Stream;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.decoder.HeartbeatDecoder;
import uk.co.real_logic.artio.decoder.LogonDecoder;
import uk.co.real_logic.artio.decoder.LogoutDecoder;
import uk.co.real_logic.artio.decoder.RejectDecoder;
import uk.co.real_logic.artio.decoder.SequenceResetDecoder;
import uk.co.real_logic.artio.decoder.TestRequestDecoder;
import uk.co.real_logic.artio.fields.UtcTimestampDecoder;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

public class SessionParser {
    private static final boolean HAS_USER_NAME_AND_PASSWORD = SessionParser.detectUsernameAndPassword();
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final UtcTimestampDecoder timestampDecoder = new UtcTimestampDecoder();
    private final LogonDecoder logon = new LogonDecoder();
    private final LogoutDecoder logout = new LogoutDecoder();
    private final RejectDecoder reject = new RejectDecoder();
    private final TestRequestDecoder testRequest = new TestRequestDecoder();
    private final HeaderDecoder header = new HeaderDecoder();
    private final SequenceResetDecoder sequenceReset = new SequenceResetDecoder();
    private final HeartbeatDecoder heartbeat = new HeartbeatDecoder();
    private byte[] msgTypeBuffer = new byte[2];
    private final Session session;
    private final SessionIdStrategy sessionIdStrategy;
    private final MessageValidationStrategy validationStrategy;
    private ErrorHandler errorHandler;

    public SessionParser(Session session, SessionIdStrategy sessionIdStrategy, MessageValidationStrategy validationStrategy, ErrorHandler errorHandler) {
        this.session = session;
        this.sessionIdStrategy = sessionIdStrategy;
        this.validationStrategy = validationStrategy;
        this.errorHandler = errorHandler;
    }

    public static String username(LogonDecoder logon) {
        return HAS_USER_NAME_AND_PASSWORD ? logon.usernameAsString() : null;
    }

    public static String password(LogonDecoder logon) {
        return HAS_USER_NAME_AND_PASSWORD ? logon.passwordAsString() : null;
    }

    private static boolean detectUsernameAndPassword() {
        return Stream.of(LogonDecoder.class.getMethods()).anyMatch(method -> "usernameAsString".equals(method.getName()));
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int messageType, long sessionId) {
        this.asciiBuffer.wrap(buffer);
        ControlledFragmentHandler.Action action = null;
        switch (messageType) {
            case 65: {
                action = this.onLogon(offset, length);
                break;
            }
            case 53: {
                action = this.onLogout(offset, length);
                break;
            }
            case 48: {
                action = this.onHeartbeat(offset, length);
                break;
            }
            case 51: {
                action = this.onReject(offset, length);
                break;
            }
            case 49: {
                action = this.onTestRequest(offset, length);
                break;
            }
            case 52: {
                action = this.onSequenceReset(offset, length);
                break;
            }
            default: {
                return this.onAnyOtherMessage(offset, length);
            }
        }
        this.session.updateLastMessageProcessed();
        return action;
    }

    private ControlledFragmentHandler.Action onHeartbeat(int offset, int length) {
        HeartbeatDecoder heartbeat = this.heartbeat;
        heartbeat.reset();
        heartbeat.decode(this.asciiBuffer, offset, length);
        HeaderDecoder header = heartbeat.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || heartbeat.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)heartbeat, header, false);
        }
        if (heartbeat.hasTestReqID()) {
            long origSendingTime = this.origSendingTime(header);
            long sendingTime = this.sendingTime(header);
            int testReqIDLength = heartbeat.testReqIDLength();
            char[] testReqID = heartbeat.testReqID();
            int msgSeqNum = header.msgSeqNum();
            boolean possDup = this.isPossDup(header);
            return this.session.onHeartbeat(msgSeqNum, testReqID, testReqIDLength, sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup);
        }
        return this.onMessage(header);
    }

    private long sendingTime(HeaderDecoder header) {
        byte[] sendingTime = header.sendingTime();
        return this.decodeTimestamp(sendingTime);
    }

    private long decodeTimestamp(byte[] sendingTime) {
        return Validation.CODEC_VALIDATION_ENABLED ? this.timestampDecoder.decode(sendingTime, sendingTime.length) : Long.MIN_VALUE;
    }

    private ControlledFragmentHandler.Action onAnyOtherMessage(int offset, int length) {
        HeaderDecoder header = this.header;
        header.reset();
        header.decode(this.asciiBuffer, offset, length);
        char[] msgType = header.msgType();
        int msgTypeLength = header.msgTypeLength();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || Validation.isValidMsgType((char[])msgType, (int)msgTypeLength) && this.validateHeader(header))) {
            int msgSeqNum = header.msgSeqNum();
            if (!this.isDisconnectedOrAwaitingLogout()) {
                return this.session.onInvalidMessageType(msgSeqNum, msgType, msgTypeLength);
            }
        } else {
            return this.onMessage(header);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onMessage(HeaderDecoder header) {
        long origSendingTime = this.origSendingTime(header);
        long sendingTime = this.sendingTime(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onMessage(header.msgSeqNum(), header.msgType(), header.msgTypeLength(), sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup);
    }

    private long origSendingTime(HeaderDecoder header) {
        return header.hasOrigSendingTime() ? this.decodeTimestamp(header.origSendingTime()) : -1L;
    }

    private ControlledFragmentHandler.Action onSequenceReset(int offset, int length) {
        SequenceResetDecoder sequenceReset = this.sequenceReset;
        sequenceReset.reset();
        sequenceReset.decode(this.asciiBuffer, offset, length);
        HeaderDecoder header = sequenceReset.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || sequenceReset.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)sequenceReset, header, false);
        }
        boolean gapFillFlag = sequenceReset.hasGapFillFlag() && sequenceReset.gapFillFlag();
        boolean possDup = this.isPossDup(header);
        return this.session.onSequenceReset(header.msgSeqNum(), sequenceReset.newSeqNo(), gapFillFlag, this.isPossDupOrResend(possDup, header));
    }

    private ControlledFragmentHandler.Action onTestRequest(int offset, int length) {
        TestRequestDecoder testRequest = this.testRequest;
        testRequest.reset();
        testRequest.decode(this.asciiBuffer, offset, length);
        HeaderDecoder header = testRequest.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || testRequest.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)testRequest, header, false);
        }
        int msgSeqNo = header.msgSeqNum();
        long origSendingTime = this.origSendingTime(header);
        long sendingTime = this.sendingTime(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onTestRequest(msgSeqNo, testRequest.testReqID(), testRequest.testReqIDLength(), sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup);
    }

    private ControlledFragmentHandler.Action onReject(int offset, int length) {
        RejectDecoder reject = this.reject;
        reject.reset();
        reject.decode(this.asciiBuffer, offset, length);
        HeaderDecoder header = reject.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || reject.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)reject, header, false);
        }
        long origSendingTime = this.origSendingTime(header);
        long sendingTime = this.sendingTime(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onReject(header.msgSeqNum(), sendingTime, origSendingTime, this.isPossDupOrResend(possDup, header), possDup);
    }

    private ControlledFragmentHandler.Action onLogout(int offset, int length) {
        LogoutDecoder logout = this.logout;
        logout.reset();
        logout.decode(this.asciiBuffer, offset, length);
        HeaderDecoder header = logout.header();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || logout.validate() && this.validateHeader(header))) {
            return this.onCodecInvalidMessage((Decoder)logout, header, false);
        }
        long origSendingTime = this.origSendingTime(header);
        long sendingTime = this.sendingTime(header);
        boolean possDup = this.isPossDup(header);
        return this.session.onLogout(header.msgSeqNum(), sendingTime, origSendingTime, possDup);
    }

    private ControlledFragmentHandler.Action onLogon(int offset, int length) {
        LogonDecoder logon = this.logon;
        Session session = this.session;
        logon.reset();
        logon.decode(this.asciiBuffer, offset, length);
        HeaderDecoder header = logon.header();
        char[] beginString = header.beginString();
        int beginStringLength = header.beginStringLength();
        if (!(!Validation.CODEC_VALIDATION_ENABLED || logon.validate() && session.onBeginString(beginString, beginStringLength, true))) {
            return this.onCodecInvalidMessage((Decoder)logon, header, true);
        }
        long origSendingTime = this.origSendingTime(header);
        String username = SessionParser.username(logon);
        String password = SessionParser.password(logon);
        boolean possDup = this.isPossDup(header);
        return session.onLogon(logon.heartBtInt(), header.msgSeqNum(), this.sendingTime(header), origSendingTime, username, password, this.isPossDupOrResend(possDup, header), this.resetSeqNumFlag(logon), possDup);
    }

    private void onStrategyError(String strategyName, Throwable throwable, String fixMessage) {
        String message = String.format("Exception thrown by %s strategy for connectionId=%d, [%s], defaulted to false", strategyName, this.session.connectionId(), fixMessage);
        this.onError(new FixGatewayException(message, throwable));
    }

    private void onError(Throwable throwable) {
        if (this.errorHandler == null) {
            LangUtil.rethrowUnchecked((Throwable)throwable);
        } else {
            this.errorHandler.onError(throwable);
        }
    }

    private boolean resetSeqNumFlag(LogonDecoder logon) {
        return logon.hasResetSeqNumFlag() && logon.resetSeqNumFlag();
    }

    private boolean validateHeader(HeaderDecoder header) {
        boolean validated;
        if (!this.session.onBeginString(header.beginString(), header.beginStringLength(), false)) {
            return false;
        }
        try {
            validated = this.validationStrategy.validate(header);
        }
        catch (Throwable throwable) {
            this.onStrategyError("validation", throwable, header.toString());
            validated = false;
        }
        if (!validated) {
            this.session.onInvalidMessage(header.msgSeqNum(), this.validationStrategy.invalidTagId(), header.msgType(), header.msgTypeLength(), this.validationStrategy.rejectReason());
            this.session.logoutRejectReason(this.validationStrategy.rejectReason());
            this.session.startLogout();
            return false;
        }
        return true;
    }

    private ControlledFragmentHandler.Action onCodecInvalidMessage(Decoder decoder, HeaderDecoder header, boolean requestDisconnect) {
        if (!this.isDisconnectedOrAwaitingLogout()) {
            int msgTypeLength = header.msgTypeLength();
            if (header.msgSeqNum() == Integer.MIN_VALUE) {
                long origSendingTime = this.origSendingTime(header);
                long sendingTime = this.sendingTime(header);
                char[] msgType = header.msgType();
                return this.session.onMessage(Integer.MIN_VALUE, msgType, msgTypeLength, sendingTime, origSendingTime, false, false);
            }
            ControlledFragmentHandler.Action action = this.session.onInvalidMessage(header.msgSeqNum(), decoder.invalidTagId(), header.msgType(), msgTypeLength, decoder.rejectReason());
            if (action == ControlledFragmentHandler.Action.CONTINUE && requestDisconnect) {
                return this.session.onInvalidFixDisconnect();
            }
            return action;
        }
        if (requestDisconnect) {
            return this.session.onInvalidFixDisconnect();
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private boolean isDisconnectedOrAwaitingLogout() {
        SessionState state = this.session.state();
        return state == SessionState.DISCONNECTED || state == SessionState.AWAITING_LOGOUT;
    }

    private boolean isPossDupOrResend(boolean possDup, HeaderDecoder header) {
        return possDup || header.hasPossResend() && header.possResend();
    }

    private boolean isPossDup(HeaderDecoder header) {
        return header.hasPossDupFlag() && header.possDupFlag();
    }

    public Session session() {
        return this.session;
    }

    public void sequenceIndex(int sequenceIndex) {
        this.session.sequenceIndex(sequenceIndex);
    }
}

