/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.Subscription;
import io.aeron.driver.media.UdpChannel;

public final class StreamIdentifier {
    private final int streamId;
    private final String channel;
    private final String canonicalForm;

    public StreamIdentifier(Subscription subscription) {
        this(subscription.channel(), subscription.streamId());
    }

    public StreamIdentifier(String channel, int streamId) {
        this.streamId = streamId;
        this.channel = channel;
        this.canonicalForm = "aeron:ipc".equals(channel) ? "aeron_ipc" : UdpChannel.parse((String)channel).canonicalForm().replace(':', '_');
    }

    public int streamId() {
        return this.streamId;
    }

    public String channel() {
        return this.channel;
    }

    public String canonicalForm() {
        return this.canonicalForm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamIdentifier that = (StreamIdentifier)o;
        return this.streamId == that.streamId && this.channel.equals(that.channel);
    }

    public int hashCode() {
        return 31 * this.streamId + this.channel.hashCode();
    }

    public String toString() {
        return "StreamIdentifier{streamId=" + this.streamId + ", channel='" + this.channel + '\'' + '}';
    }
}

