/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.Aeron;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.DynamicCompositeAgent;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryScheduler;

public class DynamicLibraryScheduler
implements LibraryScheduler {
    private final DynamicCompositeAgent dynamicAgent = new DynamicCompositeAgent("Monitoring+ClientConductor");
    private final Int2ObjectHashMap<Agent> libraryIdToDelegateAgent = new Int2ObjectHashMap();
    private AgentRunner runner;

    @Override
    public synchronized void launch(LibraryConfiguration configuration, ErrorHandler errorHandler, Agent monitoringAgent, Agent conductorAgent) {
        if (this.runner == null) {
            this.runner = new AgentRunner(configuration.monitoringThreadIdleStrategy(), Throwable::printStackTrace, null, (Agent)this.dynamicAgent);
            AgentRunner.startOnThread((AgentRunner)this.runner);
            while (this.dynamicAgent.status() != DynamicCompositeAgent.Status.ACTIVE) {
                Thread.yield();
            }
        }
        int libraryId = configuration.libraryId();
        CombinedAgent combinedAgent = new CombinedAgent(libraryId, monitoringAgent, conductorAgent, errorHandler);
        this.libraryIdToDelegateAgent.put(libraryId, (Object)combinedAgent);
        while (!this.dynamicAgent.tryAdd((Agent)combinedAgent)) {
            Thread.yield();
        }
        while (!this.dynamicAgent.hasAddAgentCompleted()) {
            Thread.yield();
        }
    }

    @Override
    public synchronized void close(int libraryId) {
        Agent agentToRemove = (Agent)this.libraryIdToDelegateAgent.remove(libraryId);
        if (agentToRemove != null) {
            while (!this.dynamicAgent.tryRemove(agentToRemove)) {
                Thread.yield();
            }
            while (!this.dynamicAgent.hasRemoveAgentCompleted()) {
                Thread.yield();
            }
            if (this.libraryIdToDelegateAgent.isEmpty()) {
                CloseHelper.close((AutoCloseable)this.runner);
                this.runner = null;
            }
        }
    }

    @Override
    public void configure(Aeron.Context aeronContext) {
        aeronContext.useConductorAgentInvoker(true);
    }

    private static final class CombinedAgent
    implements Agent {
        private final Agent monitoringAgent;
        private final Agent clientConductorAgent;
        private final ErrorHandler errorHandler;
        private final String roleName;

        private CombinedAgent(int libraryId, Agent monitoringAgent, Agent clientConductorAgent, ErrorHandler errorHandler) {
            this.roleName = "[Library:" + libraryId + ":monitoring+conductor]";
            this.monitoringAgent = monitoringAgent;
            this.clientConductorAgent = clientConductorAgent;
            this.errorHandler = errorHandler;
        }

        public int doWork() throws Exception {
            int count = 0;
            try {
                count += this.monitoringAgent.doWork();
                count += this.clientConductorAgent.doWork();
            }
            catch (Throwable throwable) {
                this.errorHandler.onError(throwable);
            }
            return count;
        }

        public String roleName() {
            return this.roleName;
        }
    }
}

