/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.status.RecordingPos;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.List;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.CountersReader;
import uk.co.real_logic.artio.engine.logger.RecordingRange;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;

public class ReplayOperation {
    private final MessageTracker messageTracker = new MessageTracker();
    private final ControlledFragmentAssembler assembler = new ControlledFragmentAssembler((ControlledFragmentHandler)this.messageTracker);
    private final List<RecordingRange> ranges;
    private final AeronArchive aeronArchive;
    private final ErrorHandler errorHandler;
    private final int archiveReplayStream;
    private final CountersReader countersReader;
    private final Subscription subscription;
    private int replayedMessages = 0;
    private RecordingRange recordingRange;
    private int aeronSessionId;
    private Image image;
    private int fragmentsToPoll = Integer.MAX_VALUE;

    ReplayOperation(ControlledFragmentHandler handler, List<RecordingRange> ranges, AeronArchive aeronArchive, ErrorHandler errorHandler, Subscription subscription, int archiveReplayStream) {
        this.ranges = ranges;
        this.aeronArchive = aeronArchive;
        this.errorHandler = errorHandler;
        this.archiveReplayStream = archiveReplayStream;
        Aeron aeron = aeronArchive.context().aeron();
        this.countersReader = aeron.countersReader();
        this.messageTracker.wrap(handler);
        this.subscription = subscription;
    }

    public boolean attemptReplay() {
        return this.attemptReplayStep();
    }

    private boolean attemptReplayStep() {
        if (this.recordingRange == null) {
            if (this.ranges.isEmpty()) {
                return true;
            }
            this.recordingRange = this.ranges.get(0);
            this.messageTracker.msgPredicate = this.recordingRange.msgPredicate;
            long beginPosition = this.recordingRange.position;
            long length = this.recordingRange.length;
            long endPosition = beginPosition + length;
            long recordingId = this.recordingRange.recordingId;
            if (this.archivingNotComplete(endPosition, recordingId)) {
                this.recordingRange = null;
                return false;
            }
            this.ranges.remove(0);
            try {
                this.aeronSessionId = (int)this.aeronArchive.startReplay(recordingId, beginPosition, length, "aeron:ipc", this.archiveReplayStream);
                this.messageTracker.reset();
                if (this.image != null && this.aeronSessionId != this.image.sessionId()) {
                    this.image = null;
                }
            }
            catch (Throwable exception) {
                this.errorHandler.onError(exception);
                return true;
            }
        }
        if (this.image == null) {
            this.image = this.subscription.imageBySessionId(this.aeronSessionId);
            return false;
        }
        this.image.controlledPoll((ControlledFragmentHandler)this.assembler, this.fragmentsToPoll);
        if (this.messageTracker.count < this.recordingRange.count) {
            return false;
        }
        this.replayedMessages += this.recordingRange.count;
        this.recordingRange = null;
        return this.ranges.isEmpty();
    }

    int replayedMessages() {
        return this.replayedMessages;
    }

    private boolean archivingNotComplete(long endPosition, long recordingId) {
        int counterId = RecordingPos.findCounterIdByRecording((CountersReader)this.countersReader, (long)recordingId);
        if (counterId != -1) {
            return this.countersReader.getCounterValue(counterId) < endPosition;
        }
        return false;
    }

    public void setFragmentsToPoll(int fragmentsToPoll) {
        this.fragmentsToPoll = fragmentsToPoll;
    }

    private static class MessageTracker
    implements ControlledFragmentHandler {
        private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
        private final FixMessageDecoder messageDecoder = new FixMessageDecoder();
        ControlledFragmentHandler messageHandler;
        int count;
        Predicate<FixMessageDecoder> msgPredicate;

        private MessageTracker() {
        }

        public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
            this.messageHeaderDecoder.wrap(buffer, offset);
            if (this.messageHeaderDecoder.templateId() == 1) {
                ControlledFragmentHandler.Action action;
                if (this.msgPredicate != null) {
                    this.messageDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                    if (!this.msgPredicate.test(this.messageDecoder)) {
                        return ControlledFragmentHandler.Action.CONTINUE;
                    }
                }
                if ((action = this.messageHandler.onFragment(buffer, offset, length, header)) != ControlledFragmentHandler.Action.ABORT) {
                    ++this.count;
                }
                return action;
            }
            return ControlledFragmentHandler.Action.CONTINUE;
        }

        void wrap(ControlledFragmentHandler handler) {
            this.messageHandler = handler;
        }

        void reset() {
            this.count = 0;
        }
    }
}

