/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;

public final class ReplayIndexDescriptor {
    static final int REPLAY_POSITION_BUFFER_SIZE = 131072;
    private static final int BEGIN_CHANGE_OFFSET = 8;
    private static final int END_CHANGE_OFFSET = 16;
    public static final int INITIAL_RECORD_OFFSET = 24;
    static final int RECORD_LENGTH = 32;

    static File replayIndexFile(String logFileDir, long fixSessionId, int streamId) {
        return new File(String.format(logFileDir + File.separator + "replay-index-%d-%d", fixSessionId, streamId));
    }

    public static UnsafeBuffer replayPositionBuffer(String logFileDir, int streamId) {
        String pathname = ReplayIndexDescriptor.replayPositionPath(logFileDir, streamId);
        return new UnsafeBuffer(LoggerUtil.map(new File(pathname), 131072));
    }

    static String replayPositionPath(String logFileDir, int streamId) {
        return logFileDir + File.separator + "replay-positions-" + streamId;
    }

    static void endChangeOrdered(AtomicBuffer buffer, long changePosition) {
        buffer.putLongOrdered(16, changePosition);
    }

    static long endChangeVolatile(AtomicBuffer buffer) {
        return buffer.getLongVolatile(16);
    }

    static void beginChangeOrdered(AtomicBuffer buffer, long changePosition) {
        buffer.putLongOrdered(8, changePosition);
    }

    static long beginChangeVolatile(AtomicBuffer buffer) {
        return buffer.getLongVolatile(8);
    }

    static long beginChange(AtomicBuffer buffer) {
        return buffer.getLong(8);
    }

    static int recordCapacity(int indexFileSize) {
        return indexFileSize - 24;
    }

    static int offset(long changePosition, int capacity) {
        return 24 + ((int)changePosition & capacity - 1);
    }

    static void checkIndexFileSize(int indexFileSize) {
        int recordCapacity = ReplayIndexDescriptor.recordCapacity(indexFileSize);
        if (!BitUtil.isPowerOfTwo((int)recordCapacity)) {
            throw new IllegalStateException("IndexFileSize must be a positive power of 2 + INITIAL_RECORD_OFFSET: indexFileSize=" + indexFileSize);
        }
        if (recordCapacity % 32 != 0) {
            throw new IllegalStateException("IndexFileSize must be a multiple of RECORD_LENGTH + INITIAL_RECORD_OFFSET: indexFileSize=" + indexFileSize);
        }
    }
}

