/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.decoder.LogonDecoder;
import uk.co.real_logic.artio.dictionary.StandardFixConstants;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.framer.AuthenticationResult;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class ReceiverEndPoint {
    private static final char INVALID_MESSAGE_TYPE = '-';
    private static final byte BODY_LENGTH_FIELD = 9;
    private static final byte BEGIN_STRING_FIELD = 8;
    private static final byte CHECKSUM0 = 1;
    private static final byte CHECKSUM1 = 49;
    private static final byte CHECKSUM2 = 48;
    private static final byte CHECKSUM3 = 61;
    private static final int MIN_CHECKSUM_SIZE = " 10=".length() + 1;
    private static final int CHECKSUM_TAG_SIZE = "10=".length();
    private static final int SOCKET_DISCONNECTED = -1;
    private static final int UNKNOWN_MESSAGE_TYPE = -1;
    private static final int BREAK = -1;
    private final LogonDecoder logon = new LogonDecoder();
    private final TcpChannel channel;
    private final GatewayPublication publication;
    private final long connectionId;
    private final SessionContexts sessionContexts;
    private final AtomicCounter messagesRead;
    private final Framer framer;
    private final ErrorHandler errorHandler;
    private final MutableAsciiBuffer buffer;
    private final ByteBuffer byteBuffer;
    private final GatewaySessions gatewaySessions;
    private int libraryId;
    private GatewaySession gatewaySession;
    private long sessionId;
    private int sequenceIndex;
    private int usedBufferData = 0;
    private boolean hasDisconnected = false;
    private SelectionKey selectionKey;
    private boolean isPaused = false;
    private AuthenticationResult backpressuredAuthenticationResult;
    private int backpressuredAuthenticationOffset;
    private int backpressuredAuthenticationLength;

    ReceiverEndPoint(TcpChannel channel, int bufferSize, GatewayPublication publication, long connectionId, long sessionId, int sequenceIndex, SessionContexts sessionContexts, AtomicCounter messagesRead, Framer framer, ErrorHandler errorHandler, int libraryId, GatewaySessions gatewaySessions) {
        Objects.requireNonNull(publication, "publication");
        Objects.requireNonNull(sessionContexts, "sessionContexts");
        Objects.requireNonNull(gatewaySessions, "gatewaySessions");
        this.channel = channel;
        this.publication = publication;
        this.connectionId = connectionId;
        this.sessionId = sessionId;
        this.sequenceIndex = sequenceIndex;
        this.sessionContexts = sessionContexts;
        this.messagesRead = messagesRead;
        this.framer = framer;
        this.errorHandler = errorHandler;
        this.libraryId = libraryId;
        this.gatewaySessions = gatewaySessions;
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSize);
        this.buffer = new MutableAsciiBuffer(this.byteBuffer);
    }

    public long connectionId() {
        return this.connectionId;
    }

    int poll() {
        if (this.isPaused || this.hasDisconnected()) {
            return 0;
        }
        if (this.backpressuredAuthenticationResult != null) {
            return this.retryBackpressuredAuthenticationResult();
        }
        try {
            return this.readData() + this.frameMessages();
        }
        catch (ClosedChannelException ex) {
            this.onDisconnectDetected();
            return 1;
        }
        catch (Exception ex) {
            if (!Exceptions.isJustDisconnect((Exception)ex)) {
                this.errorHandler.onError((Throwable)ex);
            }
            this.onDisconnectDetected();
            return 1;
        }
    }

    private int retryBackpressuredAuthenticationResult() {
        if (this.gatewaySessions.lookupSequenceNumbers(this.gatewaySession, this.backpressuredAuthenticationResult.requiredPosition())) {
            this.backpressuredAuthenticationResult = null;
            int offset = this.backpressuredAuthenticationOffset;
            int length = this.backpressuredAuthenticationLength;
            if (!this.saveMessage(offset, 65, length)) {
                return offset;
            }
            this.moveRemainingDataToBufferStart(offset += length);
            return offset;
        }
        return 1;
    }

    private int readData() throws IOException {
        int dataRead = this.channel.read(this.byteBuffer);
        if (dataRead != -1) {
            if (dataRead > 0) {
                DebugLogger.log(LogTag.FIX_MESSAGE, "Read     %s%n", (DirectBuffer)this.buffer, 0, dataRead);
            }
            this.usedBufferData += dataRead;
        } else {
            this.onDisconnectDetected();
        }
        return dataRead;
    }

    private int frameMessages() {
        int offset = 0;
        while (this.usedBufferData >= offset + StandardFixConstants.MIN_MESSAGE_SIZE) {
            try {
                int startOfChecksumTag;
                int endOfChecksumTag;
                int startOfBodyLength = this.scanForBodyLength(offset);
                if (startOfBodyLength == -1) {
                    return offset;
                }
                int endOfBodyLength = this.scanEndOfBodyLength(startOfBodyLength);
                if (endOfBodyLength == -1 || (endOfChecksumTag = (startOfChecksumTag = endOfBodyLength + this.getBodyLength(startOfBodyLength, endOfBodyLength)) + MIN_CHECKSUM_SIZE) >= this.usedBufferData) break;
                if (!this.validateBodyLength(startOfChecksumTag)) {
                    int endOfMessage = this.onInvalidBodyLength(offset, startOfChecksumTag);
                    if (endOfMessage == -1) break;
                    return endOfMessage;
                }
                int startOfChecksumValue = startOfChecksumTag + MIN_CHECKSUM_SIZE;
                int endOfMessage = this.scanEndOfMessage(startOfChecksumValue);
                if (endOfMessage == -1) break;
                int messageType = this.getMessageType(endOfBodyLength, endOfMessage);
                int length = endOfMessage + 1 - offset;
                if (!this.validateChecksum(endOfMessage, startOfChecksumValue, offset, startOfChecksumTag)) {
                    if (this.saveInvalidChecksumMessage(offset, messageType, length)) {
                        return offset;
                    }
                } else {
                    if (this.requiresAuthentication() && !this.authenticate(offset, length)) {
                        return offset;
                    }
                    this.messagesRead.incrementOrdered();
                    if (!this.saveMessage(offset, messageType, length)) {
                        return offset;
                    }
                }
                offset += length;
            }
            catch (IllegalArgumentException ex) {
                this.saveInvalidMessage(offset);
                return offset;
            }
            catch (Exception ex) {
                this.errorHandler.onError((Throwable)ex);
                break;
            }
        }
        this.moveRemainingDataToBufferStart(offset);
        return offset;
    }

    private int onInvalidBodyLength(int offset, int startOfChecksumTag) {
        int endOfScanPoint;
        int checksumTagScanPoint = startOfChecksumTag + 1;
        while (!this.isStartOfChecksum(checksumTagScanPoint)) {
            endOfScanPoint = checksumTagScanPoint + CHECKSUM_TAG_SIZE;
            if (endOfScanPoint >= this.usedBufferData) {
                return -1;
            }
            ++checksumTagScanPoint;
        }
        endOfScanPoint = checksumTagScanPoint + CHECKSUM_TAG_SIZE;
        int endOfMessage = this.buffer.scan(endOfScanPoint, this.usedBufferData, (byte)1) + 1;
        if (endOfMessage > this.usedBufferData) {
            return -1;
        }
        if (this.saveInvalidMessage(offset, endOfMessage)) {
            return offset;
        }
        this.moveRemainingDataToBufferStart(endOfMessage);
        return offset;
    }

    private boolean requiresAuthentication() {
        return -1L == this.sessionId;
    }

    private boolean validateChecksum(int endOfMessage, int startOfChecksumValue, int offset, int startOfChecksumTag) {
        int computedChecksum;
        int expectedChecksum = this.buffer.getInt(startOfChecksumValue - 1, endOfMessage);
        return expectedChecksum == (computedChecksum = this.buffer.computeChecksum(offset, startOfChecksumTag + 1));
    }

    private int scanEndOfMessage(int startOfChecksumValue) {
        return this.buffer.scan(startOfChecksumValue, this.usedBufferData - 1, (byte)1);
    }

    private int scanForBodyLength(int offset) {
        if (this.invalidTag(offset, (byte)8)) {
            this.invalidateMessage(offset);
            return -1;
        }
        int endOfCommonPrefix = this.scanNextField(offset + 2);
        if (endOfCommonPrefix == -1) {
            this.invalidateMessage(offset);
            return -1;
        }
        int startOfBodyTag = endOfCommonPrefix + 1;
        if (this.invalidTag(startOfBodyTag, (byte)9)) {
            this.invalidateMessage(offset);
            return -1;
        }
        return startOfBodyTag + 2;
    }

    private int scanEndOfBodyLength(int startOfBodyLength) {
        return this.buffer.scan(startOfBodyLength + 1, this.usedBufferData - 1, (byte)1);
    }

    private int scanNextField(int startScan) {
        return this.buffer.scan(startScan + 1, this.usedBufferData - 1, (byte)1);
    }

    private boolean authenticate(int offset, int length) {
        if (this.sessionId != -1L) {
            return false;
        }
        this.logon.decode((AsciiBuffer)this.buffer, offset, length);
        AuthenticationResult authenticationResult = this.gatewaySessions.authenticate(this.logon, this.connectionId(), this.gatewaySession);
        if (!authenticationResult.isValid()) {
            this.completeDisconnect(authenticationResult.reason());
            return false;
        }
        this.sessionId = this.gatewaySession.sessionId();
        this.sequenceIndex = this.gatewaySession.sequenceIndex();
        if (authenticationResult.isBackPressured()) {
            this.backpressuredAuthenticationResult = authenticationResult;
            this.backpressuredAuthenticationOffset = offset;
            this.backpressuredAuthenticationLength = length;
            return false;
        }
        return true;
    }

    private boolean stashIfBackPressured(int offset, long position) {
        boolean backPressured = Pressure.isBackPressured(position);
        if (backPressured) {
            this.moveRemainingDataToBufferStart(offset);
        }
        return backPressured;
    }

    private boolean saveMessage(int offset, int messageType, int length) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, length, this.libraryId, messageType, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.OK, 0);
        if (Pressure.isBackPressured(position)) {
            this.moveRemainingDataToBufferStart(offset);
            return false;
        }
        this.gatewaySession.onMessage(this.buffer, offset, length, messageType, this.sessionId);
        return true;
    }

    private boolean validateBodyLength(int startOfChecksumTag) {
        return this.isStartOfChecksum(startOfChecksumTag);
    }

    private boolean isStartOfChecksum(int startOfChecksumTag) {
        return this.buffer.getByte(startOfChecksumTag) == 1 && this.buffer.getByte(startOfChecksumTag + 1) == 49 && this.buffer.getByte(startOfChecksumTag + 2) == 48 && this.buffer.getByte(startOfChecksumTag + 3) == 61;
    }

    private int getMessageType(int endOfBodyLength, int indexOfLastByteOfMessage) {
        int start = this.buffer.scan(endOfBodyLength, indexOfLastByteOfMessage, '=');
        if (this.buffer.getByte(start + 2) == 1) {
            return this.buffer.getByte(start + 1);
        }
        return this.buffer.getMessageType(start + 1, 2);
    }

    private int getBodyLength(int startOfBodyLength, int endOfBodyLength) {
        return this.buffer.getNatural(startOfBodyLength, endOfBodyLength);
    }

    private boolean invalidTag(int startOfBodyTag, byte tagId) {
        try {
            return this.buffer.getDigit(startOfBodyTag) != tagId || this.buffer.getChar(startOfBodyTag + 1) != '=';
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private void moveRemainingDataToBufferStart(int offset) {
        this.usedBufferData -= offset;
        this.buffer.putBytes(0, (DirectBuffer)this.buffer, offset, this.usedBufferData);
        ByteBufferUtil.position(this.byteBuffer, this.usedBufferData);
    }

    private void invalidateMessage(int offset) {
        DebugLogger.log(LogTag.FIX_MESSAGE, "%s", (DirectBuffer)this.buffer, offset, StandardFixConstants.MIN_MESSAGE_SIZE);
        this.saveInvalidMessage(offset);
    }

    private boolean saveInvalidMessage(int offset, int startOfChecksumTag) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, startOfChecksumTag, this.libraryId, -1, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID_BODYLENGTH, 0);
        return this.stashIfBackPressured(offset, position);
    }

    private void saveInvalidMessage(int offset) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, this.usedBufferData, this.libraryId, 45, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID, 0);
        boolean backPressured = this.stashIfBackPressured(offset, position);
        if (!backPressured) {
            this.clearBuffer();
        }
    }

    private void clearBuffer() {
        this.moveRemainingDataToBufferStart(this.usedBufferData);
    }

    private boolean saveInvalidChecksumMessage(int offset, int messageType, int length) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, length, this.libraryId, messageType, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID_CHECKSUM, 0);
        return this.stashIfBackPressured(offset, position);
    }

    public void close(DisconnectReason reason) {
        this.closeResources();
        if (!this.hasDisconnected) {
            this.disconnectEndpoint(reason);
        }
    }

    private void closeResources() {
        try {
            this.channel.close();
            this.messagesRead.close();
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
    }

    private void removeEndpointFromFramer() {
        this.framer.onDisconnect(this.libraryId, this.connectionId, null);
    }

    private void onDisconnectDetected() {
        this.completeDisconnect(DisconnectReason.REMOTE_DISCONNECT);
    }

    void onNoLogonDisconnect() {
        this.completeDisconnect(DisconnectReason.NO_LOGON);
    }

    private void completeDisconnect(DisconnectReason reason) {
        this.disconnectEndpoint(reason);
        this.removeEndpointFromFramer();
    }

    private void disconnectEndpoint(DisconnectReason reason) {
        this.framer.schedule(() -> this.publication.saveDisconnect(this.libraryId, this.connectionId, reason));
        this.sessionContexts.onDisconnect(this.sessionId);
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        this.hasDisconnected = true;
    }

    boolean hasDisconnected() {
        return this.hasDisconnected;
    }

    public void register(Selector selector) throws IOException {
        this.selectionKey = this.channel.register(selector, 1, this);
    }

    public int libraryId() {
        return this.libraryId;
    }

    public void libraryId(int libraryId) {
        this.libraryId = libraryId;
    }

    void gatewaySession(GatewaySession gatewaySession) {
        this.gatewaySession = gatewaySession;
    }

    void pause() {
        this.isPaused = true;
    }

    void play() {
        this.isPaused = false;
    }
}

