/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.library.InitiateSessionReply;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.session.SessionParser;
import uk.co.real_logic.artio.timing.Timer;

class SessionSubscriber
implements AutoCloseable {
    private final SessionParser parser;
    private final InternalSession session;
    private final Timer receiveTimer;
    private final Timer sessionTimer;
    private SessionHandler handler;
    private InitiateSessionReply initiateSessionReply;

    SessionSubscriber(SessionParser parser, InternalSession session, Timer receiveTimer, Timer sessionTimer) {
        this.parser = parser;
        this.session = session;
        this.receiveTimer = receiveTimer;
        this.sessionTimer = sessionTimer;
        this.session.logonListener(this::onSessionLogon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, long sessionId, int sequenceIndex, int messageType, long timestamp, MessageStatus status, long position) {
        long now = this.receiveTimer.recordSince(timestamp);
        try {
            switch (status) {
                case OK: {
                    ControlledFragmentHandler.Action action = this.parser.onMessage(buffer, offset, length, messageType, sessionId);
                    if (action == ControlledFragmentHandler.Action.BREAK) {
                        ControlledFragmentHandler.Action action2 = ControlledFragmentHandler.Action.BREAK;
                        return action2;
                    }
                    ControlledFragmentHandler.Action handlerAction = this.handler.onMessage(buffer, offset, length, libraryId, this.session, sequenceIndex, messageType, timestamp, position);
                    if (handlerAction == ControlledFragmentHandler.Action.CONTINUE || handlerAction == ControlledFragmentHandler.Action.COMMIT) {
                        this.session.updateLastMessageProcessed();
                    }
                    ControlledFragmentHandler.Action action3 = handlerAction;
                    return action3;
                }
                case CATCHUP_REPLAY: {
                    ControlledFragmentHandler.Action action = this.handler.onMessage(buffer, offset, length, libraryId, this.session, sequenceIndex, messageType, timestamp, position);
                    return action;
                }
            }
            ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
            return action;
        }
        finally {
            this.sessionTimer.recordSince(now);
        }
    }

    ControlledFragmentHandler.Action onDisconnect(int libraryId, DisconnectReason reason) {
        ControlledFragmentHandler.Action action = this.handler.onDisconnect(libraryId, this.session, reason);
        if (action != ControlledFragmentHandler.Action.ABORT) {
            this.session.onDisconnect();
            if (this.initiateSessionReply != null) {
                this.initiateSessionReply.onError(GatewayError.UNABLE_TO_LOGON, "Disconnected before session active");
                this.initiateSessionReply = null;
            }
        }
        return action;
    }

    private void onSessionLogon(Session session) {
        if (session.hasLogonTime()) {
            this.handler.onSessionStart(session);
        }
        if (this.initiateSessionReply != null) {
            this.initiateSessionReply.onComplete(session);
            this.initiateSessionReply = null;
        }
    }

    void onTimeout(int libraryId) {
        this.handler.onTimeout(libraryId, this.session);
    }

    void onSlowStatusNotification(int libraryId, boolean hasBecomeSlow) {
        this.handler.onSlowStatus(libraryId, this.session, hasBecomeSlow);
    }

    @Override
    public void close() {
        this.session.requestDisconnect();
    }

    InternalSession session() {
        return this.session;
    }

    void handler(SessionHandler handler) {
        this.handler = handler;
    }

    void reply(InitiateSessionReply reply) {
        this.initiateSessionReply = reply;
    }
}

