/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.framer.TcpChannel;

public class TcpChannelSupplier
implements AutoCloseable {
    private final EngineConfiguration configuration;
    private final boolean hasBindAddress;
    private final Set<SocketChannel> openingSocketChannels = new HashSet<SocketChannel>();
    private Selector selector;
    private ServerSocketChannel listeningChannel;

    public TcpChannelSupplier(EngineConfiguration configuration) {
        this.hasBindAddress = configuration.hasBindAddress();
        this.configuration = configuration;
        try {
            this.selector = Selector.open();
            if (this.hasBindAddress) {
                this.listeningChannel = ServerSocketChannel.open();
                this.listeningChannel.bind(configuration.bindAddress()).configureBlocking(false);
                this.listeningChannel.register(this.selector, 16);
            } else {
                this.listeningChannel = null;
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    public int pollSelector(long timeInMs, NewChannelHandler handler) throws IOException {
        if (this.hasBindAddress || this.openingSocketChannels.size() > 0) {
            this.selector.selectNow();
            Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
            int unprocessedConnections = selectionKeys.size();
            if (unprocessedConnections > 0) {
                Iterator<SelectionKey> it = selectionKeys.iterator();
                while (it.hasNext()) {
                    SelectionKey selectionKey = it.next();
                    if (selectionKey.isAcceptable()) {
                        SocketChannel channel = this.listeningChannel.accept();
                        if (channel != null) {
                            this.configure(channel);
                            channel.configureBlocking(false);
                            handler.onNewChannel(timeInMs, this.newTcpChannel(channel));
                        }
                        it.remove();
                        continue;
                    }
                    if (!selectionKey.isConnectable()) continue;
                    InitiatedChannelHandler channelHandler = (InitiatedChannelHandler)selectionKey.attachment();
                    SocketChannel channel = (SocketChannel)selectionKey.channel();
                    try {
                        if (!channel.finishConnect()) continue;
                        channelHandler.onInitiatedChannel(this.newTcpChannel(channel), null);
                        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFF7);
                        it.remove();
                        this.openingSocketChannels.remove(channel);
                    }
                    catch (IOException e) {
                        channelHandler.onInitiatedChannel(null, e);
                        it.remove();
                        this.openingSocketChannels.remove(channel);
                    }
                }
            }
            return unprocessedConnections;
        }
        return 0;
    }

    private void configure(SocketChannel channel) throws IOException {
        channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        if (this.configuration.receiverSocketBufferSize() > 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.configuration.receiverSocketBufferSize());
        }
        if (this.configuration.senderSocketBufferSize() > 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.configuration.senderSocketBufferSize());
        }
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.listeningChannel);
        CloseHelper.close((AutoCloseable)this.selector);
    }

    public void open(InetSocketAddress address, InitiatedChannelHandler channelHandler) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(false);
        channel.register(this.selector, 8, channelHandler);
        this.configure(channel);
        channel.connect(address);
        this.openingSocketChannels.add(channel);
    }

    protected TcpChannel newTcpChannel(SocketChannel channel) throws IOException {
        return new TcpChannel(channel);
    }

    protected void stopConnecting(InetSocketAddress address) throws IOException {
        Iterator<SocketChannel> iterator = this.openingSocketChannels.iterator();
        while (iterator.hasNext()) {
            SocketChannel channel = iterator.next();
            if (!channel.getRemoteAddress().equals(address)) continue;
            iterator.remove();
            break;
        }
    }

    @FunctionalInterface
    public static interface NewChannelHandler {
        public void onNewChannel(long var1, TcpChannel var3) throws IOException;
    }

    @FunctionalInterface
    public static interface InitiatedChannelHandler {
        public void onInitiatedChannel(TcpChannel var1, IOException var2);
    }
}

