/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.Aeron;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.EngineScheduler;
import uk.co.real_logic.artio.engine.RecordingCoordinator;

public class DefaultEngineScheduler
implements EngineScheduler {
    private AgentRunner framerRunner;
    private AgentRunner archivingRunner;
    private AgentRunner monitoringRunner;
    private RecordingCoordinator recordingCoordinator;

    @Override
    public void launch(EngineConfiguration configuration, ErrorHandler errorHandler, Agent framer, Agent indexingAgent, Agent monitoringAgent, Agent conductorAgent, RecordingCoordinator recordingCoordinator) {
        this.recordingCoordinator = recordingCoordinator;
        if (this.framerRunner != null) {
            EngineScheduler.fail();
        }
        this.framerRunner = new AgentRunner(configuration.framerIdleStrategy(), errorHandler, null, framer);
        this.archivingRunner = new AgentRunner(configuration.archiverIdleStrategy(), errorHandler, null, indexingAgent);
        AgentRunner.startOnThread((AgentRunner)this.framerRunner);
        AgentRunner.startOnThread((AgentRunner)this.archivingRunner);
        if (monitoringAgent != null) {
            this.monitoringRunner = new AgentRunner(CommonConfiguration.backoffIdleStrategy(), errorHandler, null, monitoringAgent);
            AgentRunner.startOnThread((AgentRunner)this.monitoringRunner);
        }
    }

    @Override
    public void close() {
        EngineScheduler.awaitRunnerStart(this.framerRunner);
        EngineScheduler.awaitRunnerStart(this.archivingRunner);
        EngineScheduler.awaitRunnerStart(this.monitoringRunner);
        Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.framerRunner, this.archivingRunner, this.recordingCoordinator, this.monitoringRunner});
    }

    @Override
    public void configure(Aeron.Context aeronContext) {
    }
}

