/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.EpochClock;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.HeartbeatEncoder;
import uk.co.real_logic.artio.builder.LogonEncoder;
import uk.co.real_logic.artio.builder.LogoutEncoder;
import uk.co.real_logic.artio.builder.RejectEncoder;
import uk.co.real_logic.artio.builder.ResendRequestEncoder;
import uk.co.real_logic.artio.builder.SequenceResetEncoder;
import uk.co.real_logic.artio.builder.TestRequestEncoder;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.util.AsciiFormatter;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class SessionProxy {
    public static final int NO_LAST_MSG_SEQ_NUM_PROCESSED = -1;
    private static final byte[] INCORRECT_BEGIN_STRING = "Incorrect BeginString".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NEGATIVE_HEARTBEAT = "HeartBtInt must not be negative".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NO_MSG_SEQ_NO = "Received message without MsgSeqNum".getBytes(StandardCharsets.US_ASCII);
    private static final int REJECT_COUNT = RejectReason.values().length;
    private static final byte[][] NOT_LOGGED_ON_SESSION_REJECT_REASONS = new byte[REJECT_COUNT][];
    private static final byte[][] LOGGED_ON_SESSION_REJECT_REASONS = new byte[REJECT_COUNT][];
    private final UtcTimestampEncoder timestampEncoder = new UtcTimestampEncoder();
    private final LogonEncoder logon = new LogonEncoder();
    private final ResendRequestEncoder resendRequest = new ResendRequestEncoder();
    private final LogoutEncoder logout = new LogoutEncoder();
    private final HeartbeatEncoder heartbeat = new HeartbeatEncoder();
    private final RejectEncoder reject = new RejectEncoder();
    private final TestRequestEncoder testRequest = new TestRequestEncoder();
    private final SequenceResetEncoder sequenceReset = new SequenceResetEncoder();
    private final List<HeaderEncoder> headers = Arrays.asList(this.logon.header(), this.resendRequest.header(), this.logout.header(), this.heartbeat.header(), this.reject.header(), this.testRequest.header(), this.sequenceReset.header());
    private final AsciiFormatter lowSequenceNumber;
    private final MutableAsciiBuffer buffer;
    private final GatewayPublication gatewayPublication;
    private final SessionIdStrategy sessionIdStrategy;
    private final SessionCustomisationStrategy customisationStrategy;
    private final EpochClock clock;
    private final long connectionId;
    private final int libraryId;
    private long sessionId;
    private boolean libraryConnected = true;
    private boolean seqNumResetRequested = false;

    public SessionProxy(MutableAsciiBuffer buffer, GatewayPublication gatewayPublication, SessionIdStrategy sessionIdStrategy, SessionCustomisationStrategy customisationStrategy, EpochClock clock, long connectionId, int libraryId) {
        this.gatewayPublication = gatewayPublication;
        this.sessionIdStrategy = sessionIdStrategy;
        this.customisationStrategy = customisationStrategy;
        this.clock = clock;
        this.connectionId = connectionId;
        this.libraryId = libraryId;
        this.buffer = buffer;
        this.lowSequenceNumber = new AsciiFormatter((CharSequence)"MsgSeqNum too low, expecting %s but received %s");
        this.timestampEncoder.initialise(clock.time());
    }

    public SessionProxy setupSession(long sessionId, CompositeKey sessionKey) {
        Objects.requireNonNull(sessionKey, "sessionKey");
        this.sessionId = sessionId;
        for (HeaderEncoder header : this.headers) {
            this.sessionIdStrategy.setupSession(sessionKey, header);
        }
        return this;
    }

    long resendRequest(int msgSeqNo, int beginSeqNo, int endSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        HeaderEncoder header = this.resendRequest.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        this.resendRequest.beginSeqNo(beginSeqNo).endSeqNo(endSeqNo);
        long result = this.resendRequest.encode(this.buffer, 0);
        return this.send(result, 50, sequenceIndex, (Encoder)this.resendRequest, msgSeqNo);
    }

    long requestDisconnect(long connectionId, DisconnectReason reason) {
        return this.gatewayPublication.saveRequestDisconnect(this.libraryId, connectionId, reason);
    }

    public long logon(int heartbeatIntervalInS, int msgSeqNo, String username, String password, boolean resetSeqNumFlag, int sequenceIndex, int lastMsgSeqNumProcessed) {
        HeaderEncoder header = this.logon.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        this.logon.heartBtInt(heartbeatIntervalInS).resetSeqNumFlag(resetSeqNumFlag).encryptMethod(0);
        if (!this.nullOrEmpty(username)) {
            this.logon.username((CharSequence)username);
        }
        if (!this.nullOrEmpty(password)) {
            this.logon.password((CharSequence)password);
        }
        this.customisationStrategy.configureLogon(this.logon, this.sessionId);
        this.seqNumResetRequested = this.logon.resetSeqNumFlag();
        long result = this.logon.encode(this.buffer, 0);
        return this.send(result, 65, sequenceIndex, (Encoder)this.logon, msgSeqNo);
    }

    private boolean nullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public long logout(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.logout(msgSeqNo, null, 0, sequenceIndex, lastMsgSeqNumProcessed);
    }

    public long logout(int msgSeqNo, int sequenceIndex, int rejectReason, int lastMsgSeqNumProcessed) {
        byte[] reasonText = LOGGED_ON_SESSION_REJECT_REASONS[rejectReason];
        return this.logout(msgSeqNo, reasonText, reasonText.length, sequenceIndex, lastMsgSeqNumProcessed);
    }

    private long logout(int msgSeqNo, byte[] text, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.logout(msgSeqNo, text, text.length, sequenceIndex, lastMsgSeqNumProcessed);
    }

    private long logout(int msgSeqNo, byte[] text, int length, int sequenceIndex, int lastMsgSeqNumProcessed) {
        HeaderEncoder header = this.logout.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        if (text != null) {
            this.logout.text(text, length);
        }
        this.customisationStrategy.configureLogout(this.logout, this.sessionId);
        long result = this.logout.encode(this.buffer, 0);
        return this.send(result, 53, sequenceIndex, (Encoder)this.logout, msgSeqNo);
    }

    public long lowSequenceNumberLogout(int msgSeqNo, int expectedSeqNo, int receivedSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        this.lowSequenceNumber.with(expectedSeqNo).with(receivedSeqNo);
        long position = this.logout(msgSeqNo, this.lowSequenceNumber.value(), this.lowSequenceNumber.length(), sequenceIndex, lastMsgSeqNumProcessed);
        this.lowSequenceNumber.clear();
        return position;
    }

    public long incorrectBeginStringLogout(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.logout(msgSeqNo, INCORRECT_BEGIN_STRING, sequenceIndex, lastMsgSeqNumProcessed);
    }

    public long negativeHeartbeatLogout(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.logout(msgSeqNo, NEGATIVE_HEARTBEAT, sequenceIndex, lastMsgSeqNumProcessed);
    }

    public long receivedMessageWithoutSequenceNumber(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.logout(msgSeqNo, NO_MSG_SEQ_NO, sequenceIndex, lastMsgSeqNumProcessed);
    }

    public long rejectWhilstNotLoggedOn(int msgSeqNo, RejectReason reason, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.logout(msgSeqNo, NOT_LOGGED_ON_SESSION_REJECT_REASONS[reason.ordinal()], sequenceIndex, lastMsgSeqNumProcessed);
    }

    public long heartbeat(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.heartbeat(null, 0, msgSeqNo, sequenceIndex, lastMsgSeqNumProcessed);
    }

    public long heartbeat(char[] testReqId, int testReqIdLength, int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        HeaderEncoder header = this.heartbeat.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        if (testReqId != null) {
            this.heartbeat.testReqID(testReqId, testReqIdLength);
        } else {
            this.heartbeat.resetTestReqID();
        }
        long result = this.heartbeat.encode(this.buffer, 0);
        return this.send(result, 48, sequenceIndex, (Encoder)this.heartbeat, msgSeqNo);
    }

    public long reject(int msgSeqNo, int refSeqNum, int refTagId, byte[] refMsgType, int refMsgTypeLength, RejectReason reason, int sequenceIndex, int lastMsgSeqNumProcessed) {
        this.reject.refTagID(refTagId);
        return this.reject(msgSeqNo, refSeqNum, refMsgType, refMsgTypeLength, reason, sequenceIndex, lastMsgSeqNumProcessed);
    }

    public long reject(int msgSeqNo, int refSeqNum, byte[] refMsgType, int refMsgTypeLength, RejectReason reason, int sequenceIndex, int lastMsgSeqNumProcessed) {
        int rejectReason = reason.representation();
        this.reject.refMsgType(refMsgType, refMsgTypeLength);
        this.reject.text(LOGGED_ON_SESSION_REJECT_REASONS[rejectReason]);
        return this.sendReject(msgSeqNo, refSeqNum, rejectReason, sequenceIndex, lastMsgSeqNumProcessed);
    }

    public long reject(int msgSeqNo, int refSeqNum, int refTagId, char[] refMsgType, int refMsgTypeLength, int rejectReason, int sequenceIndex, int lastMsgSeqNumProcessed) {
        this.reject.refTagID(refTagId);
        return this.reject(msgSeqNo, refSeqNum, refMsgType, refMsgTypeLength, rejectReason, sequenceIndex, lastMsgSeqNumProcessed);
    }

    public long reject(int msgSeqNo, int refSeqNum, char[] refMsgType, int refMsgTypeLength, int rejectReason, int sequenceIndex, int lastMsgSeqNumProcessed) {
        this.reject.refMsgType(refMsgType, refMsgTypeLength);
        this.reject.text(LOGGED_ON_SESSION_REJECT_REASONS[rejectReason]);
        return this.sendReject(msgSeqNo, refSeqNum, rejectReason, sequenceIndex, lastMsgSeqNumProcessed);
    }

    private long sendReject(int msgSeqNo, int refSeqNum, int rejectReason, int sequenceIndex, int lastMsgSeqNumProcessed) {
        HeaderEncoder header = this.reject.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        this.reject.refSeqNum(refSeqNum);
        this.reject.sessionRejectReason(rejectReason);
        long result = this.reject.encode(this.buffer, 0);
        return this.send(result, 51, sequenceIndex, (Encoder)this.reject, msgSeqNo);
    }

    public long testRequest(int msgSeqNo, CharSequence testReqID, int sequenceIndex, int lastMsgSeqNumProcessed) {
        HeaderEncoder header = this.testRequest.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        this.testRequest.testReqID(testReqID);
        long result = this.testRequest.encode(this.buffer, 0);
        return this.send(result, 49, sequenceIndex, (Encoder)this.testRequest, msgSeqNo);
    }

    public long sequenceReset(int msgSeqNo, int newSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        HeaderEncoder header = this.sequenceReset.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        this.sequenceReset.newSeqNo(newSeqNo);
        long result = this.sequenceReset.encode(this.buffer, 0);
        return this.send(result, 52, sequenceIndex, (Encoder)this.sequenceReset, msgSeqNo);
    }

    private void setupHeader(HeaderEncoder header, int msgSeqNo, int lastMsgSeqNumProcessed) {
        UtcTimestampEncoder timestampEncoder = this.timestampEncoder;
        header.sendingTime(timestampEncoder.buffer(), timestampEncoder.update(this.clock.time()));
        header.msgSeqNum(msgSeqNo);
        if (lastMsgSeqNumProcessed != -1) {
            header.lastMsgSeqNumProcessed(lastMsgSeqNumProcessed);
        }
    }

    private long send(long result, int messageType, int sequenceIndex, Encoder encoder, int msgSeqNo) {
        if (!this.libraryConnected) {
            return -2147483647L;
        }
        int length = Encoder.length((long)result);
        int offset = Encoder.offset((long)result);
        long position = this.gatewayPublication.saveMessage((DirectBuffer)this.buffer, offset, length, this.libraryId, messageType, this.sessionId, sequenceIndex, this.connectionId, MessageStatus.OK, msgSeqNo);
        encoder.resetMessage();
        return position;
    }

    void libraryConnected(boolean libraryConnected) {
        this.libraryConnected = libraryConnected;
    }

    boolean isSeqNumResetRequested() {
        return this.seqNumResetRequested;
    }

    static {
        RejectReason[] reasons = RejectReason.values();
        for (int i = 0; i < REJECT_COUNT; ++i) {
            RejectReason reason = reasons[i];
            String formattedReason = reason.name().replace('_', ' ').toLowerCase();
            SessionProxy.NOT_LOGGED_ON_SESSION_REJECT_REASONS[i] = String.format("Invalid Logon message: SendingTime accuracy problem, field=52, reason=%s", formattedReason).getBytes(StandardCharsets.US_ASCII);
            SessionProxy.LOGGED_ON_SESSION_REJECT_REASONS[i] = reason == RejectReason.VALUE_IS_INCORRECT ? "Value is incorrect (out of range) for this tag".getBytes(StandardCharsets.US_ASCII) : formattedReason.getBytes(StandardCharsets.US_ASCII);
        }
    }
}

