/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatDecoder;
import uk.co.real_logic.artio.messages.AwaitingResend;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.InitiateConnectionDecoder;
import uk.co.real_logic.artio.messages.LibraryConnectDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.ReleaseSessionDecoder;
import uk.co.real_logic.artio.messages.RequestDisconnectDecoder;
import uk.co.real_logic.artio.messages.RequestSessionDecoder;
import uk.co.real_logic.artio.messages.ResetSequenceNumber;
import uk.co.real_logic.artio.protocol.EngineEndPointHandler;

public final class EngineProtocolSubscription
implements ControlledFragmentHandler {
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final InitiateConnectionDecoder initiateConnection = new InitiateConnectionDecoder();
    private final RequestDisconnectDecoder requestDisconnect = new RequestDisconnectDecoder();
    private final ApplicationHeartbeatDecoder applicationHeartbeat = new ApplicationHeartbeatDecoder();
    private final LibraryConnectDecoder libraryConnect = new LibraryConnectDecoder();
    private final ReleaseSessionDecoder releaseSession = new ReleaseSessionDecoder();
    private final RequestSessionDecoder requestSession = new RequestSessionDecoder();
    private final EngineEndPointHandler handler;

    public EngineProtocolSubscription(EngineEndPointHandler handler) {
        this.handler = handler;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        offset += this.messageHeader.encodedLength();
        switch (this.messageHeader.templateId()) {
            case 12: {
                return this.onRequestDisconnect(buffer, offset, blockLength, version, header);
            }
            case 11: {
                return this.onInitiateConnection(buffer, offset, blockLength, version, header);
            }
            case 16: {
                return this.onApplicationHeartbeat(buffer, offset, blockLength, version, header);
            }
            case 17: {
                return this.onLibraryConnect(buffer, offset, blockLength, version, header);
            }
            case 29: {
                return this.onReleaseSession(buffer, offset, blockLength, version, header);
            }
            case 31: {
                return this.onRequestSession(buffer, offset, blockLength, version, header);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onApplicationHeartbeat(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.applicationHeartbeat.wrap(buffer, offset, blockLength, version);
        this.handler.onApplicationHeartbeat(this.applicationHeartbeat.libraryId(), header.sessionId());
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onLibraryConnect(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.libraryConnect.wrap(buffer, offset, blockLength, version);
        int libraryId = this.libraryConnect.libraryId();
        String libraryName = this.libraryConnect.libraryName();
        return this.handler.onLibraryConnect(libraryId, libraryName, this.libraryConnect.correlationId(), header.sessionId());
    }

    private ControlledFragmentHandler.Action onReleaseSession(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.releaseSession.wrap(buffer, offset, blockLength, version);
        int libraryId = this.releaseSession.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onReleaseSession(libraryId, this.releaseSession.connection(), this.releaseSession.sessionId(), this.releaseSession.correlationId(), this.releaseSession.state(), this.releaseSession.awaitingResend() == AwaitingResend.YES, this.releaseSession.heartbeatIntervalInMs(), this.releaseSession.lastSentSequenceNumber(), this.releaseSession.lastReceivedSequenceNumber(), this.releaseSession.username(), this.releaseSession.password(), header);
    }

    private ControlledFragmentHandler.Action onRequestSession(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.requestSession.wrap(buffer, offset, blockLength, version);
        int libraryId = this.requestSession.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onRequestSession(libraryId, this.requestSession.sessionId(), this.requestSession.correlationId(), this.requestSession.lastReceivedSequenceNumber(), this.requestSession.sequenceIndex());
    }

    private ControlledFragmentHandler.Action onInitiateConnection(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.initiateConnection.wrap(buffer, offset, blockLength, version);
        int libraryId = this.initiateConnection.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onInitiateConnection(libraryId, this.initiateConnection.port(), this.initiateConnection.host(), this.initiateConnection.senderCompId(), this.initiateConnection.senderSubId(), this.initiateConnection.senderLocationId(), this.initiateConnection.targetCompId(), this.initiateConnection.targetSubId(), this.initiateConnection.targetLocationId(), this.initiateConnection.sequenceNumberType(), this.initiateConnection.requestedInitialReceivedSequenceNumber(), this.initiateConnection.requestedInitialSentSequenceNumber(), this.initiateConnection.resetSequenceNumber() == ResetSequenceNumber.YES, this.initiateConnection.closedResendInterval() == Bool.TRUE, this.initiateConnection.resendRequestChunkSize(), this.initiateConnection.sendRedundantResendRequests() == Bool.TRUE, this.initiateConnection.enableLastMsgSeqNumProcessed() == Bool.TRUE, this.initiateConnection.username(), this.initiateConnection.password(), this.initiateConnection.heartbeatIntervalInS(), this.initiateConnection.correlationId(), header);
    }

    private ControlledFragmentHandler.Action onRequestDisconnect(DirectBuffer buffer, int offset, int blockLength, int version, Header header) {
        this.requestDisconnect.wrap(buffer, offset, blockLength, version);
        int libraryId = this.requestDisconnect.libraryId();
        ControlledFragmentHandler.Action action = this.handler.onApplicationHeartbeat(libraryId, header.sessionId());
        if (action != null) {
            return action;
        }
        return this.handler.onRequestDisconnect(libraryId, this.requestDisconnect.connection(), this.requestDisconnect.reason());
    }
}

