/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.ArrayList;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.decoder.LogonDecoder;
import uk.co.real_logic.artio.engine.framer.AuthenticationResult;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionParser;
import uk.co.real_logic.artio.session.SessionProxy;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;
import uk.co.real_logic.artio.validation.PersistenceLevel;
import uk.co.real_logic.artio.validation.SessionPersistenceStrategy;

class GatewaySessions {
    private final List<GatewaySession> sessions = new ArrayList<GatewaySession>();
    private final EpochClock clock;
    private final GatewayPublication outboundPublication;
    private final SessionIdStrategy sessionIdStrategy;
    private final SessionCustomisationStrategy customisationStrategy;
    private final FixCounters fixCounters;
    private final AuthenticationStrategy authenticationStrategy;
    private final MessageValidationStrategy validationStrategy;
    private final int sessionBufferSize;
    private final long sendingTimeWindowInMs;
    private final long reasonableTransmissionTimeInMs;
    private final boolean logAllMessages;
    private final SessionContexts sessionContexts;
    private final SessionPersistenceStrategy sessionPersistenceStrategy;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private ErrorHandler errorHandler;

    GatewaySessions(EpochClock clock, GatewayPublication outboundPublication, SessionIdStrategy sessionIdStrategy, SessionCustomisationStrategy customisationStrategy, FixCounters fixCounters, AuthenticationStrategy authenticationStrategy, MessageValidationStrategy validationStrategy, int sessionBufferSize, long sendingTimeWindowInMs, long reasonableTransmissionTimeInMs, boolean logAllMessages, ErrorHandler errorHandler, SessionContexts sessionContexts, SessionPersistenceStrategy sessionPersistenceStrategy, SequenceNumberIndexReader sentSequenceNumberIndex, SequenceNumberIndexReader receivedSequenceNumberIndex) {
        this.clock = clock;
        this.outboundPublication = outboundPublication;
        this.sessionIdStrategy = sessionIdStrategy;
        this.customisationStrategy = customisationStrategy;
        this.fixCounters = fixCounters;
        this.authenticationStrategy = authenticationStrategy;
        this.validationStrategy = validationStrategy;
        this.sessionBufferSize = sessionBufferSize;
        this.sendingTimeWindowInMs = sendingTimeWindowInMs;
        this.reasonableTransmissionTimeInMs = reasonableTransmissionTimeInMs;
        this.logAllMessages = logAllMessages;
        this.errorHandler = errorHandler;
        this.sessionContexts = sessionContexts;
        this.sessionPersistenceStrategy = sessionPersistenceStrategy;
        this.sentSequenceNumberIndex = sentSequenceNumberIndex;
        this.receivedSequenceNumberIndex = receivedSequenceNumberIndex;
    }

    void acquire(GatewaySession gatewaySession, SessionState state, boolean awaitingResend, int heartbeatIntervalInS, int lastSentSequenceNumber, int lastReceivedSequenceNumber, String username, String password, BlockablePosition engineBlockablePosition) {
        long connectionId = gatewaySession.connectionId();
        AtomicCounter receivedMsgSeqNo = this.fixCounters.receivedMsgSeqNo(connectionId);
        AtomicCounter sentMsgSeqNo = this.fixCounters.sentMsgSeqNo(connectionId);
        MutableAsciiBuffer asciiBuffer = new MutableAsciiBuffer(new byte[this.sessionBufferSize]);
        SessionProxy proxy = new SessionProxy(asciiBuffer, this.outboundPublication, this.sessionIdStrategy, this.customisationStrategy, this.clock, connectionId, 0);
        InternalSession session = new InternalSession(heartbeatIntervalInS, connectionId, this.clock, state, proxy, this.outboundPublication, this.sessionIdStrategy, this.sendingTimeWindowInMs, receivedMsgSeqNo, sentMsgSeqNo, 0, lastSentSequenceNumber + 1, 0, this.reasonableTransmissionTimeInMs, asciiBuffer, gatewaySession.enableLastMsgSeqNumProcessed());
        session.awaitingResend(awaitingResend);
        session.closedResendInterval(gatewaySession.closedResendInterval());
        session.resendRequestChunkSize(gatewaySession.resendRequestChunkSize());
        session.sendRedundantResendRequests(gatewaySession.sendRedundantResendRequests());
        SessionParser sessionParser = new SessionParser(session, this.sessionIdStrategy, this.validationStrategy, this.errorHandler);
        this.sessions.add(gatewaySession);
        gatewaySession.manage(sessionParser, session, engineBlockablePosition);
        CompositeKey sessionKey = gatewaySession.sessionKey();
        DebugLogger.log(LogTag.FIX_CONNECTION, "Gateway Acquired Session %d%n", connectionId);
        if (sessionKey != null) {
            gatewaySession.onLogon(username, password, heartbeatIntervalInS);
            session.lastReceivedMsgSeqNum(lastReceivedSequenceNumber);
        }
    }

    GatewaySession releaseBySessionId(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.remove(index);
    }

    GatewaySession sessionById(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.get(index);
    }

    private int indexBySessionId(long sessionId) {
        List<GatewaySession> sessions = this.sessions;
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.sessionId() != sessionId) continue;
            return i;
        }
        return -1;
    }

    void releaseByConnectionId(long connectionId) {
        GatewaySession session = GatewaySessions.removeSessionByConnectionId(connectionId, this.sessions);
        if (session != null) {
            session.close();
        }
    }

    int pollSessions(long time) {
        List<GatewaySession> sessions = this.sessions;
        int eventsProcessed = 0;
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            eventsProcessed += session.poll(time);
        }
        return eventsProcessed;
    }

    List<GatewaySession> sessions() {
        return this.sessions;
    }

    static GatewaySession removeSessionByConnectionId(long connectionId, List<GatewaySession> sessions) {
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.connectionId() != connectionId) continue;
            sessions.remove(i);
            return session;
        }
        return null;
    }

    AuthenticationResult authenticate(LogonDecoder logon, long connectionId, GatewaySession gatewaySession) {
        boolean resetSeqNum;
        CompositeKey compositeKey = this.sessionIdStrategy.onAcceptLogon(logon.header());
        SessionContext sessionContext = this.sessionContexts.onLogon(compositeKey);
        long sessionId = sessionContext.sessionId();
        if (sessionContext == SessionContexts.DUPLICATE_SESSION) {
            return AuthenticationResult.DUPLICATE_SESSION;
        }
        boolean authenticated = this.authenticate(logon, connectionId);
        if (!authenticated) {
            return AuthenticationResult.FAILED_AUTHENTICATION;
        }
        PersistenceLevel persistenceLevel = this.getPersistenceLevel(logon, connectionId);
        boolean resetSeqNumFlag = logon.hasResetSeqNumFlag() && logon.resetSeqNumFlag();
        boolean bl = resetSeqNum = SessionPersistenceStrategy.resetSequenceNumbersUponLogon(persistenceLevel) || resetSeqNumFlag;
        if (persistenceLevel == PersistenceLevel.INDEXED && !this.logAllMessages) {
            this.onError(new IllegalStateException("Persistence Strategy specified INDEXED but EngineConfiguration has disabled required logging of messsages"));
            return AuthenticationResult.INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES;
        }
        String username = SessionParser.username(logon);
        String password = SessionParser.password(logon);
        sessionContext.onLogon(resetSeqNum);
        gatewaySession.onLogon(sessionId, sessionContext, compositeKey, username, password, logon.heartBtInt());
        if (resetSeqNum) {
            gatewaySession.acceptorSequenceNumbers(-1, -1);
        } else {
            long requiredPosition = this.outboundPublication.position();
            if (!this.lookupSequenceNumbers(gatewaySession, requiredPosition)) {
                return new AuthenticationResult(gatewaySession, requiredPosition);
            }
        }
        return new AuthenticationResult(gatewaySession);
    }

    public boolean lookupSequenceNumbers(GatewaySession gatewaySession, long requiredPosition) {
        int aeronSessionId = this.outboundPublication.id();
        if (requiredPosition > 0L && this.sentSequenceNumberIndex.indexedPosition(aeronSessionId) < requiredPosition) {
            return false;
        }
        long sessionId = gatewaySession.sessionId();
        int lastSentSequenceNumber = this.sentSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        int lastReceivedSequenceNumber = this.receivedSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        gatewaySession.acceptorSequenceNumbers(lastSentSequenceNumber, lastReceivedSequenceNumber);
        return true;
    }

    private PersistenceLevel getPersistenceLevel(LogonDecoder logon, long connectionId) {
        try {
            return this.sessionPersistenceStrategy.getPersistenceLevel(logon);
        }
        catch (Throwable throwable) {
            this.onStrategyError("persistence", throwable, connectionId, "UNINDEXED", logon);
            return PersistenceLevel.UNINDEXED;
        }
    }

    private boolean authenticate(LogonDecoder logon, long connectionId) {
        try {
            return this.authenticationStrategy.authenticate(logon);
        }
        catch (Throwable throwable) {
            this.onStrategyError("authentication", throwable, connectionId, "false", logon);
            return false;
        }
    }

    private void onStrategyError(String strategyName, Throwable throwable, long connectionId, String theDefault, LogonDecoder logon) {
        String message = String.format("Exception thrown by %s strategy for connectionId=%d, processing [%s], defaulted to %s", strategyName, connectionId, logon.toString(), theDefault);
        this.onError(new FixGatewayException(message, throwable));
    }

    private void onError(Throwable throwable) {
        if (this.errorHandler == null) {
            LangUtil.rethrowUnchecked((Throwable)throwable);
        } else {
            this.errorHandler.onError(throwable);
        }
    }
}

