/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.Aeron;
import io.aeron.Publication;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.status.RecordingPos;
import java.util.ArrayList;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;

public class RecordingCoordinator
implements AutoCloseable {
    private final IdleStrategy idleStrategy = CommonConfiguration.backoffIdleStrategy();
    private final IntHashSet trackedSessionIds = new IntHashSet();
    private final AeronArchive archive;
    private final String channel;
    private final CountersReader counters;
    private final EngineConfiguration configuration;
    private final RecordingIdLookup inboundLookup;
    private final RecordingIdLookup outboundLookup;
    private Long2LongHashMap inboundAeronSessionIdToCompletionPosition;
    private Long2LongHashMap outboundAeronSessionIdToCompletionPosition;
    private boolean closed = false;

    RecordingCoordinator(AeronArchive archive, EngineConfiguration configuration, AgentInvoker conductorAgentInvoker, IdleStrategy archiverIdleStrategy) {
        this.archive = archive;
        this.configuration = configuration;
        this.channel = configuration.libraryAeronChannel();
        if (configuration.logAnyMessages()) {
            AeronArchive.Context archiveContext = archive.context();
            Aeron aeron = archiveContext.aeron();
            this.counters = aeron.countersReader();
            this.inboundLookup = new RecordingIdLookup(archiverIdleStrategy, this.counters);
            this.outboundLookup = new RecordingIdLookup(archiverIdleStrategy, this.counters);
            if (configuration.logInboundMessages()) {
                archive.startRecording(this.channel, configuration.inboundLibraryStream(), SourceLocation.LOCAL);
            }
            if (configuration.logOutboundMessages()) {
                SourceLocation location = this.channel.equals("aeron:ipc") ? SourceLocation.LOCAL : SourceLocation.REMOTE;
                archive.startRecording(this.channel, configuration.outboundLibraryStream(), location);
            }
        } else {
            this.counters = null;
            this.inboundLookup = null;
            this.outboundLookup = null;
        }
    }

    public void track(Publication publication) {
        int streamId = publication.streamId();
        if (streamId == this.configuration.outboundLibraryStream() && this.configuration.logOutboundMessages() || streamId == this.configuration.inboundLibraryStream() && this.configuration.logInboundMessages()) {
            this.trackedSessionIds.add(publication.sessionId());
        }
    }

    void awaitReady() {
        while (!this.trackedSessionIds.isEmpty()) {
            IntHashSet.IntIterator sessionIdIterator = this.trackedSessionIds.iterator();
            while (sessionIdIterator.hasNext()) {
                int sessionId = sessionIdIterator.nextValue();
                if (!this.hasRecordingStarted(sessionId)) continue;
                sessionIdIterator.remove();
            }
            this.idleStrategy.idle();
        }
        this.idleStrategy.reset();
    }

    public void completionPositions(Long2LongHashMap inboundAeronSessionIdToCompletionPosition, Long2LongHashMap outboundAeronSessionIdToCompletionPosition) {
        this.inboundAeronSessionIdToCompletionPosition = inboundAeronSessionIdToCompletionPosition;
        this.outboundAeronSessionIdToCompletionPosition = outboundAeronSessionIdToCompletionPosition;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.awaitRecordingsCompletion();
            this.shutdownArchiver();
            this.closed = true;
        }
    }

    private void awaitRecordingsCompletion() {
        if (this.configuration.logInboundMessages()) {
            this.awaitRecordingsCompletion(this.inboundAeronSessionIdToCompletionPosition);
        }
        if (this.configuration.logOutboundMessages()) {
            this.awaitRecordingsCompletion(this.outboundAeronSessionIdToCompletionPosition);
        }
    }

    private void awaitRecordingsCompletion(Long2LongHashMap aeronSessionIdToCompletionPosition) {
        if (aeronSessionIdToCompletionPosition == null) {
            throw new IllegalStateException("Unknown completionPositions when shutting down the RecordingCoordinator");
        }
        ArrayList<CompletingRecording> completingRecordings = new ArrayList<CompletingRecording>();
        aeronSessionIdToCompletionPosition.longForEach((sessionId, completionPosition) -> {
            int counterId = RecordingPos.findCounterIdBySession((CountersReader)this.counters, (int)((int)sessionId));
            if (counterId != -1) {
                completingRecordings.add(new CompletingRecording(completionPosition, counterId));
            }
        });
        while (!completingRecordings.isEmpty()) {
            completingRecordings.removeIf(CompletingRecording::hasRecordingCompleted);
            this.idleStrategy.idle();
        }
        this.idleStrategy.reset();
    }

    private void shutdownArchiver() {
        if (this.configuration.logInboundMessages()) {
            this.archive.stopRecording(this.channel, this.configuration.inboundLibraryStream());
        }
        if (this.configuration.logOutboundMessages()) {
            this.archive.stopRecording(this.channel, this.configuration.outboundLibraryStream());
        }
        if (this.configuration.logAnyMessages()) {
            this.archive.close();
        }
    }

    private boolean hasRecordingStarted(int sessionId) {
        return RecordingPos.findCounterIdBySession((CountersReader)this.counters, (int)sessionId) != -1;
    }

    RecordingIdLookup inboundRecordingIdLookup() {
        return this.inboundLookup;
    }

    RecordingIdLookup outboundRecordingIdLookup() {
        return this.outboundLookup;
    }

    private class CompletingRecording {
        private final long completedPosition;
        private final long recordingId;
        private final int counterId;

        CompletingRecording(long completedPosition, int counterId) {
            this.completedPosition = completedPosition;
            this.counterId = counterId;
            this.recordingId = RecordingPos.getRecordingId((CountersReader)RecordingCoordinator.this.counters, (int)this.counterId);
        }

        boolean hasRecordingCompleted() {
            long recordedPosition = RecordingCoordinator.this.counters.getCounterValue(this.counterId);
            if (recordedPosition >= this.completedPosition) {
                return true;
            }
            if (!RecordingPos.isActive((CountersReader)RecordingCoordinator.this.counters, (int)this.counterId, (long)this.recordingId)) {
                throw new IllegalStateException("recording has stopped unexpectedly: " + this.recordingId);
            }
            return false;
        }
    }
}

