/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.LongLongConsumer;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.engine.logger.Index;
import uk.co.real_logic.artio.engine.logger.IndexedPositionConsumer;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.protocol.GatewayPublication;

public class PositionSender
implements Index {
    private static final int MISSING_LIBRARY = -1;
    private final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    private final FixMessageDecoder fixMessage = new FixMessageDecoder();
    private final Long2LongHashMap libraryIdToPosition = new Long2LongHashMap(-1L);
    private final LongLongConsumer resendPositionFunc = this::endPosition;
    private final GatewayPublication publication;
    private int resendCount;

    public PositionSender(GatewayPublication publication) {
        this.publication = publication;
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeader.wrap(buffer, offset);
        if (this.messageHeader.templateId() == 1) {
            this.fixMessage.wrap(buffer, offset += 8, this.messageHeader.blockLength(), this.messageHeader.version());
            this.newPosition(this.fixMessage.libraryId(), header.position());
        }
    }

    public void newPosition(int libraryId, long endPosition) {
        this.libraryIdToPosition.put((long)libraryId, endPosition);
    }

    @Override
    public int doWork() {
        this.resendCount = 0;
        this.libraryIdToPosition.longForEach(this.resendPositionFunc);
        return this.resendCount;
    }

    private void endPosition(long libraryId, long endPosition) {
        if (this.saveNewSentPosition((int)libraryId, endPosition)) {
            this.libraryIdToPosition.remove(libraryId);
            ++this.resendCount;
        }
    }

    private boolean saveNewSentPosition(int libraryId, long endPosition) {
        return !Pressure.isBackPressured(this.publication.saveNewSentPosition(libraryId, endPosition));
    }

    @Override
    public void close() {
    }

    @Override
    public void readLastPosition(IndexedPositionConsumer consumer) {
    }
}

