/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.builder.AbstractHeartbeatEncoder;
import uk.co.real_logic.artio.builder.AbstractLogonEncoder;
import uk.co.real_logic.artio.builder.AbstractLogoutEncoder;
import uk.co.real_logic.artio.builder.AbstractRejectEncoder;
import uk.co.real_logic.artio.builder.AbstractResendRequestEncoder;
import uk.co.real_logic.artio.builder.AbstractSequenceResetEncoder;
import uk.co.real_logic.artio.builder.AbstractTestRequestEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.fields.EpochFractionFormat;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionProxy;
import uk.co.real_logic.artio.util.AsciiFormatter;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class DirectSessionProxy
implements SessionProxy {
    static final int NO_LAST_MSG_SEQ_NUM_PROCESSED = -1;
    private static final byte[] INCORRECT_BEGIN_STRING = "Incorrect BeginString".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NEGATIVE_HEARTBEAT = "HeartBtInt must not be negative".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NO_MSG_SEQ_NO = "Received message without MsgSeqNum".getBytes(StandardCharsets.US_ASCII);
    private static final int REJECT_COUNT = RejectReason.values().length;
    private static final byte[][] NOT_LOGGED_ON_SESSION_REJECT_REASONS = new byte[REJECT_COUNT][];
    private static final byte[][] LOGGED_ON_SESSION_REJECT_REASONS = new byte[REJECT_COUNT][];
    private static final int OTHER_REJECT_INDEX = 19;
    private final UtcTimestampEncoder timestampEncoder;
    private FixDictionary dictionary;
    private AbstractLogonEncoder logon;
    private AbstractResendRequestEncoder resendRequest;
    private AbstractLogoutEncoder logout;
    private AbstractHeartbeatEncoder heartbeat;
    private AbstractRejectEncoder reject;
    private AbstractTestRequestEncoder testRequest;
    private AbstractSequenceResetEncoder sequenceReset;
    private List<SessionHeaderEncoder> headers;
    private final AsciiFormatter lowSequenceNumber;
    private final MutableAsciiBuffer buffer;
    private final ErrorHandler errorHandler;
    private final GatewayPublication gatewayPublication;
    private final SessionIdStrategy sessionIdStrategy;
    private final SessionCustomisationStrategy customisationStrategy;
    private final int libraryId;
    private final EpochNanoClock clock;
    private long connectionId;
    private long sessionId;
    private boolean libraryConnected = true;
    private boolean seqNumResetRequested = false;
    private long lastSentPosition = 0L;

    public DirectSessionProxy(int sessionBufferSize, GatewayPublication gatewayPublication, SessionIdStrategy sessionIdStrategy, SessionCustomisationStrategy customisationStrategy, EpochNanoClock clock, long connectionId, int libraryId, ErrorHandler errorHandler, EpochFractionFormat epochFractionPrecision) {
        this.gatewayPublication = gatewayPublication;
        this.sessionIdStrategy = sessionIdStrategy;
        this.customisationStrategy = customisationStrategy;
        this.clock = clock;
        this.connectionId = connectionId;
        this.libraryId = libraryId;
        this.buffer = new MutableAsciiBuffer(new byte[sessionBufferSize]);
        this.errorHandler = errorHandler;
        this.lowSequenceNumber = new AsciiFormatter((CharSequence)"MsgSeqNum too low, expecting %s but received %s");
        this.timestampEncoder = new UtcTimestampEncoder(epochFractionPrecision);
        this.timestampEncoder.initialise(clock.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public void fixDictionary(FixDictionary dictionary) {
        this.dictionary = dictionary;
        this.logon = dictionary.makeLogonEncoder();
        this.resendRequest = dictionary.makeResendRequestEncoder();
        this.logout = dictionary.makeLogoutEncoder();
        this.heartbeat = dictionary.makeHeartbeatEncoder();
        this.reject = dictionary.makeRejectEncoder();
        this.testRequest = dictionary.makeTestRequestEncoder();
        this.sequenceReset = dictionary.makeSequenceResetEncoder();
        this.headers = Arrays.asList(this.logon.header(), this.resendRequest.header(), this.logout.header(), this.heartbeat.header(), this.reject.header(), this.testRequest.header(), this.sequenceReset.header());
    }

    @Override
    public void setupSession(long sessionId, CompositeKey sessionKey) {
        Objects.requireNonNull(sessionKey, "sessionKey");
        this.sessionId = sessionId;
        for (SessionHeaderEncoder header : this.headers) {
            this.sessionIdStrategy.setupSession(sessionKey, header);
            this.customisationStrategy.configureHeader(header, sessionId);
        }
    }

    @Override
    public void connectionId(long connectionId) {
        this.connectionId = connectionId;
    }

    @Override
    public long sendResendRequest(int msgSeqNo, int beginSeqNo, int endSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        SessionHeaderEncoder header = this.resendRequest.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        this.resendRequest.beginSeqNo(beginSeqNo).endSeqNo(endSeqNo);
        long result = this.resendRequest.encode(this.buffer, 0);
        return this.send(result, 50L, sequenceIndex, (Encoder)this.resendRequest, msgSeqNo);
    }

    @Override
    public long sendRequestDisconnect(long connectionId, DisconnectReason reason) {
        return this.gatewayPublication.saveRequestDisconnect(this.libraryId, connectionId, reason);
    }

    @Override
    public long sendLogon(int msgSeqNo, int heartbeatIntervalInS, String username, String password, boolean resetSeqNumFlag, int sequenceIndex, int lastMsgSeqNumProcessed, CancelOnDisconnectOption cancelOnDisconnectOption, int cancelOnDisconnectTimeoutWindowInMs) {
        AbstractLogonEncoder logon = this.logon;
        SessionHeaderEncoder header = logon.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        logon.heartBtInt(heartbeatIntervalInS).resetSeqNumFlag(resetSeqNumFlag).encryptMethod(0);
        if (this.notNullOrEmpty(username)) {
            if (!logon.supportsUsername()) {
                this.onMissingFieldError("username");
            } else {
                logon.username((CharSequence)username);
            }
        }
        if (this.notNullOrEmpty(password)) {
            if (!logon.supportsPassword()) {
                this.onMissingFieldError("password");
            } else {
                logon.password((CharSequence)password);
            }
        }
        if (cancelOnDisconnectOption != null && logon.supportsCancelOnDisconnectType()) {
            logon.cancelOnDisconnectType(cancelOnDisconnectOption.value());
        }
        if (cancelOnDisconnectTimeoutWindowInMs != Integer.MIN_VALUE && logon.supportsCODTimeoutWindow()) {
            logon.cODTimeoutWindow(cancelOnDisconnectTimeoutWindowInMs);
        }
        this.customisationStrategy.configureLogon(logon, this.sessionId);
        this.seqNumResetRequested = logon.resetSeqNumFlag();
        long result = logon.encode(this.buffer, 0);
        return this.send(result, 65L, sequenceIndex, (Encoder)logon, msgSeqNo);
    }

    private void onMissingFieldError(String field) {
        this.errorHandler.onError((Throwable)new IllegalStateException(String.format("Dictionary: %1$s does not support %2$s field but %2$s is provided", this.dictionary.getClass().getCanonicalName(), field)));
    }

    private boolean notNullOrEmpty(String string) {
        return string != null && string.length() > 0;
    }

    @Override
    public long sendLogout(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed, byte[] text) {
        return this.sendLogout(msgSeqNo, text, text == null ? 0 : text.length, sequenceIndex, lastMsgSeqNumProcessed);
    }

    @Override
    public long sendLogout(int msgSeqNo, int sequenceIndex, int rejectReason, int lastMsgSeqNumProcessed) {
        int rejectReasonIndex = this.getRejectReasonIndex(rejectReason);
        byte[] reasonText = LOGGED_ON_SESSION_REJECT_REASONS[rejectReasonIndex];
        return this.sendLogout(msgSeqNo, reasonText, reasonText.length, sequenceIndex, lastMsgSeqNumProcessed);
    }

    private long sendLogout(int msgSeqNo, byte[] text, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.sendLogout(msgSeqNo, text, text.length, sequenceIndex, lastMsgSeqNumProcessed);
    }

    private long sendLogout(int msgSeqNo, byte[] text, int length, int sequenceIndex, int lastMsgSeqNumProcessed) {
        SessionHeaderEncoder header = this.logout.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        if (text != null) {
            this.logout.text(text, length);
        }
        this.customisationStrategy.configureLogout(this.logout, this.sessionId);
        long result = this.logout.encode(this.buffer, 0);
        return this.send(result, 53L, sequenceIndex, (Encoder)this.logout, msgSeqNo);
    }

    @Override
    public long sendLowSequenceNumberLogout(int msgSeqNo, int expectedSeqNo, int receivedSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        this.lowSequenceNumber.with(expectedSeqNo).with(receivedSeqNo);
        long position = this.sendLogout(msgSeqNo, this.lowSequenceNumber.value(), this.lowSequenceNumber.length(), sequenceIndex, lastMsgSeqNumProcessed);
        this.lowSequenceNumber.clear();
        return position;
    }

    @Override
    public long sendIncorrectBeginStringLogout(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.sendLogout(msgSeqNo, INCORRECT_BEGIN_STRING, sequenceIndex, lastMsgSeqNumProcessed);
    }

    @Override
    public long sendNegativeHeartbeatLogout(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.sendLogout(msgSeqNo, NEGATIVE_HEARTBEAT, sequenceIndex, lastMsgSeqNumProcessed);
    }

    @Override
    public long sendReceivedMessageWithoutSequenceNumber(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.sendLogout(msgSeqNo, NO_MSG_SEQ_NO, sequenceIndex, lastMsgSeqNumProcessed);
    }

    @Override
    public long sendRejectWhilstNotLoggedOn(int msgSeqNo, RejectReason reason, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.sendLogout(msgSeqNo, NOT_LOGGED_ON_SESSION_REJECT_REASONS[reason.ordinal()], sequenceIndex, lastMsgSeqNumProcessed);
    }

    @Override
    public long sendHeartbeat(int msgSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        return this.sendHeartbeat(msgSeqNo, null, 0, sequenceIndex, lastMsgSeqNumProcessed);
    }

    @Override
    public long sendHeartbeat(int msgSeqNo, char[] testReqId, int testReqIdLength, int sequenceIndex, int lastMsgSeqNumProcessed) {
        SessionHeaderEncoder header = this.heartbeat.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        if (testReqId != null) {
            this.heartbeat.testReqID(testReqId, testReqIdLength);
        } else {
            this.heartbeat.resetTestReqID();
        }
        long result = this.heartbeat.encode(this.buffer, 0);
        return this.send(result, 48L, sequenceIndex, (Encoder)this.heartbeat, msgSeqNo);
    }

    @Override
    public long sendReject(int msgSeqNo, int refSeqNum, int refTagId, char[] refMsgType, int refMsgTypeLength, int rejectReason, int sequenceIndex, int lastMsgSeqNumProcessed) {
        if (refTagId != Integer.MIN_VALUE) {
            this.reject.refTagID(refTagId);
        } else {
            this.reject.resetRefTagID();
        }
        if (this.reject.supportsRefMsgType()) {
            this.reject.refMsgType(refMsgType, refMsgTypeLength);
        }
        int rejectReasonIndex = this.getRejectReasonIndex(rejectReason);
        this.reject.text(LOGGED_ON_SESSION_REJECT_REASONS[rejectReasonIndex]);
        SessionHeaderEncoder header = this.reject.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        this.reject.refSeqNum(refSeqNum);
        this.reject.sessionRejectReason(rejectReason);
        long result = this.reject.encode(this.buffer, 0);
        return this.send(result, 51L, sequenceIndex, (Encoder)this.reject, msgSeqNo);
    }

    @Override
    public long sendTestRequest(int msgSeqNo, CharSequence testReqID, int sequenceIndex, int lastMsgSeqNumProcessed) {
        SessionHeaderEncoder header = this.testRequest.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        this.testRequest.testReqID(testReqID);
        long result = this.testRequest.encode(this.buffer, 0);
        return this.send(result, 49L, sequenceIndex, (Encoder)this.testRequest, msgSeqNo);
    }

    @Override
    public long sendSequenceReset(int msgSeqNo, int newSeqNo, int sequenceIndex, int lastMsgSeqNumProcessed) {
        SessionHeaderEncoder header = this.sequenceReset.header();
        this.setupHeader(header, msgSeqNo, lastMsgSeqNumProcessed);
        this.sequenceReset.newSeqNo(newSeqNo);
        long result = this.sequenceReset.encode(this.buffer, 0);
        return this.send(result, 52L, sequenceIndex, (Encoder)this.sequenceReset, msgSeqNo);
    }

    private void setupHeader(SessionHeaderEncoder header, int msgSeqNo, int lastMsgSeqNumProcessed) {
        UtcTimestampEncoder timestampEncoder = this.timestampEncoder;
        int length = timestampEncoder.updateFrom(this.clock.nanoTime(), TimeUnit.NANOSECONDS);
        header.sendingTime(timestampEncoder.buffer(), length);
        header.msgSeqNum(msgSeqNo);
        if (lastMsgSeqNumProcessed != -1) {
            header.lastMsgSeqNumProcessed(lastMsgSeqNumProcessed);
        }
    }

    private long send(long result, long messageType, int sequenceIndex, Encoder encoder, int msgSeqNo) {
        if (!this.libraryConnected) {
            return -2147483647L;
        }
        int length = Encoder.length((long)result);
        int offset = Encoder.offset((long)result);
        long position = this.gatewayPublication.saveMessage((DirectBuffer)this.buffer, offset, length, this.libraryId, messageType, this.sessionId, sequenceIndex, this.connectionId, MessageStatus.OK, msgSeqNo);
        encoder.resetMessage();
        if (position > 0L) {
            DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, messageType, "Sent ", (DirectBuffer)this.buffer, offset, length);
            this.lastSentPosition = position;
        }
        return position;
    }

    private int getRejectReasonIndex(int rejectReason) {
        return rejectReason == RejectReason.OTHER.representation() ? 19 : rejectReason;
    }

    public long lastSentPosition() {
        return this.lastSentPosition;
    }

    @Override
    public void libraryConnected(boolean libraryConnected) {
        this.libraryConnected = libraryConnected;
    }

    @Override
    public boolean seqNumResetRequested() {
        return this.seqNumResetRequested;
    }

    @Override
    public long sendCancelOnDisconnectTrigger(long sessionId, long timeInNs) {
        return this.gatewayPublication.saveCancelOnDisconnectTrigger(sessionId, timeInNs);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    static {
        RejectReason[] reasons = RejectReason.values();
        for (int i = 0; i < REJECT_COUNT; ++i) {
            RejectReason reason = reasons[i];
            String formattedReason = reason.name().replace('_', ' ').toLowerCase();
            DirectSessionProxy.NOT_LOGGED_ON_SESSION_REJECT_REASONS[i] = String.format("Invalid Logon message: SendingTime accuracy problem, field=52, reason=%s", formattedReason).getBytes(StandardCharsets.US_ASCII);
            DirectSessionProxy.LOGGED_ON_SESSION_REJECT_REASONS[i] = reason == RejectReason.VALUE_IS_INCORRECT ? "Value is incorrect (out of range) for this tag".getBytes(StandardCharsets.US_ASCII) : formattedReason.getBytes(StandardCharsets.US_ASCII);
        }
    }
}

