/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixp;

import java.lang.reflect.InvocationTargetException;
import org.agrona.ErrorHandler;
import uk.co.real_logic.artio.fixp.FixPProtocol;
import uk.co.real_logic.artio.messages.FixPProtocolType;

public final class FixPProtocolFactory {
    public static boolean isAcceptorImplemented(FixPProtocolType fixPProtocolType) {
        return fixPProtocolType == FixPProtocolType.BINARY_ENTRYPOINT;
    }

    public static FixPProtocol make(FixPProtocolType protocol, ErrorHandler errorHandler) {
        switch (protocol) {
            case ILINK_3: {
                return FixPProtocolFactory.make("uk.co.real_logic.artio.ilink.Ilink3Protocol", errorHandler);
            }
            case BINARY_ENTRYPOINT: {
                return FixPProtocolFactory.make("uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointProtocol", errorHandler);
            }
        }
        throw new IllegalArgumentException("Unknown protocol: " + String.valueOf(protocol));
    }

    private static FixPProtocol make(String className, ErrorHandler errorHandler) {
        try {
            Class<?> cls = Class.forName(className);
            return (FixPProtocol)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (errorHandler != null) {
                errorHandler.onError((Throwable)e);
            }
            return null;
        }
    }
}

