/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixp;

import java.util.List;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.sbe.MessageDecoderFlyweight;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;

public class FixPMessageDissector {
    private final Int2ObjectHashMap<Decoder> templateIdToDecoder = new Int2ObjectHashMap();
    private final Logger logger;

    public FixPMessageDissector(List<? extends MessageDecoderFlyweight> decoders) {
        this(FixPMessageDissector::logDefault, decoders);
    }

    public FixPMessageDissector(Logger logger, List<? extends MessageDecoderFlyweight> decoders) {
        this.logger = logger;
        for (MessageDecoderFlyweight messageDecoderFlyweight : decoders) {
            this.templateIdToDecoder.put(messageDecoderFlyweight.sbeTemplateId(), (Object)new Decoder(messageDecoderFlyweight));
        }
    }

    public void onBusinessMessage(int templateId, DirectBuffer buffer, int offset, int blockLength, int version, boolean inbound) {
        Decoder decoder = (Decoder)this.templateIdToDecoder.get(templateId);
        if (decoder != null) {
            decoder.onMessage(buffer, offset, blockLength, version, inbound);
        }
    }

    private static void logDefault(String prefix, Consumer<StringBuilder> appendTo) {
        DebugLogger.logSbeDecoder(LogTag.FIXP_BUSINESS, prefix, appendTo);
    }

    public static interface Logger {
        public void log(String var1, Consumer<StringBuilder> var2);
    }

    class Decoder {
        private final MessageDecoderFlyweight flyweight;
        private final Consumer<StringBuilder> appendTo;

        Decoder(MessageDecoderFlyweight flyweight) {
            this.flyweight = flyweight;
            this.appendTo = arg_0 -> ((MessageDecoderFlyweight)flyweight).appendTo(arg_0);
        }

        public void onMessage(DirectBuffer buffer, int offset, int blockLength, int version, boolean inbound) {
            this.flyweight.wrap(buffer, offset, blockLength, version);
            FixPMessageDissector.this.logger.log(inbound ? "> " : "< ", this.appendTo);
        }
    }
}

