/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.util.CharFormatter;

public final class RecordingRange {
    private static final ThreadLocal<CharFormatter> CURRENT_POSITION = ThreadLocal.withInitial(() -> new CharFormatter("currentPosition == addPosition, %s%n"));
    final long recordingId;
    final long sessionId;
    long position = Long.MIN_VALUE;
    long length;
    int count;

    RecordingRange(long recordingId, long sessionId) {
        this.recordingId = recordingId;
        this.sessionId = sessionId;
        this.count = 0;
    }

    void add(long addPosition, int addLength) {
        long currentPosition = this.position;
        if (currentPosition == Long.MIN_VALUE) {
            this.position = addPosition;
            this.length = addLength;
            return;
        }
        long currentEnd = currentPosition + this.length;
        long addEnd = addPosition + (long)addLength;
        long newEnd = Math.max(currentEnd, addEnd);
        if (currentPosition < addPosition) {
            this.length = newEnd - currentPosition;
        } else if (addPosition < currentPosition) {
            this.position = addPosition;
            this.length = newEnd - addPosition;
        } else if (DebugLogger.isEnabled(LogTag.INDEX)) {
            DebugLogger.log(LogTag.INDEX, CURRENT_POSITION.get().clear().with(currentPosition));
        }
    }

    public String toString() {
        return "RecordingRange{recordingId=" + this.recordingId + ", sessionId=" + this.sessionId + ", position=" + this.position + ", length=" + this.length + ", count=" + this.count + "}";
    }
}

