/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.archive.status.RecordingPos;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;

public class RecordingIdLookup {
    private final Long2LongHashMap aeronSessionIdToRecordingId = new Long2LongHashMap(-1L);
    private final long archiveId;
    private final IdleStrategy archiverIdleStrategy;
    private final CountersReader counters;

    @Deprecated
    public RecordingIdLookup(IdleStrategy archiverIdleStrategy, CountersReader counters) {
        this(-1L, archiverIdleStrategy, counters);
    }

    public RecordingIdLookup(long archiveId, IdleStrategy archiverIdleStrategy, CountersReader counters) {
        this.archiveId = archiveId;
        this.archiverIdleStrategy = archiverIdleStrategy;
        this.counters = counters;
    }

    public long getRecordingId(int aeronSessionId) {
        long recordingId = this.aeronSessionIdToRecordingId.get((long)aeronSessionId);
        while (recordingId == -1L) {
            recordingId = this.checkRecordingId(aeronSessionId);
            this.archiverIdleStrategy.idle();
        }
        this.archiverIdleStrategy.reset();
        return recordingId;
    }

    long findRecordingId(int aeronSessionId) {
        long recordingId = this.aeronSessionIdToRecordingId.get((long)aeronSessionId);
        if (recordingId == -1L) {
            recordingId = this.checkRecordingId(aeronSessionId);
        }
        return recordingId;
    }

    private long checkRecordingId(int aeronSessionId) {
        int counterId = RecordingPos.findCounterIdBySession((CountersReader)this.counters, (int)aeronSessionId, (long)this.archiveId);
        if (counterId == -1) {
            return -1L;
        }
        long recordingId = RecordingPos.getRecordingId((CountersReader)this.counters, (int)counterId);
        if (recordingId != -1L) {
            this.aeronSessionIdToRecordingId.put((long)aeronSessionId, recordingId);
        }
        return recordingId;
    }
}

