/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Subscription;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.decoder.AbstractResendRequestDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.engine.ReplayerCommandQueue;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.logger.AbstractReplayer;
import uk.co.real_logic.artio.engine.logger.FixReplayerCodecs;
import uk.co.real_logic.artio.engine.logger.FixSessionCodecsFactory;
import uk.co.real_logic.artio.engine.logger.GapFillEncoder;
import uk.co.real_logic.artio.engine.logger.ReplayTimestamper;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;

public class GapFiller
extends AbstractReplayer {
    private final ReplayerCommandQueue replayerCommandQueue;
    private final Subscription inboundSubscription;
    private final GatewayPublication publication;
    private final String agentNamePrefix;
    private final ReplayTimestamper timestamper;
    private AbortState abortState;

    public GapFiller(Subscription inboundSubscription, GatewayPublication publication, String agentNamePrefix, SenderSequenceNumbers senderSequenceNumbers, ReplayerCommandQueue replayerCommandQueue, FixSessionCodecsFactory fixSessionCodecsFactory, EpochNanoClock clock, DutyCycleTracker dutyCycleTracker) {
        super(publication.dataPublication(), fixSessionCodecsFactory, new BufferClaim(), senderSequenceNumbers, clock, dutyCycleTracker);
        this.inboundSubscription = inboundSubscription;
        this.publication = publication;
        this.agentNamePrefix = agentNamePrefix;
        this.replayerCommandQueue = replayerCommandQueue;
        this.timestamper = new ReplayTimestamper(publication.dataPublication(), clock);
    }

    public int doWork() {
        long timeInNs = this.clock.nanoTime();
        this.trackDutyCycleTime(timeInNs);
        this.timestamper.sendTimestampMessage(timeInNs);
        return this.replayerCommandQueue.poll() + this.inboundSubscription.controlledPoll((ControlledFragmentHandler)this, 10);
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int start, int length, Header header) {
        if ((header.flags() & 0x80) != 128) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        this.messageHeader.wrap(buffer, start);
        int templateId = this.messageHeader.templateId();
        int offset = start + 8;
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        if (templateId == 59) {
            this.validResendRequest.wrap(buffer, offset, blockLength, version);
            long sessionId = this.validResendRequest.session();
            long connectionId = this.validResendRequest.connection();
            int beginSeqNo = (int)this.validResendRequest.beginSequenceNumber();
            int endSeqNo = (int)this.validResendRequest.endSequenceNumber();
            int sequenceIndex = this.validResendRequest.sequenceIndex();
            long correlationId = this.validResendRequest.correlationId();
            this.validResendRequest.wrapBody((DirectBuffer)this.asciiBuffer);
            return this.onResendRequest(sessionId, connectionId, beginSeqNo, endSeqNo, sequenceIndex, correlationId);
        }
        return this.fixSessionCodecsFactory.onFragment(buffer, start, length, header);
    }

    private ControlledFragmentHandler.Action onResendRequest(long sessionId, long connectionId, int beginSeqNo, int endSeqNo, int sequenceIndex, long correlationId) {
        if (this.checkDisconnected(connectionId)) {
            this.abortState = null;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        FixReplayerCodecs fixReplayerCodecs = this.fixSessionCodecsFactory.get(sessionId);
        if (fixReplayerCodecs == null) {
            this.abortState = null;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (this.checkAbortState(AbortState.ON_START_REPLAY) && this.trySendStartReplay(sessionId, connectionId, correlationId)) {
            this.abortState = AbortState.ON_START_REPLAY;
            return ControlledFragmentHandler.Action.ABORT;
        }
        if (this.checkAbortState(AbortState.ON_GAP_FILL)) {
            AbstractResendRequestDecoder resendRequest = fixReplayerCodecs.resendRequest();
            GapFillEncoder encoder = fixReplayerCodecs.gapFillEncoder();
            resendRequest.decode(this.asciiBuffer, 0, this.asciiBuffer.capacity());
            SessionHeaderDecoder reqHeader = resendRequest.header();
            int gapFillMsgSeqNum = beginSeqNo;
            encoder.setupMessage(reqHeader);
            long result = encoder.encode(gapFillMsgSeqNum, endSeqNo + 1);
            int encodedLength = Encoder.length((long)result);
            int encodedOffset = Encoder.offset((long)result);
            long sentPosition = this.publication.saveMessage((DirectBuffer)encoder.buffer(), encodedOffset, encodedLength, 0, 52L, sessionId, sequenceIndex, connectionId, MessageStatus.OK, gapFillMsgSeqNum);
            if (Pressure.isBackPressured(sentPosition)) {
                this.abortState = AbortState.ON_GAP_FILL;
                return ControlledFragmentHandler.Action.ABORT;
            }
        }
        if (this.sendCompleteMessage(connectionId, correlationId)) {
            this.abortState = null;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        this.abortState = AbortState.ON_SEND_COMPLETE;
        return ControlledFragmentHandler.Action.ABORT;
    }

    private boolean checkAbortState(AbortState requiredState) {
        AbortState abortState = this.abortState;
        return abortState == null || abortState.compareTo(requiredState) <= 0;
    }

    public String roleName() {
        return this.agentNamePrefix + "GapFiller";
    }

    private static enum AbortState {
        ON_START_REPLAY,
        ON_GAP_FILL,
        ON_SEND_COMPLETE;

    }
}

