/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.archive.client.AeronArchive;
import io.aeron.driver.MediaDriver;
import java.io.PrintStream;
import java.util.function.Predicate;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.ArtioLogHeader;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.logger.FixArchiveScanner;
import uk.co.real_logic.artio.engine.logger.FixMessagePredicate;
import uk.co.real_logic.artio.engine.logger.FixMessagePredicates;
import uk.co.real_logic.artio.engine.logger.LazyFixPMessagePrinter;
import uk.co.real_logic.artio.fixp.FixPMessageConsumer;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.MessageStatus;

public final class FixArchivePrinter {
    private static final char SOH = '\u0001';
    private FixPProtocolType fixPProtocolType = FixPProtocolType.ILINK_3;
    private String logFileDir = null;
    private final IntHashSet queryStreamIds = new IntHashSet();
    private String aeronDirectoryName = null;
    private String aeronChannel = null;
    private String offlineArchiveDirectoryName = null;
    private int archiveScannerStreamId = 5;
    private FixMessagePredicate predicate = FixMessagePredicates.alwaysTrue();
    private boolean follow = false;
    private boolean fixp = false;
    private char delimiter = '\u0001';
    private Class<? extends FixDictionary> fixDictionaryType = null;
    private Predicate<SessionHeaderDecoder> headerPredicate = null;
    private final PrintStream out;
    private final PrintStream err;

    public static void main(String[] args) {
        new FixArchivePrinter(System.out, System.err).scan(args);
    }

    public FixArchivePrinter(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    public void scan(String[] args) {
        this.parseArgs(args);
        this.validateArgs();
        ArchivingMediaDriver archivingMediaDriver = this.startArchiverIfNeeded();
        try {
            this.scanArchive(this.aeronDirectoryName, this.aeronChannel, this.queryStreamIds, this.predicate, this.follow, this.headerPredicate, this.archiveScannerStreamId, this.fixDictionaryType, this.fixPProtocolType, this.logFileDir);
        }
        finally {
            CloseHelper.close((AutoCloseable)archivingMediaDriver);
        }
    }

    private ArchivingMediaDriver startArchiverIfNeeded() {
        if (this.offlineArchiveDirectoryName == null) {
            return null;
        }
        Archive.Context archiveCtx = new Archive.Context().archiveDirectoryName(this.offlineArchiveDirectoryName);
        if (archiveCtx.controlChannel() == null) {
            AeronArchive.Context archiveClientCtx = new AeronArchive.Context().controlResponseChannel("aeron:udp?endpoint=localhost:0");
            archiveCtx.controlChannelEnabled(false).archiveClientContext(archiveClientCtx);
        }
        if (archiveCtx.replicationChannel() == null) {
            archiveCtx.replicationChannel("aeron:udp?endpoint=localhost:0");
        }
        return ArchivingMediaDriver.launch((MediaDriver.Context)new MediaDriver.Context().aeronDirectoryName(this.aeronDirectoryName), (Archive.Context)archiveCtx);
    }

    private void parseArgs(String[] args) {
        block51: for (String arg : args) {
            String optionName;
            int eqIndex = arg.indexOf(61);
            switch (optionName = eqIndex != -1 ? arg.substring(2, eqIndex) : arg.substring(2)) {
                case "help": {
                    this.printHelp();
                    System.exit(0);
                    break;
                }
                case "follow": {
                    this.follow = true;
                    break;
                }
                case "fixp": 
                case "ilink": {
                    this.fixp = true;
                    break;
                }
                default: {
                    this.requiredArgument(eqIndex);
                }
            }
            String optionValue = arg.substring(eqIndex + 1);
            switch (optionName) {
                case "from": {
                    this.predicate = FixMessagePredicates.from(Long.parseLong(optionValue)).and(this.predicate);
                    continue block51;
                }
                case "to": {
                    this.predicate = FixMessagePredicates.to(Long.parseLong(optionValue)).and(this.predicate);
                    continue block51;
                }
                case "message-types": {
                    String[] messageTypes = optionValue.split(",");
                    this.predicate = FixMessagePredicates.messageTypeOf(messageTypes).and(this.predicate);
                    continue block51;
                }
                case "sender-comp-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.senderCompIdOf(optionValue));
                    continue block51;
                }
                case "target-comp-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.targetCompIdOf(optionValue));
                    continue block51;
                }
                case "sender-sub-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.senderSubIdOf(optionValue));
                    continue block51;
                }
                case "target-sub-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.targetSubIdOf(optionValue));
                    continue block51;
                }
                case "sender-location-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.senderLocationIdOf(optionValue));
                    continue block51;
                }
                case "target-location-id": {
                    this.headerPredicate = FixArchivePrinter.safeAnd(this.headerPredicate, FixMessagePredicates.targetLocationIdOf(optionValue));
                    continue block51;
                }
                case "query-stream-id": {
                    this.queryStreamIds.add(Integer.parseInt(optionValue));
                    continue block51;
                }
                case "archive-scanner-stream-id": {
                    this.archiveScannerStreamId = Integer.parseInt(optionValue);
                    continue block51;
                }
                case "aeron-dir-name": {
                    this.aeronDirectoryName = optionValue;
                    continue block51;
                }
                case "aeron-channel": {
                    this.aeronChannel = optionValue;
                    continue block51;
                }
                case "offline-archive-dir": {
                    this.offlineArchiveDirectoryName = optionValue;
                    continue block51;
                }
                case "fix-dictionary": {
                    this.fixDictionaryType = FixDictionary.find((String)optionValue);
                    continue block51;
                }
                case "fixp-protocol": {
                    this.fixPProtocolType = FixPProtocolType.valueOf((String)optionValue.toUpperCase());
                    continue block51;
                }
                case "log-file-dir": {
                    this.logFileDir = optionValue;
                    continue block51;
                }
                case "delimiter": {
                    this.delimiter = optionValue.charAt(0);
                }
            }
        }
    }

    private void validateArgs() {
        if (this.fixDictionaryType == null && !this.fixp) {
            this.fixDictionaryType = FixDictionary.findDefault();
        }
        if (this.queryStreamIds.isEmpty()) {
            this.queryStreamIds.add(2);
        }
        this.requiredArgument(this.aeronDirectoryName, "aeron-dir-name");
        this.requiredArgument(this.aeronChannel, "aeron-channel");
    }

    private void requiredArgument(int eqIndex) {
        if (eqIndex == -1) {
            this.err.println("--ilink, --help and --follow are the only options that don't take a value");
            this.printHelp();
            System.exit(-1);
        }
    }

    private void scanArchive(String aeronDirectoryName, String aeronChannel, IntHashSet queryStreamIds, FixMessagePredicate otherPredicate, boolean follow, Predicate<SessionHeaderDecoder> headerPredicate, int archiveScannerStreamId, Class<? extends FixDictionary> fixDictionaryType, FixPProtocolType fixPProtocolType, String logFileDir) {
        FixDictionary fixDictionary = fixDictionaryType == null ? null : FixDictionary.of(fixDictionaryType);
        FixMessagePredicate predicate = otherPredicate;
        if (headerPredicate != null) {
            predicate = FixMessagePredicates.whereHeader(fixDictionary, headerPredicate).and(predicate);
        }
        FixArchiveScanner.Configuration configuration = new FixArchiveScanner.Configuration().aeronDirectoryName(aeronDirectoryName).idleStrategy(CommonConfiguration.backoffIdleStrategy());
        if (logFileDir != null) {
            configuration.logFileDir(logFileDir);
        }
        try (FixArchiveScanner scanner = new FixArchiveScanner(configuration);){
            this.out.println("Starting Scan ... ");
            scanner.scan(aeronChannel, queryStreamIds, FixMessagePredicates.filterBy(this::print, predicate), (FixPMessageConsumer)new LazyFixPMessagePrinter(1, fixPProtocolType), follow, archiveScannerStreamId);
        }
    }

    private void requiredArgument(String argument, String description) {
        if (argument == null) {
            this.err.printf("Missing required --%s argument%n", description);
            this.printHelp();
            System.exit(-1);
        }
    }

    private void printHelp() {
        this.out.println("FixArchivePrinter Options");
        this.out.println("All options are specified in the form: --optionName=optionValue");
        this.printOption("aeron-dir-name", "Specifies the media driver directory, should be the same as your aeronContext.aeronDirectoryName()", true);
        this.printOption("aeron-channel", "Specifies the aeron channel that was used by the engine", true);
        this.printOption("offline-archive-dir", "Enable offline mode using the given aeron archive directory. This is a good way to inspect the directory of a shutdown Artio instance. It starts a media driver and proceeds to inspect the provided aeron archive directory", false);
        this.printOption("fix-dictionary", "The class name of the FIX dictionary to use, default is used if this is not provided", false);
        this.printOption("ilink", "Deprecated: use --fixp.", false);
        this.printOption("fixp", "Suppresses the need to provide a FIX dictionary on the classpath - used for situations where only FIXP messages will be printed out", false);
        this.printOption("fixp-protocol", "Specifies the FIXP protocol type to be used to interpret protocol messages, defaults to iLink3", false);
        this.printOption("from", "Time in precision of CommonConfiguration.clock() that messages are not earlier than", false);
        this.printOption("to", "Time in precision of CommonConfiguration.clock() that messages are not later than", false);
        this.printOption("message-types", "Comma separated list of the message types (35=) that are printed", false);
        this.printOption("sender-comp-id", "Only print messages where the header's sender comp id field matches this", false);
        this.printOption("target-comp-id", "Only print messages where the header's target comp id field matches this", false);
        this.printOption("sender-sub-id", "Only print messages where the header's sender sub id field matches this", false);
        this.printOption("target-sub-id", "Only print messages where the header's target sub id field matches this", false);
        this.printOption("sender-location-id", "Only print messages where the header's sender location id field matches this", false);
        this.printOption("target-location-id", "Only print messages where the header's target location id field matches this", false);
        this.printOption("query-stream-id", "Only print messages where the query-stream-id matches this. This should be your configuration.inboundLibraryStream() or configuration.outboundLibraryStream(). Defaults to outbound. Can be used twice in order to print both inbound and outbound streams.", false);
        this.printOption("follow", "Continue to print out archive messages for a recording that is still in flight. Defaults to off.", false);
        this.printOption("help", "Only prints this help message.", false);
        this.printOption("log-file-dir", "Specifies a logFileDir option, this should be the same as provided to your EngineConfiguration. This can be used to optimize scans that are time based", false);
        this.printOption("delimiter", "Specifies the character which will replace the field delimiter (SOH) in printed messages", false);
    }

    private void printOption(String name, String description, boolean required) {
        this.out.printf("  --%-20s [%s] - %s%n", name, required ? "required" : "optional", description);
    }

    private static <T> Predicate<T> safeAnd(Predicate<T> left, Predicate<T> right) {
        return left == null ? right : left.and(right);
    }

    private void print(FixMessageDecoder message, DirectBuffer buffer, int offset, int length, ArtioLogHeader header) {
        MessageStatus status = message.status();
        long timestamp = message.timestamp();
        String body = message.body().replace('\u0001', this.delimiter);
        this.out.printf("%1$20s: %2$s (%3$s)%n", timestamp, body, status);
    }
}

