/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.Aeron;
import io.aeron.archive.client.AeronArchive;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.ReproductionClock;
import uk.co.real_logic.artio.engine.EngineReproductionConfiguration;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.framer.Continuation;
import uk.co.real_logic.artio.engine.framer.LiveLibraryInfo;
import uk.co.real_logic.artio.engine.framer.ReproductionProtocolHandler;
import uk.co.real_logic.artio.engine.framer.ReproductionTcpChannelSupplier;
import uk.co.real_logic.artio.engine.framer.StartReproduction;
import uk.co.real_logic.artio.engine.framer.TcpChannelSupplier;
import uk.co.real_logic.artio.engine.logger.FixArchiveScanningAgent;

class ReproductionPoller
implements Continuation {
    private final ReproductionClock clock;
    private final EngineReproductionConfiguration configuration;
    private final ReproductionProtocolHandler protocolHandler;
    private final String logFileDir;
    private final Aeron aeron;
    private final AeronArchive archive;
    private final String aeronChannel;
    private final int inboundLibraryStreamId;
    private final int reproductionReplayStream;
    private final IdleStrategy idleStrategy;
    private State state = State.AWAITING_SCANNER;
    private FixArchiveScanningAgent archiveScanningAgent;
    private StartReproduction startReproduction;
    private Int2ObjectHashMap<LiveLibraryInfo> idToLibrary;

    ReproductionPoller(EngineReproductionConfiguration configuration, TcpChannelSupplier channelSupplier, IdleStrategy idleStrategy, String logFileDir, RecordingCoordinator recordingCoordinator, String aeronChannel, int inboundLibraryStreamId, int reproductionReplayStream) {
        this.configuration = configuration;
        this.idleStrategy = idleStrategy;
        this.clock = configuration.clock();
        this.protocolHandler = new ReproductionProtocolHandler((ReproductionTcpChannelSupplier)channelSupplier, this.clock, this::onError);
        this.logFileDir = logFileDir;
        this.aeron = recordingCoordinator.aeron();
        this.archive = recordingCoordinator.archive();
        this.aeronChannel = aeronChannel;
        this.inboundLibraryStreamId = inboundLibraryStreamId;
        this.reproductionReplayStream = reproductionReplayStream;
    }

    private void onError(Throwable throwable) {
        throwable.printStackTrace();
        this.startReproduction.onError(throwable);
        this.state = State.COMPLETE;
    }

    @Override
    public long attempt() {
        switch (this.state) {
            case AWAITING_SCANNER: {
                return -2L;
            }
            case POLLING: {
                return this.pollArchive();
            }
        }
        return 1L;
    }

    private long pollArchive() {
        try {
            FixArchiveScanningAgent archiveScanningAgent = this.archiveScanningAgent;
            if (this.protocolHandler.operationInProgress()) {
                return -2L;
            }
            this.protocolHandler.resetCount();
            boolean complete = archiveScanningAgent.poll(1);
            this.protocolHandler.checkCount(1);
            if (complete) {
                this.startReproduction.onComplete();
                return this.complete();
            }
        }
        catch (Throwable e) {
            this.startReproduction.onError(e);
            return this.complete();
        }
        return -2L;
    }

    private long complete() {
        this.archiveScanningAgent = null;
        this.state = State.COMPLETE;
        return 1L;
    }

    void start(StartReproduction startReproduction, Int2ObjectHashMap<LiveLibraryInfo> idToLibrary) {
        this.startReproduction = startReproduction;
        this.idToLibrary = idToLibrary;
        this.protocolHandler.idToLibrary(idToLibrary);
        this.archiveScanningAgent = new FixArchiveScanningAgent(this.idleStrategy, 0x10000000, 0x3FFFFFFB, 1, this.logFileDir, this.aeron, this.archive);
        IntHashSet queryStreamIds = new IntHashSet();
        queryStreamIds.add(this.inboundLibraryStreamId);
        this.archiveScanningAgent.setup(this.aeronChannel, queryStreamIds, this.protocolHandler, null, false, this.reproductionReplayStream);
        this.state = State.POLLING;
    }

    long newConnectionId() {
        return this.protocolHandler.newConnectionId();
    }

    private static enum State {
        AWAITING_SCANNER,
        POLLING,
        COMPLETE;

    }
}

