/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Arrays;
import java.util.function.LongConsumer;
import java.util.stream.Stream;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.nio.TransportPoller;
import uk.co.real_logic.artio.engine.framer.InitiatorFixPReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.NioSelectedKeySet;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.messages.DisconnectReason;

class ReceiverEndPoints
extends TransportPoller {
    public static final String ARTIO_ITERATION_THRESHOLD_PROP_NAME = "fix.core.iteration.threshold";
    public static final int ARTIO_ITERATION_THRESHOLD = Integer.getInteger("fix.core.iteration.threshold", 5);
    private static final Field SELECTED_KEYS_FIELD;
    private static final Field PUBLIC_SELECTED_KEYS_FIELD;
    private final NioSelectedKeySet selectedKeySet = new NioSelectedKeySet();
    private final ErrorHandler errorHandler;
    private ReceiverEndPoint[] requiredPollingEndPoints = new ReceiverEndPoint[0];
    private ReceiverEndPoint[] endPoints = new ReceiverEndPoint[0];
    private ReceiverEndPoint backpressuredEndPoint = null;

    ReceiverEndPoints(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        try {
            SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
            PUBLIC_SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void add(ReceiverEndPoint endPoint) {
        if (endPoint.requiresAuthentication()) {
            this.addToRequiredPollingEndpoints(endPoint);
        } else {
            this.addToNormalEndpoints(endPoint, true);
        }
    }

    private void addToRequiredPollingEndpoints(ReceiverEndPoint endPoint) {
        this.requiredPollingEndPoints = (ReceiverEndPoint[])ArrayUtil.add((Object[])this.requiredPollingEndPoints, (Object)endPoint);
    }

    private void addToNormalEndpoints(ReceiverEndPoint endPoint, boolean register) {
        try {
            this.endPoints = (ReceiverEndPoint[])ArrayUtil.add((Object[])this.endPoints, (Object)endPoint);
            if (register) {
                endPoint.register(this.selector);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    void removeConnection(long connectionId, DisconnectReason reason) {
        Object[] endPoints = this.endPoints;
        int index = this.findAndCloseEndPoint(connectionId, reason, (ReceiverEndPoint[])endPoints);
        if (index != -1) {
            this.endPoints = (ReceiverEndPoint[])ArrayUtil.remove((Object[])endPoints, (int)index);
        } else {
            index = this.findAndCloseEndPoint(connectionId, reason, this.requiredPollingEndPoints);
            this.requiredPollingEndPoints = (ReceiverEndPoint[])ArrayUtil.remove((Object[])this.requiredPollingEndPoints, (int)index);
        }
        this.selectNowToForceProcessing();
    }

    void receiverEndPointPollingRequired(long connectionId) {
        Object[] endPoints = this.endPoints;
        int index = this.findEndPoint(connectionId, (ReceiverEndPoint[])endPoints);
        if (index != -1) {
            ReceiverEndPoint endPoint = endPoints[index];
            this.endPoints = (ReceiverEndPoint[])ArrayUtil.remove((Object[])endPoints, (int)index);
            this.addToRequiredPollingEndpoints(endPoint);
        } else {
            this.errorHandler.onError((Throwable)new Exception(String.format("Unable to make endpoint required for polling due to it not being found, connectionId=%d", connectionId)));
        }
    }

    void receiverEndPointPollingOptional(long connectionId, boolean register) {
        Object[] requiredPollingEndPoints = this.requiredPollingEndPoints;
        int index = this.findEndPoint(connectionId, (ReceiverEndPoint[])requiredPollingEndPoints);
        if (index != -1) {
            ReceiverEndPoint endPoint = requiredPollingEndPoints[index];
            this.requiredPollingEndPoints = (ReceiverEndPoint[])ArrayUtil.remove((Object[])requiredPollingEndPoints, (int)index);
            this.addToNormalEndpoints(endPoint, register);
        } else {
            this.errorHandler.onError((Throwable)new Exception(String.format("Unable to make endpoint no longer required for polling due to it not being found, connectionId=%d", connectionId)));
        }
    }

    private int findAndCloseEndPoint(long connectionId, DisconnectReason reason, ReceiverEndPoint[] endPoints) {
        int index = this.findEndPoint(connectionId, endPoints);
        if (index != -1) {
            endPoints[index].close(reason);
        }
        return index;
    }

    private int findEndPoint(long connectionId, ReceiverEndPoint[] endPoints) {
        int index = -1;
        int length = endPoints.length;
        for (int i = 0; i < length; ++i) {
            ReceiverEndPoint endPoint = endPoints[i];
            if (endPoint.connectionId() != connectionId) continue;
            index = i;
            break;
        }
        return index;
    }

    private void selectNowToForceProcessing() {
        try {
            this.selector.selectNow();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    int pollEndPoints() {
        int bytesReceived = 0;
        try {
            ReceiverEndPoint[] requiredPollingEndPoints = this.requiredPollingEndPoints;
            ReceiverEndPoint backpressuredEndPoint = this.backpressuredEndPoint;
            int numRequiredPollingEndPoints = requiredPollingEndPoints.length;
            if (backpressuredEndPoint != null) {
                if (backpressuredEndPoint.retryFrameMessages()) {
                    this.backpressuredEndPoint = null;
                    bytesReceived += this.pollNormalEndPoints(numRequiredPollingEndPoints);
                }
            } else {
                bytesReceived += this.pollNormalEndPoints(numRequiredPollingEndPoints);
            }
            bytesReceived = this.pollArray(bytesReceived, requiredPollingEndPoints, numRequiredPollingEndPoints);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesReceived;
    }

    private int pollNormalEndPoints(int numRequiredPollingEndPoints) throws IOException {
        int bytesReceived = 0;
        ReceiverEndPoint[] endPoints = this.endPoints;
        int numEndPoints = endPoints.length;
        int threshold = ARTIO_ITERATION_THRESHOLD - numRequiredPollingEndPoints;
        if (numEndPoints <= threshold) {
            bytesReceived = this.pollArray(bytesReceived, endPoints, numEndPoints);
        } else {
            int i;
            this.selector.selectNow();
            SelectionKey[] keys = this.selectedKeySet.keys();
            int size = this.selectedKeySet.size();
            for (i = 0; i < size; ++i) {
                SelectionKey key = keys[i];
                if (key == null) continue;
                ReceiverEndPoint endPoint = (ReceiverEndPoint)key.attachment();
                int polledBytes = endPoint.poll();
                if (polledBytes < 0) {
                    this.backpressuredEndPoint = endPoint;
                    bytesReceived -= polledBytes;
                    break;
                }
                bytesReceived += polledBytes;
            }
            if (i != 0) {
                if (i == size) {
                    this.selectedKeySet.reset();
                } else {
                    int skipCount = Math.min(i, this.selectedKeySet.size());
                    this.selectedKeySet.reset(skipCount);
                }
            }
        }
        return bytesReceived;
    }

    private int pollArray(int bytesAlreadyReceived, ReceiverEndPoint[] endPoints, int numRequiredPollingEndPoints) {
        int bytesReceived = bytesAlreadyReceived;
        for (int i = numRequiredPollingEndPoints - 1; i >= 0; --i) {
            bytesReceived += endPoints[i].poll();
        }
        return bytesReceived;
    }

    int size() {
        return this.requiredPollingEndPoints.length + this.endPoints.length;
    }

    void closeRequiredPollingEndPoints() {
        this.closeAll(this.requiredPollingEndPoints);
        this.requiredPollingEndPoints = new ReceiverEndPoint[0];
    }

    public void close() {
        this.closeRequiredPollingEndPoints();
        this.closeAll(this.endPoints);
        super.close();
    }

    private void closeAll(ReceiverEndPoint[] endPoints) {
        Stream.of(endPoints).forEach(receiverEndPoint -> receiverEndPoint.close(DisconnectReason.ENGINE_SHUTDOWN));
    }

    public void disconnectILinkConnections(int libraryId, LongConsumer removeFunc) {
        this.endPoints = ReceiverEndPoints.disconnectILinkConnections(libraryId, this.endPoints, removeFunc);
        this.requiredPollingEndPoints = ReceiverEndPoints.disconnectILinkConnections(libraryId, this.requiredPollingEndPoints, removeFunc);
        this.selectNowToForceProcessing();
    }

    static ReceiverEndPoint[] disconnectILinkConnections(int libraryId, ReceiverEndPoint[] endPoints, LongConsumer removeFunc) {
        int out = 0;
        int length = endPoints.length;
        for (int i = 0; i < length; ++i) {
            ReceiverEndPoint endPoint = endPoints[i];
            if (endPoint.libraryId() == libraryId && endPoint instanceof InitiatorFixPReceiverEndPoint) {
                removeFunc.accept(endPoint.connectionId());
                endPoint.close(DisconnectReason.LIBRARY_DISCONNECT);
                continue;
            }
            endPoints[out] = endPoint;
            ++out;
        }
        if (out < length) {
            return Arrays.copyOf(endPoints, out);
        }
        return endPoints;
    }

    public String toString() {
        return "ReceiverEndPoints{errorHandler=" + String.valueOf(this.errorHandler) + ", requiredPollingEndPoints=" + Arrays.toString(this.requiredPollingEndPoints) + ", endPoints=" + Arrays.toString(this.endPoints) + ", backpressuredEndPoint=" + String.valueOf(this.backpressuredEndPoint) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Field selectKeysField = null;
        Field publicSelectKeysField = null;
        try (Selector selector = Selector.open();){
            Class<?> clazz = Class.forName("sun.nio.ch.SelectorImpl", false, ClassLoader.getSystemClassLoader());
            if (clazz.isAssignableFrom(selector.getClass())) {
                selectKeysField = clazz.getDeclaredField("selectedKeys");
                selectKeysField.setAccessible(true);
                publicSelectKeysField = clazz.getDeclaredField("publicSelectedKeys");
                publicSelectKeysField.setAccessible(true);
            }
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        finally {
            SELECTED_KEYS_FIELD = selectKeysField;
            PUBLIC_SELECTED_KEYS_FIELD = publicSelectKeysField;
        }
    }
}

