/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.agrona.ErrorHandler;
import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.LivenessDetector;
import uk.co.real_logic.artio.engine.ConnectedSessionInfo;
import uk.co.real_logic.artio.engine.FixPConnectedSessionInfo;
import uk.co.real_logic.artio.engine.framer.ConnectingSession;
import uk.co.real_logic.artio.engine.framer.FixGatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;

final class LiveLibraryInfo
implements LibraryInfo {
    private final ErrorHandler errorHandler;
    private final int libraryId;
    private final String libraryName;
    private final LivenessDetector livenessDetector;
    private final int aeronSessionId;
    private final List<GatewaySession> allSessions = new CopyOnWriteArrayList<GatewaySession>();
    private final List<ConnectedSessionInfo> unmodifiableFixSessions;
    private final List<FixPConnectedSessionInfo> unmodifiableFixPConnections;
    private final Long2ObjectHashMap<ConnectingSession> correlationIdToConnectingSession = new Long2ObjectHashMap();
    private long acquireAtPosition;

    LiveLibraryInfo(ErrorHandler errorHandler, int libraryId, String libraryName, LivenessDetector livenessDetector, int aeronSessionId, boolean isFixP) {
        this.errorHandler = errorHandler;
        this.libraryId = libraryId;
        this.libraryName = libraryName;
        this.livenessDetector = livenessDetector;
        this.aeronSessionId = aeronSessionId;
        if (isFixP) {
            this.unmodifiableFixSessions = Collections.emptyList();
            this.unmodifiableFixPConnections = Collections.unmodifiableList(this.allSessions);
        } else {
            this.unmodifiableFixSessions = Collections.unmodifiableList(this.allSessions);
            this.unmodifiableFixPConnections = Collections.emptyList();
        }
    }

    @Override
    public int libraryId() {
        return this.libraryId;
    }

    @Override
    public String libraryName() {
        return this.libraryName;
    }

    @Override
    public List<ConnectedSessionInfo> sessions() {
        return this.unmodifiableFixSessions;
    }

    @Override
    public List<FixPConnectedSessionInfo> fixPConnections() {
        return this.unmodifiableFixPConnections;
    }

    public String toString() {
        return "LibraryInfo{libraryId=" + this.libraryId + ", allSessions=" + String.valueOf(this.allSessions) + "}";
    }

    int aeronSessionId() {
        return this.aeronSessionId;
    }

    List<GatewaySession> gatewaySessions() {
        return this.allSessions;
    }

    void onHeartbeat(long timeInMs) {
        this.livenessDetector.onHeartbeat(timeInMs);
    }

    int poll(long timeInMs) {
        return this.livenessDetector.poll(timeInMs);
    }

    boolean isConnected() {
        return this.livenessDetector.isConnected();
    }

    void addSession(GatewaySession session) {
        GatewaySession existingSession = this.removeSessionBySessionId(session.sessionId());
        if (existingSession != null && !existingSession.isOffline()) {
            IllegalStateException exception = new IllegalStateException("Session already exists for session id: " + session.sessionId() + " and it is not offline.");
            this.errorHandler.onError((Throwable)exception);
        }
        this.allSessions.add(session);
    }

    void removeSessionByConnectionId(long connectionId) {
        GatewaySessions.removeSessionByConnectionId(connectionId, this.allSessions);
    }

    void offlineSession(long connectionId) {
        List<GatewaySession> sessions = this.allSessions;
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.connectionId() != connectionId) continue;
            ((FixGatewaySession)session).goOffline();
        }
    }

    GatewaySession removeSessionBySessionId(long sessionId) {
        int index = GatewaySessions.indexBySessionId(sessionId, this.allSessions);
        return index == -1 ? null : this.allSessions.remove(index);
    }

    GatewaySession lookupSessionById(long sessionId) {
        int index = GatewaySessions.indexBySessionId(sessionId, this.allSessions);
        return index == -1 ? null : this.allSessions.get(index);
    }

    void removeSession(GatewaySession gatewaySession) {
        this.allSessions.remove(gatewaySession);
    }

    void acquireAtPosition(long libraryPosition) {
        this.acquireAtPosition = libraryPosition;
    }

    long acquireAtPosition() {
        return this.acquireAtPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveLibraryInfo that = (LiveLibraryInfo)o;
        return this.libraryId == that.libraryId;
    }

    public int hashCode() {
        return this.libraryId;
    }

    void connectionStartsConnecting(long correlationId, ConnectingSession connectingSession) {
        this.correlationIdToConnectingSession.put(correlationId, (Object)connectingSession);
    }

    ConnectingSession connectionFinishesConnecting(long correlationId) {
        return (ConnectingSession)this.correlationIdToConnectingSession.remove(correlationId);
    }
}

