/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.io.IOException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.engine.framer.FixPReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.FixPSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.FixPSenderEndPoints;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.ReproductionLogWriter;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.fixp.AbstractFixPOffsets;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;
import uk.co.real_logic.artio.messages.DisconnectReason;

class ImplicitFixPSenderEndPoint
extends FixPSenderEndPoint {
    private final int templateIdOffset;
    private final int retransmissionTemplateId;
    private final FixPSenderEndPoints fixPSenderEndPoints;
    private final ReattemptState normalBuffer = new ReattemptState();
    private final ReattemptState retransmitBuffer = new ReattemptState();
    private boolean retransmitting;
    private boolean requiresReattempting;

    protected ImplicitFixPSenderEndPoint(long connectionId, TcpChannel channel, ErrorHandler errorHandler, ExclusivePublication inboundPublication, ReproductionLogWriter reproductionLogWriter, int libraryId, int templateIdOffset, int retransmissionTemplateId, FixPSenderEndPoints fixPSenderEndPoints, AtomicCounter bytesInBuffer, int maxBytesInBuffer, Framer framer, FixPReceiverEndPoint receiverEndPoint) {
        super(connectionId, channel, errorHandler, inboundPublication, reproductionLogWriter, libraryId, bytesInBuffer, maxBytesInBuffer, framer, receiverEndPoint);
        this.templateIdOffset = templateIdOffset;
        this.retransmissionTemplateId = retransmissionTemplateId;
        this.fixPSenderEndPoints = fixPSenderEndPoints;
    }

    @Override
    public ControlledFragmentHandler.Action onMessage(DirectBuffer directBuffer, int offset, boolean retransmit) {
        try {
            int headerOffset = offset + 4;
            int templateId = AbstractFixPOffsets.templateId((DirectBuffer)directBuffer, (int)headerOffset, (int)this.templateIdOffset);
            int messageSize = SimpleOpenFramingHeader.readSofhMessageSize((DirectBuffer)directBuffer, (int)offset);
            if (this.retransmitting && !retransmit || !this.retransmitting && retransmit || this.reattemptBytesWritten > 0) {
                this.enqueue(directBuffer, offset, messageSize, retransmit);
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            int totalWritten = this.writeBuffer(directBuffer, offset, messageSize);
            if (totalWritten < messageSize) {
                this.reattemptBytesWritten = totalWritten;
                this.enqueue(directBuffer, offset, messageSize, retransmit);
            } else {
                this.reattemptBytesWritten = 0;
                if (templateId == this.retransmissionTemplateId) {
                    this.retransmitting = true;
                    this.processReattemptBuffer(true);
                    int secondOffset = offset + messageSize;
                    int secondSize = SimpleOpenFramingHeader.readSofhMessageSize((DirectBuffer)directBuffer, (int)secondOffset);
                    this.enqueue(directBuffer, secondOffset, secondSize, retransmit);
                }
            }
        }
        catch (IOException e) {
            this.errorHandler.onError((Throwable)e);
            this.receiverEndPoint.disconnectEndpoint(DisconnectReason.EXCEPTION);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onReplayComplete(long correlationId) {
        if (!this.retransmitting) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        if (!this.processReattemptBuffer(true)) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.retransmitting = false;
        this.processReattemptBuffer(false);
        return super.onReplayComplete(correlationId);
    }

    void enqueue(DirectBuffer srcBuffer, int srcOffst, int messageSize, boolean retransmit) {
        int bufferUsage;
        boolean currentStream;
        boolean bl = currentStream = retransmit == this.retransmitting;
        if (!this.requiresReattempting && currentStream) {
            this.requiresReattempting = true;
            this.fixPSenderEndPoints.backPressured(this);
        }
        ReattemptState reattemptState = this.reattemptState(retransmit);
        int reattemptOffset = reattemptState.usage;
        ExpandableDirectByteBuffer buffer = reattemptState.buffer();
        reattemptState.usage = bufferUsage = reattemptOffset + messageSize;
        if (currentStream) {
            if (bufferUsage > this.maxBytesInBuffer) {
                this.removeEndpoint(DisconnectReason.SLOW_CONSUMER);
            }
            this.bytesInBuffer.setOrdered((long)bufferUsage);
        }
        buffer.putBytes(reattemptOffset, srcBuffer, srcOffst, messageSize);
    }

    private void removeEndpoint(DisconnectReason reason) {
        this.framer.onDisconnect(this.libraryId, this.connectionId, reason);
    }

    private ReattemptState reattemptState(boolean retransmit) {
        return retransmit ? this.retransmitBuffer : this.normalBuffer;
    }

    private boolean processReattemptBuffer(boolean retransmit) {
        int offset;
        int totalWritten;
        ReattemptState reattemptState = this.reattemptState(retransmit);
        ExpandableDirectByteBuffer buffer = reattemptState.buffer;
        int reattemptBufferUsage = reattemptState.usage;
        for (offset = 0; offset < reattemptBufferUsage; offset += totalWritten) {
            try {
                int messageSize = SimpleOpenFramingHeader.readSofhMessageSize((DirectBuffer)buffer, (int)offset);
                totalWritten = this.writeBuffer((DirectBuffer)buffer, offset, messageSize);
                if (totalWritten < messageSize) {
                    this.reattemptBytesWritten = totalWritten;
                    break;
                }
                this.reattemptBytesWritten = 0;
                continue;
            }
            catch (IOException e) {
                this.errorHandler.onError((Throwable)e);
                break;
            }
        }
        int usage = reattemptState.shuffleWritten(offset);
        this.bytesInBuffer.setOrdered((long)usage);
        return usage == 0;
    }

    @Override
    public boolean reattempt() {
        boolean caughtUp = this.processReattemptBuffer(this.retransmitting);
        if (caughtUp) {
            this.requiresReattempting = false;
        }
        return caughtUp;
    }

    @Override
    public void onValidResendRequest(long correlationId) {
        if (correlationId == -1L) {
            this.retransmitting = true;
        }
    }

    static class ReattemptState {
        ExpandableDirectByteBuffer buffer;
        int usage;

        ReattemptState() {
        }

        ExpandableDirectByteBuffer buffer() {
            ExpandableDirectByteBuffer buffer = this.buffer;
            if (buffer == null) {
                buffer = this.buffer = new ExpandableDirectByteBuffer();
            }
            buffer.checkLimit(this.usage);
            return buffer;
        }

        int shuffleWritten(int written) {
            int usage = this.usage;
            if (written > 0) {
                this.buffer.putBytes(0, (DirectBuffer)this.buffer, written, usage -= written);
                this.usage = usage;
            }
            return usage;
        }
    }
}

